/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.adapter.TransportURLType;
import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.LineEndingType;
import de.pontonconsulting.xmlpipe.config.privatepartneragreement.XmlEncodingType;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.message.MessageException;
import de.pontonconsulting.xmlpipe.message.PayloadRecognizer;
import de.pontonconsulting.xmlpipe.message.ProcessingDirective;
import de.pontonconsulting.xmlpipe.message.XpEnvelope;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.message.identification.IEnvelopeRecognizer;
import de.pontonconsulting.xmlpipe.messenger.Messenger;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.messenger.util.XmlUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;

public class XpMessage
implements Serializable {
    private static final String TEXT_XML = "text/xml";
    public static final long serialVersionUID = 2582532871147978905L;
    public static final String PROTOCOL_FTP = "FTP";
    public static final String PROTOCOL_FTPS = "FTPS";
    public static final String XP_SCHEMA_SET = "ponton";
    public static final String XP_MESSAGE_VERSION = "2.1";
    public static final String XP_MSG_ACK = "ACK";
    public static final String XP_MSG_PING = "PING";
    public static final String XP_MSG_PONG = "PONG";
    public static final String XP_MSG_STATUS_REQUEST = "StatusRequest";
    public static final String XP_MSG_STATUS_RESPONSE = "StatusResponse";
    public static final String XP_MSG_CERT_UPDATE_REQUEST = "CertUpdateRequest";
    public static final String XP_MSG_CERT_UPDATE_RESPONSE = "CertUpdateResponse";
    public static final String XP_MSG_CERT_UPDATE_EXCEPTION = "CertUpdateException";
    public static final String XP_MSG_BINARY = "BINARY";
    public static final String XP_SCHEMA_BINARY = "BINARY";
    public static final String XP_MSG_VERSION_BINARY = "1";
    private File _currentContentReference;
    private File _currentContentReferenceFolder;
    private String _currentContentType = "text/xml";
    private File _signatureFileReference;
    private long _databaseId = -1L;
    private String _messageId;
    private String _fixedMessageId;
    private Date _messageTimestamp;
    private Date _registrationTimestamp;
    private String _conversationId;
    private long _conversationDatabaseId = -1L;
    private String _referenceId;
    private long _referenceDatabaseId = -1L;
    private int _sequenceNumber = -1;
    private long _internalSequenceNumber = -1L;
    private boolean _sequenceReset;
    private Date _timeToLive;
    private boolean _signedAckRequested;
    private String _adapterId;
    private int _messengerId;
    private String _senderLocalId;
    private String _receiverLocalId;
    private boolean _isStatusResponse;
    private boolean _isAck;
    private boolean _ackRequested;
    private boolean _syncReplyRequested;
    private String _protocol;
    private String _schemaLocation;
    private String _schemaNamespace;
    private String _messageType;
    private String _messageVersion;
    private String _schemaSet;
    private boolean _testMessage;
    private boolean _inbound;
    private Vector<XpMessageAttachment> _attachments = new Vector();
    private final HashMap<String, String> _processingDirectives = new HashMap();
    private String _payloadEncoding = XmlEncodingType.UTF_8.value();
    private String _payloadLineEnding = LineEndingType.LF.value();
    transient CppPartner ownPartner;
    transient CppPartner communicationPartner;
    private transient Agreement _agreement;
    private transient Communication _communication;
    public static final String PAYLOAD_IDENTIFIER = "payload-1.xml";
    private boolean _packaged;
    private String _messagePackaging;
    private String _senderInternalId;
    private String _receiverInternalId;
    private String _destinationUrl;
    private TransportURLType transportURLType = TransportURLType.DYNAMIC;
    private File _xpEnvelopeSchemaFile;
    private String _xpEnvelopeNamespaceUri;
    private String _xpEnvelopeName;
    private String _payloadXPath = "";
    private String _payloadRootElement;
    private String _payloadNamespaceUri;
    private String transferId;
    private boolean storeMessageInQueue = true;

    public boolean isInbound() {
        return this._inbound;
    }

    public void setInboundMessage(boolean inbound) {
        this._inbound = inbound;
    }

    public long getDatabaseId() {
        return this._databaseId;
    }

    public void setDatabaseId(long databaseId) {
        this._databaseId = databaseId;
    }

    public String getMessageId() {
        return this._messageId;
    }

    public String getFixedMessageId() {
        return this._fixedMessageId;
    }

    public void setMessageId(String messageId) {
        this._messageId = messageId;
        this._fixedMessageId = Messenger.getFixedFilename(messageId);
    }

    public String getConversationId() {
        return this._conversationId;
    }

    public void setConversationId(String conversationId) {
        this._conversationId = conversationId;
    }

    public long getConversationDatabaseId() {
        return this._conversationDatabaseId;
    }

    public void setConversationDatabaseId(long conversationDatabaseId) {
        this._conversationDatabaseId = conversationDatabaseId;
    }

    public String getReferenceId() {
        return this._referenceId;
    }

    public void setReferenceId(String referenceId) {
        this._referenceId = referenceId;
    }

    public long getReferenceDatabaseId() {
        return this._referenceDatabaseId;
    }

    public void setReferenceDatabaseId(long referenceDatabaseId) {
        this._referenceDatabaseId = referenceDatabaseId;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public boolean isSequenceReset() {
        return this._sequenceReset;
    }

    public void setSequenceNumber(int sequenceNumber) {
        if (sequenceNumber < 0 || sequenceNumber > 99999999) {
            throw new IllegalArgumentException("SequenceNumber has to be in range 0 - 99999999");
        }
        this._sequenceNumber = sequenceNumber;
    }

    public void setSequenceReset(boolean reset) {
        this._sequenceReset = reset;
    }

    public Date getMessageTimestamp() {
        return this._messageTimestamp;
    }

    public void setMessageTimestamp(Date messageTimestamp) {
        this._messageTimestamp = messageTimestamp;
    }

    public Date getRegistrationTimestamp() {
        return this._registrationTimestamp;
    }

    public void setRegistrationTimestamp(Date registrationTimestamp) {
        this._registrationTimestamp = registrationTimestamp;
    }

    public String getSenderLocalId() {
        return this._senderLocalId;
    }

    public void setSenderLocalId(String senderLocalId) {
        this._senderLocalId = senderLocalId;
    }

    public String getSenderInternalId() {
        return this._senderInternalId;
    }

    public void setSenderInternalId(String senderId) {
        this._senderInternalId = senderId;
    }

    public String getReceiverLocalId() {
        return this._receiverLocalId;
    }

    public void setReceiverLocalId(String receiverLocalId) {
        this._receiverLocalId = receiverLocalId;
    }

    public String getReceiverInternalId() {
        return this._receiverInternalId;
    }

    public void setReceiverInternalId(String receiverId) {
        this._receiverInternalId = receiverId;
    }

    public boolean isTestMessage() {
        return this._testMessage;
    }

    public void setTestMessage(boolean testMessage) {
        this._testMessage = testMessage;
    }

    public String getMessageType() {
        return this._messageType;
    }

    public void setMessageType(String messageType) {
        this._messageType = messageType;
    }

    public String getMessageVersion() {
        return this._messageVersion;
    }

    public void setMessageVersion(String dtdVersion) {
        this._messageVersion = dtdVersion;
    }

    public String getSchemaSet() {
        return this._schemaSet;
    }

    public void setSchemaSet(String dtdSet) {
        this._schemaSet = dtdSet;
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this._schemaLocation = schemaLocation;
    }

    public String getSchemaNamespace() {
        return this._schemaNamespace;
    }

    public void setSchemaNamespace(String schemaNamespace) {
        this._schemaNamespace = schemaNamespace;
    }

    public void addAttachment(XpMessageAttachment attachment) {
        if ("xp-signature".equals(attachment.getRole())) {
            this._attachments.addFirst(attachment);
        } else {
            this._attachments.add(attachment);
        }
    }

    public Iterator<XpMessageAttachment> getAttachmentIterator() {
        return this._attachments.iterator();
    }

    public boolean removeAttachmentFile(File reference) {
        boolean result = false;
        for (XpMessageAttachment element : this._attachments) {
            if (!element.getAttachment().equals(reference)) continue;
            this._attachments.remove(element);
            result = true;
            break;
        }
        return result;
    }

    public void removeAllAttachments() {
        this._attachments.clear();
    }

    public String getProcessingDirective(String type) {
        return this._processingDirectives.get(type);
    }

    public String[] getProcessingDirectiveAsStringArray(String type) {
        String value = this._processingDirectives.get(type);
        if (value == null) {
            return null;
        }
        return StringUtils.listToStringArray((String)value);
    }

    public String removeProcessingDirective(String type) {
        return this._processingDirectives.remove(type);
    }

    public Map<String, String> getProcessingDirectives() {
        return Collections.unmodifiableMap(this._processingDirectives);
    }

    public Map<String, String> getPayloadRelatedProcessingDirectives() {
        TreeMap<String, String> payloadRelatedProcessingDirectives = new TreeMap<String, String>();
        ArrayList helpList = new ArrayList(ProcessingDirective.PROCESSING_RELATED_PROCESSING_DIRECTIVES);
        helpList.addAll(ProcessingDirective.MESSAGE_TYPE_RELATED_PROCESSING_DIRECTIVES);
        for (String key : helpList) {
            String value = this._processingDirectives.get(key);
            if (value == null) continue;
            payloadRelatedProcessingDirectives.put(key, value);
        }
        return Collections.unmodifiableMap(payloadRelatedProcessingDirectives);
    }

    public Map<String, String> getCustomerProcessingDirectives() {
        TreeMap customerProcessingDirectives = new TreeMap();
        this._processingDirectives.forEach((key, value) -> {
            if (!ProcessingDirective.ALL_KNOWN_PROCESSING_DIRECTIVES.contains(key)) {
                customerProcessingDirectives.put(key, value);
            }
        });
        return Collections.unmodifiableMap(customerProcessingDirectives);
    }

    public Map<String, String> getMessageRelatedProcessingDirectives() {
        TreeMap<String, String> messageRelatedProcessingDirectives = new TreeMap<String, String>();
        ArrayList<String> helpList = new ArrayList<String>(ProcessingDirective.MESSENGER_RELATED_PROCESSING_DIRECTIVES);
        helpList.add("TestFlag");
        helpList.add("LogInfo");
        for (String key : helpList) {
            String value = this._processingDirectives.get(key);
            if (value == null) continue;
            messageRelatedProcessingDirectives.put(key, value);
        }
        return Collections.unmodifiableMap(messageRelatedProcessingDirectives);
    }

    public void setProcessingDirective(String type, String value) {
        this._processingDirectives.put(type, value);
    }

    public void setProcessingDirective(String type, String[] values) {
        this._processingDirectives.put(type, StringUtils.join((String[])values, (String)";"));
    }

    public void setProcessingDirectives(Map<String, String> processingDirectives) {
        if (processingDirectives != null) {
            this._processingDirectives.putAll(processingDirectives);
        }
    }

    public File getCurrentContentReference() {
        return this._currentContentReference;
    }

    public void setCurrentContentReference(File contentFile) {
        this._currentContentReference = contentFile;
        this.setCurrentContentReferenceFolder(contentFile.getParentFile());
    }

    public File getCurrentContentReferenceFolder() {
        return this._currentContentReferenceFolder;
    }

    public void setCurrentContentReferenceFolder(File contentFolder) {
        this._currentContentReferenceFolder = contentFolder;
        if (this._currentContentReference != null && contentFolder != null && !contentFolder.equals(this._currentContentReference.getParentFile())) {
            this._currentContentReference = new File(contentFolder, this._currentContentReference.getName());
        }
    }

    public String getCurrentContentType() {
        return this._currentContentType;
    }

    public void setCurrentContentType(String contentType) {
        this._currentContentType = contentType;
    }

    public String getAdapterId() {
        return this._adapterId;
    }

    public void setAdapterId(String adapterId) {
        this._adapterId = adapterId;
    }

    public Vector<XpMessageAttachment> getAttachments() {
        return this._attachments;
    }

    public void setAttachments(Vector<XpMessageAttachment> attachments) {
        this._attachments = attachments;
    }

    public boolean isAck() {
        return this._isAck;
    }

    public void setIsAck(boolean isAck) {
        this._isAck = isAck;
        if (this._isAck) {
            this.setIsStatusResponse(false);
        }
    }

    public boolean isPing() {
        return XP_SCHEMA_SET.equals(this.getSchemaSet()) && (XP_MSG_PING.equals(this.getMessageType()) || XP_MSG_STATUS_REQUEST.equals(this.getMessageType()) || XP_MSG_CERT_UPDATE_REQUEST.equals(this.getMessageType()));
    }

    public boolean isSignal() {
        return XP_SCHEMA_SET.equals(this.getSchemaSet());
    }

    public List<Integer> getRetryIntervals() {
        List<Integer> retryIntervals;
        List<Integer> list = retryIntervals = Objects.isNull(this.getCommunication()) ? Collections.emptyList() : this.getCommunication().getRetryIntervals();
        if (this.isPing()) {
            retryIntervals = retryIntervals.isEmpty() ? List.of(Integer.valueOf(20)) : List.of(retryIntervals.getFirst());
        }
        return retryIntervals;
    }

    public long getRetryDelay(Integer noOfRetry) {
        List<Integer> retryIntervals = this.getRetryIntervals();
        try {
            int index = Math.clamp((long)Objects.requireNonNullElse(noOfRetry, 0).intValue(), 0, retryIntervals.size() - 1);
            return (long)retryIntervals.get(index).intValue() * 1000L;
        }
        catch (IllegalArgumentException e) {
            return 20000L;
        }
    }

    public int getMaxNumberOfRetries() {
        return this.isPing() ? 0 : this.getCommunication().getNumberOfRetries();
    }

    public String getRealUrl(boolean isMessengerPingAllEnabled) throws TransportException {
        TransportURLType transportURLType;
        try {
            transportURLType = TransportURLType.valueOf((String)this.getDestinationUrl());
        }
        catch (IllegalArgumentException e) {
            transportURLType = TransportURLType.FIXED;
        }
        return switch (transportURLType) {
            default -> throw new MatchException(null, null);
            case TransportURLType.PRIMARY -> this.getCommunication().getTransportURL();
            case TransportURLType.FALLBACK -> this.getCommunication().getTransportFallbackURL();
            case TransportURLType.DYNAMIC -> {
                Agreement agreement = this.getAgreement();
                if (isMessengerPingAllEnabled && agreement.isPingAllEnabled()) {
                    yield this.getCommunication().getWorkingTransportURL();
                }
                yield this.getCommunication().getTransportURL();
            }
            case TransportURLType.FIXED -> this.getDestinationUrl();
        };
    }

    public void setSignatureReference(File file) {
        this._signatureFileReference = file;
    }

    public File getSignatureReference() {
        return this._signatureFileReference;
    }

    public Agreement getAgreement() {
        return this._agreement;
    }

    public CppPartner getSender() throws ProfileException {
        return this.getCppPartner(this.getSenderLocalId());
    }

    public CppPartner getReceiver() throws ProfileException {
        return this.getCppPartner(this.getReceiverLocalId());
    }

    private CppPartner getCppPartner(String partnerLocalId) throws ProfileException {
        if (partnerLocalId.equals(this.ownPartner.getLocalId())) {
            return this.ownPartner;
        }
        if (partnerLocalId.equals(this.communicationPartner.getLocalId())) {
            return this.communicationPartner;
        }
        throw new ProfileNotFoundException(-1, "Profile with the local id '" + partnerLocalId + "' is not found.");
    }

    public void setAgreement(Agreement agreement) {
        this._agreement = agreement;
    }

    public Communication getCommunication() {
        return this._communication;
    }

    @Deprecated
    public void setCommunication(Communication communication) {
        this._communication = communication;
    }

    public boolean isPackaged() {
        return this._packaged;
    }

    public void setPackaged(boolean packaged) {
        this._packaged = packaged;
    }

    public boolean isAckRequested() {
        return this._ackRequested;
    }

    public void setAckRequested(boolean ackRequested) {
        this._ackRequested = ackRequested;
    }

    public boolean isSyncReplyRequested() {
        return this._syncReplyRequested;
    }

    public void setSyncReplyRequested(boolean syncReplyRequested) {
        this._syncReplyRequested = syncReplyRequested;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String getMessagePackaging() {
        return this._messagePackaging;
    }

    public void setMessagePackaging(String messagePackaging) {
        this._messagePackaging = messagePackaging;
    }

    public int getMessengerId() {
        return this._messengerId;
    }

    public void setMessengerId(int messengerId) {
        this._messengerId = messengerId;
    }

    public PayloadRecognizer.RecognizePayloadResult recognizePayload() {
        return this.recognizePayload(false);
    }

    public PayloadRecognizer.RecognizePayloadResult recognizePayload(boolean forceContentParsing) {
        PayloadRecognizer recognizer;
        PayloadRecognizer.RecognizePayloadResult payloadResult;
        File payloadFile = this.getCurrentContentReference();
        String messageType = this.getMessageType();
        String messageVersion = this.getMessageVersion();
        String schemaSet = this.getSchemaSet();
        String schemaLocation = this.getSchemaLocation();
        if (payloadFile == null || !payloadFile.isFile() || !forceContentParsing && messageType != null && messageVersion != null && schemaSet != null) {
            PayloadRecognizer recognizer2 = this.getAgreement().getPayloadRecognizer();
            return new PayloadRecognizer.RecognizePayloadResult(recognizer2.getDocumentType(messageType, messageVersion, schemaSet));
        }
        if (XmlUtil.isXml(payloadFile.getPath())) {
            try {
                String logInfo;
                String namespace;
                IEnvelopeRecognizer envelopeRecognizer = this.getAgreement().getEnvelopeRecognizer();
                XpEnvelope xpEnvelope = envelopeRecognizer.recognizeEnvelope(payloadFile);
                this.setXpEnvelopeNamespaceUri(xpEnvelope.getNamespace());
                this.setXpEnvelopeSchemaFile(xpEnvelope.getSchemaFile());
                this.setXpEnvelopeName(xpEnvelope.getName());
                if (xpEnvelope.getPayloadXPath() != null) {
                    this.setPayloadXPath(xpEnvelope.getPayloadXPath());
                }
                this.setPayloadRootElement(xpEnvelope.getPayloadElement());
                this.setPayloadNamespaceUri(xpEnvelope.getPayloadNamespace());
                if (messageType == null || messageType.equals("*")) {
                    messageType = xpEnvelope.getMessageType();
                }
                if (messageVersion == null) {
                    messageVersion = xpEnvelope.getMessageVersion();
                }
                if (schemaSet == null) {
                    schemaSet = xpEnvelope.getPayloadSchemaSet();
                }
                if (schemaLocation == null) {
                    schemaLocation = xpEnvelope.getPayloadSchemaLocation();
                }
                if ((namespace = this.getSchemaNamespace()) == null || namespace.length() == 0) {
                    this.setSchemaNamespace(xpEnvelope.getPayloadNamespace());
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(logInfo = this.getProcessingDirective("LogInfo"))) && xpEnvelope.getLogInfo() != null) {
                    this.setProcessingDirective("LogInfo", xpEnvelope.getLogInfo());
                }
                if (this.getProcessingDirective("TestFlag") == null && xpEnvelope.getTestFlag() != null && xpEnvelope.getTestFlag().equals(xpEnvelope.getTestTrueValue())) {
                    this.setTestMessage(true);
                }
            }
            catch (MessageException envelopeRecognizer) {
                // empty catch block
            }
        }
        if ((payloadResult = (recognizer = this.getAgreement().getPayloadRecognizer()).recognizePayload(payloadFile, messageType, messageVersion, schemaSet, schemaLocation, this.getPayloadXPath(), this._payloadRootElement, this._payloadNamespaceUri)).isValid()) {
            this.setMessageType(payloadResult.documentType().getType());
            this.setMessageVersion(payloadResult.documentType().getVersion());
            this.setSchemaSet(payloadResult.documentType().getSchemaSet());
            this.setSchemaLocation(payloadResult.documentType().getSchemalocation());
            this.setSchemaNamespace(payloadResult.documentType().getNamespace());
            this.setProcessingDirective("MessageType", this.getMessageType());
            this.setProcessingDirective("DtdVersion", this.getMessageVersion());
            this.setProcessingDirective("DtdSet", this.getSchemaSet());
        }
        return payloadResult;
    }

    public void updateAttachments(File newWork) {
        for (XpMessageAttachment attachment : this._attachments) {
            File attachmentFolder = new File(newWork, "attachments");
            attachment.setAttachment(new File(attachmentFolder, attachment.getAttachment().getName()));
        }
    }

    public boolean isStatusResponse() {
        return this._isStatusResponse;
    }

    public void setIsStatusResponse(boolean isStatusResponse) {
        this._isStatusResponse = isStatusResponse;
        if (this._isStatusResponse) {
            this.setIsAck(false);
        }
    }

    @Deprecated
    public String getPayloadEncoding() {
        return this._payloadEncoding;
    }

    @Deprecated
    public void setPayloadEncoding(String payloadEncoding) {
        this._payloadEncoding = payloadEncoding;
    }

    @Deprecated
    public String getPayloadLineEnding() {
        return this._payloadLineEnding;
    }

    @Deprecated
    public void setPayloadLineEnding(String payloadLineEnding) {
        this._payloadLineEnding = payloadLineEnding;
    }

    public Date getTimeToLive() {
        return this._timeToLive;
    }

    public void setTimeToLive(Date timeToLive) {
        this._timeToLive = timeToLive;
    }

    public boolean isSignedAckRequested() {
        return this._signedAckRequested;
    }

    public void setSignedAckRequested(boolean signedAckRequested) {
        this._signedAckRequested = signedAckRequested;
    }

    public long getInternalSequenceNumber() {
        return this._internalSequenceNumber;
    }

    public void setInternalSequenceNumber(long internalSequenceNumber) {
        this._internalSequenceNumber = internalSequenceNumber;
    }

    public void setDestinationUrl(String destinationUrl) {
        if (Objects.isNull(destinationUrl)) {
            this._destinationUrl = null;
            this.setProtocol(null);
            return;
        }
        if (this._destinationUrl == null || !this._destinationUrl.equals(destinationUrl)) {
            int index = destinationUrl.indexOf(58);
            String protocol = null;
            if (index != -1) {
                protocol = destinationUrl.substring(0, index);
                this.setProtocol(protocol.toUpperCase());
            }
        }
        this._destinationUrl = destinationUrl;
    }

    public String getDestinationUrl() {
        return this._destinationUrl;
    }

    public File getXpEnvelopeSchemaFile() {
        return this._xpEnvelopeSchemaFile;
    }

    public void setXpEnvelopeSchemaFile(File xpEnvelopeSchemaFile) {
        this._xpEnvelopeSchemaFile = xpEnvelopeSchemaFile;
    }

    public String getXpEnvelopeNamespaceUri() {
        return this._xpEnvelopeNamespaceUri;
    }

    public void setXpEnvelopeNamespaceUri(String xpEnvelopeNamespaceUri) {
        this._xpEnvelopeNamespaceUri = xpEnvelopeNamespaceUri;
    }

    public String getXpEnvelopeName() {
        return this._xpEnvelopeName;
    }

    public void setXpEnvelopeName(String xpEnvelopeName) {
        this._xpEnvelopeName = xpEnvelopeName;
    }

    public String getPayloadXPath() {
        return this._payloadXPath;
    }

    public void setPayloadXPath(String payloadXPath) {
        this._payloadXPath = payloadXPath;
    }

    public String getPayloadRootElement() {
        return this._payloadRootElement;
    }

    public void setPayloadRootElement(String payloadRootElement) {
        this._payloadRootElement = payloadRootElement;
    }

    public String getPayloadNamespaceUri() {
        return this._payloadNamespaceUri;
    }

    public void setPayloadNamespaceUri(String payloadNamespaceUri) {
        this._payloadNamespaceUri = payloadNamespaceUri;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TransportURLType getTransportURLType() {
        return this.transportURLType;
    }

    public XpMessage setTransportURLType(TransportURLType transportURLType) {
        this.transportURLType = transportURLType;
        return this;
    }

    public boolean isStoreMessageInQueue() {
        return this.storeMessageInQueue;
    }

    public void setStoreMessageInQueue(boolean storeMessageInQueue) {
        this.storeMessageInQueue = storeMessageInQueue;
    }

    public CppPartner getOwnPartner() {
        return this.ownPartner;
    }

    public XpMessage setOwnPartner(CppPartner ownPartner) {
        this.ownPartner = ownPartner;
        return this;
    }

    public CppPartner getCommunicationPartner() {
        return this.communicationPartner;
    }

    public XpMessage setCommunicationPartner(CppPartner communicationPartner) {
        this.communicationPartner = communicationPartner;
        return this;
    }
}

