/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.listener.ErrorNotificationResult;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.errornotification.CodeType;
import de.pontonconsulting.xmlpipe.message.errornotification.ObjectFactory;
import de.pontonconsulting.xmlpipe.message.errornotification.XpErrorNotification;
import de.pontonconsulting.xmlpipe.message.signals.XpSignal;
import de.pontonconsulting.xmlpipe.soap.ebxml.DateTime;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XpErrorNotification {
    private static final Logger LOG = LogManager.getLogger(XpErrorNotification.class);
    private static final String XP_ERROR_NOTIFICATION_CLASSES = "de.pontonconsulting.xmlpipe.message.errornotification";
    private static ObjectFactory _factory = new ObjectFactory();
    private final de.pontonconsulting.xmlpipe.message.errornotification.XpErrorNotification _errorNotification;
    private static JAXBContext _jaxbContext;

    public XpErrorNotification(byte[] errorNotificationBytes) throws JAXBException {
        Unmarshaller u = this.getUnmarshaller();
        ByteArrayInputStream errorNotificationStream = new ByteArrayInputStream(errorNotificationBytes);
        this._errorNotification = (de.pontonconsulting.xmlpipe.message.errornotification.XpErrorNotification)u.unmarshal((InputStream)errorNotificationStream);
    }

    public XpErrorNotification(File errorNotificationFile) throws JAXBException {
        Unmarshaller u = this.getUnmarshaller();
        this._errorNotification = (de.pontonconsulting.xmlpipe.message.errornotification.XpErrorNotification)u.unmarshal(errorNotificationFile);
    }

    public XpErrorNotification(XpMessage xpMessage, XpSignal xpSignal) throws JAXBException {
        this._errorNotification = _factory.createXpErrorNotification();
        this._errorNotification.setMessageId(xpMessage.getMessageId());
        this._errorNotification.setConversationId(xpMessage.getConversationId());
        this._errorNotification.setMessageType(xpMessage.getMessageType());
        this._errorNotification.setMessageVersion(xpMessage.getMessageVersion());
        this._errorNotification.setSchemaSet(xpMessage.getSchemaSet());
        this._errorNotification.setSender(xpMessage.getSenderInternalId());
        this._errorNotification.setReceiver(xpMessage.getReceiverInternalId());
        this._errorNotification.setMessageTime(this.toString(xpMessage.getMessageTimestamp()));
    }

    public File saveToDisk(File destinationFolder, String name) throws JAXBException {
        destinationFolder.mkdirs();
        File destination = new File(destinationFolder, name);
        Marshaller m = this.getMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new BufferedOutputStream(Files.newOutputStream(destination.toPath(), new OpenOption[0])));
            m.marshal((Object)this._errorNotification, (OutputStream)bos);
        }
        catch (IOException e) {
            throw new JAXBException("ErrorNotification file '" + String.valueOf(destination) + "' could not be opened for writing: " + e.getMessage());
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return destination;
    }

    private Marshaller getMarshaller() throws JAXBException {
        return _jaxbContext.createMarshaller();
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        return _jaxbContext.createUnmarshaller();
    }

    public File saveToDisk(File destinationFolder) throws JAXBException {
        destinationFolder.mkdirs();
        return this.saveToDisk(destinationFolder, "xpErrorNotitication.xml");
    }

    public void addError(ErrorNotificationResult.ErrorType errorType, String description) {
        List errorList = this._errorNotification.getResults();
        XpErrorNotification.Results newResult = _factory.createXpErrorNotificationResults();
        switch (errorType) {
            case CONTENT_VALIDATION_ERROR: {
                newResult.setCode(CodeType.CONTENT_VALIDATION_ERROR);
                break;
            }
            case DECOMPRESSION_ERROR: {
                newResult.setCode(CodeType.DECOMPRESSION_ERROR);
                break;
            }
            case DECRYPTION_ERROR: {
                newResult.setCode(CodeType.DECRYPTION_ERROR);
                break;
            }
            case OTHER_ERROR: {
                newResult.setCode(CodeType.OTHER_ERROR);
                break;
            }
            case PACKAGING_ERROR: {
                newResult.setCode(CodeType.PACKAGING_ERROR);
                break;
            }
            case SIGNATURE_ERROR: {
                newResult.setCode(CodeType.SIGNATURE_ERROR);
                break;
            }
            default: {
                LOG.warn("no error-mapping defined for {}. using OTHER_ERROR", (Object)errorType);
                newResult.setCode(CodeType.OTHER_ERROR);
            }
        }
        newResult.setDescription(description);
        errorList.add(newResult);
    }

    public String getMessageId() {
        return this._errorNotification.getMessageId();
    }

    public Date getMessageTime() {
        String time = this._errorNotification.getMessageTime();
        return this.toDate(time);
    }

    private Date toDate(String time) {
        Date result = null;
        if (time != null) {
            try {
                result = DateTime.parseDate(time);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    private String toString(Date date) {
        if (date != null) {
            return DateTime.formatDate(date);
        }
        return null;
    }

    public List<XpErrorNotification.Results> getResults() {
        return this._errorNotification.getResults();
    }

    public void setMessageId(String messageId) {
        this._errorNotification.setMessageId(messageId);
    }

    public void setMessageTime(Date messageTime) {
        this._errorNotification.setMessageTime(this.toString(messageTime));
    }

    static {
        try {
            _jaxbContext = JAXBContext.newInstance((String)XP_ERROR_NOTIFICATION_CLASSES);
        }
        catch (JAXBException e) {
            LOG.error("could not init JAXB context {}", (Object)XP_ERROR_NOTIFICATION_CLASSES);
            throw new RuntimeException("could not init error-notification JAXB context");
        }
    }
}

