/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.common.io.UTF8BOMSkippingInputStream;
import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.message.StAXXPath;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XmlParser {
    private static final Logger logger = LogManager.getLogger((String)"Messenger.XmlParser");

    public Map<StAXXPath, String> parse(InputStream inputStream, List<StAXXPath> xpaths) throws XmlParserException {
        return this.parse(inputStream, 16384, xpaths);
    }

    public Map<StAXXPath, String> parse(InputStream inputStream, int bufferSize, List<StAXXPath> xpaths) throws XmlParserException {
        HashMap<StAXXPath, String> resultMap = new HashMap<StAXXPath, String>();
        XMLInputFactory f = XMLInputFactory.newInstance();
        f.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        f.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        try (UTF8BOMSkippingInputStream in = new UTF8BOMSkippingInputStream(new BufferedInputStream(inputStream, bufferSize));
             AutoCloseableXmlStreamReader closeableReader = new AutoCloseableXmlStreamReader(this, f.createXMLStreamReader(in));){
            XMLStreamReader reader = closeableReader.getXmlStreamReader();
            Object currentXPath = "";
            int xpathLevel = 0;
            ArrayList<Object> xpath = new ArrayList<Object>();
            xpath.add(currentXPath);
            while (reader.hasNext() && resultMap.size() < xpaths.size()) {
                switch (reader.getEventType()) {
                    case 1: {
                        currentXPath = (String)xpath.get(xpathLevel) + "/" + reader.getName().getLocalPart();
                        xpath.add(++xpathLevel, currentXPath);
                        for (StAXXPath currentXPathElement : xpaths) {
                            currentXPathElement.handleStartElement(reader, xpathLevel, (String)currentXPath);
                        }
                        break;
                    }
                    case 2: {
                        for (StAXXPath currentXPathElement : xpaths) {
                            currentXPathElement.handleEndElement(xpathLevel);
                        }
                        --xpathLevel;
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 4: {
                        for (StAXXPath currentXPathElement : xpaths) {
                            currentXPathElement.handleText(reader);
                        }
                        break;
                    }
                }
                reader.next();
                for (StAXXPath currentXPathElement : xpaths) {
                    if (!currentXPathElement.isFound()) continue;
                    String value = currentXPathElement.getValue();
                    if (resultMap.containsKey(currentXPathElement)) {
                        List<String> allValues = currentXPathElement.getValues();
                        value = StringUtils.join((String[])((String[])allValues.toArray(String[]::new)));
                    }
                    resultMap.put(currentXPathElement, value);
                }
            }
        }
        catch (XMLStreamException xse) {
            logger.error("Unable to parse the input xml.", (Throwable)xse);
            throw new XmlParserException("Unable to parse the input xml.", xse);
        }
        catch (IOException ioe) {
            logger.error("Could not read the input xml.", (Throwable)ioe);
            throw new XmlParserException("Could not read the input xml.", ioe);
        }
        return resultMap;
    }

    private class AutoCloseableXmlStreamReader
    implements Closeable {
        private final XMLStreamReader xmlStreamReader;

        public AutoCloseableXmlStreamReader(XmlParser xmlParser, XMLStreamReader xmlStreamReader) {
            this.xmlStreamReader = Objects.requireNonNull(xmlStreamReader, "XMLStreamReader is null.");
        }

        @Override
        public void close() throws IOException {
            try {
                this.xmlStreamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }

        public XMLStreamReader getXmlStreamReader() {
            return this.xmlStreamReader;
        }
    }

    public class XmlParserException
    extends Exception {
        public XmlParserException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

