/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.schemaset.SchemaSet;
import de.pontonconsulting.xmlpipe.message.SchemasetParameter;
import de.pontonconsulting.xmlpipe.message.StAXXPath;
import de.pontonconsulting.xmlpipe.message.XmlParser;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlExtractor {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.XmlExtractor");

    private boolean hasContent(String text) {
        return text != null && !text.trim().isEmpty();
    }

    public void readMissingDataFromPayload(File payload, SchemaData schema, XpMessage xpMessage) {
        if (schema == null) {
            _log.warn("no schema is set for envelope mapping");
            return;
        }
        SchemaSet.Schema.EnvelopeMapping mapping = schema.getEnvelopeMapping();
        if (mapping == null) {
            _log.debug("no mapping is defined for schema {}", (Object)schema.getName());
            return;
        }
        String payloadPrefix = xpMessage.getPayloadXPath();
        boolean senderLookup = this.hasContent(mapping.getLocalPartyIdXPath()) && !this.hasContent(xpMessage.getSenderLocalId()) && !this.hasContent(xpMessage.getSenderInternalId());
        boolean receiverLookup = this.hasContent(mapping.getRemotePartyIdXPath()) && !this.hasContent(xpMessage.getReceiverLocalId()) && !this.hasContent(xpMessage.getReceiverInternalId());
        boolean logInfoLookup = this.hasContent(mapping.getLogInfoXPath());
        boolean messageIdLookup = this.hasContent(mapping.getMessageIdXPath()) && !this.hasContent(xpMessage.getMessageId());
        boolean conversationIdLookup = this.hasContent(mapping.getConversationIdXPath()) && !this.hasContent(xpMessage.getConversationId());
        boolean contentReceiverLookup = this.hasContent(mapping.getContentReceiverPartyIdXPath());
        List parameters = mapping.getContentXPath();
        ArrayList<SchemasetParameter> schemasetParameters = new ArrayList<SchemasetParameter>();
        if (parameters != null) {
            for (SchemaSet.Schema.EnvelopeMapping.ContentXPath parameter : parameters) {
                boolean repeatable = parameter.isRepeatable();
                String processingDirectiveName = parameter.getProcessingDirectiveName();
                String xPath = parameter.getValue();
                if (xpMessage.getProcessingDirective(processingDirectiveName) != null) continue;
                schemasetParameters.add(new SchemasetParameter(processingDirectiveName, xPath, repeatable));
            }
        }
        if (!(receiverLookup || senderLookup || messageIdLookup || conversationIdLookup || logInfoLookup || contentReceiverLookup || !schemasetParameters.isEmpty())) {
            return;
        }
        _log.debug("reading missing data from payload:{} payloadPrefix:{} schema:{}", (Object)payload, (Object)payloadPrefix, (Object)schema);
        if (schema.getEnvelopeMapping().getXPathType().equals("W3C")) {
            _log.debug("using w3c xpaths");
            this.evaluateW3CXPaths(payload, payloadPrefix, schema, senderLookup, receiverLookup, logInfoLookup, messageIdLookup, conversationIdLookup, contentReceiverLookup, xpMessage, schemasetParameters);
        } else {
            _log.debug("using ponton xpaths");
            this.evaluatePontonXPaths(payload, payloadPrefix, schema, senderLookup, receiverLookup, logInfoLookup, messageIdLookup, conversationIdLookup, contentReceiverLookup, xpMessage, schemasetParameters);
        }
    }

    private String evaluateW3CXPath(String prefix, String xpathString, boolean isRepeatable, Node source) throws XPathExpressionException {
        String result = null;
        if (xpathString != null) {
            long time2a = System.currentTimeMillis();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            XPathExpression expr = xpath.compile(prefix + xpathString);
            long time3 = System.currentTimeMillis();
            if (isRepeatable) {
                StringBuilder resultBuilder = new StringBuilder();
                NodeList nodes = (NodeList)expr.evaluate(source, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    resultBuilder.append(node.getTextContent()).append(';');
                }
                resultBuilder.setLength(resultBuilder.length() - 1);
                result = resultBuilder.toString();
            } else {
                result = expr.evaluate(source);
            }
            long time4 = System.currentTimeMillis();
            if (_log.isTraceEnabled()) {
                _log.trace("xpath compile: {} ms", (Object)(time3 - time2a));
                _log.trace("xpath eval: {} ms", (Object)(time4 - time3));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateW3CXPaths(File tempPayload, String payloadPrefix, SchemaData schema, boolean senderLookup, boolean receiverLookup, boolean logInfoLookup, boolean messageIdLookup, boolean conversationIdLookup, boolean contentReceiverLookup, XpMessage xpMessage, List<SchemasetParameter> schemasetParameters) {
        FileInputStream fis = null;
        try {
            String contentReceiverIdResult;
            String remoteIdResult;
            String localIdResult;
            String conversationIdResult;
            String messageIdResult;
            String logInfoResult;
            String logInfoXpathStr = schema.getEnvelopeMapping().getLogInfoXPath();
            String messageIdXpathStr = schema.getEnvelopeMapping().getMessageIdXPath();
            String conversationIdXpathStr = schema.getEnvelopeMapping().getConversationIdXPath();
            String localXpathStr = schema.getEnvelopeMapping().getLocalPartyIdXPath();
            String remoteXpathStr = schema.getEnvelopeMapping().getRemotePartyIdXPath();
            String contentReceiverXpathStr = schema.getEnvelopeMapping().getContentReceiverPartyIdXPath();
            long time1 = System.currentTimeMillis();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(tempPayload);
            long time2 = System.currentTimeMillis();
            if (_log.isTraceEnabled()) {
                _log.trace("xml parse: {} ms", (Object)(time2 - time1));
            }
            if (logInfoLookup && this.hasContent(logInfoXpathStr) && (logInfoResult = this.evaluateW3CXPath(payloadPrefix, logInfoXpathStr, false, doc)) != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Found log info '{}'.", (Object)logInfoResult);
                }
                xpMessage.setProcessingDirective("LogInfo", logInfoResult);
            }
            if (messageIdLookup && this.hasContent(messageIdXpathStr) && (messageIdResult = this.evaluateW3CXPath(payloadPrefix, messageIdXpathStr, false, doc)) != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Found message id '{}'.", (Object)messageIdResult);
                }
                xpMessage.setMessageId(messageIdResult);
            }
            if (conversationIdLookup && this.hasContent(conversationIdXpathStr) && (conversationIdResult = this.evaluateW3CXPath(payloadPrefix, conversationIdXpathStr, false, doc)) != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Found conversation id '{}'.", (Object)conversationIdResult);
                }
                xpMessage.setConversationId(conversationIdResult);
            }
            if (senderLookup && this.hasContent(localXpathStr) && (localIdResult = this.evaluateW3CXPath(payloadPrefix, localXpathStr, false, doc)) != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Found sender id '{}'.", (Object)localIdResult);
                }
                xpMessage.setSenderInternalId(localIdResult);
            }
            if (receiverLookup && this.hasContent(remoteXpathStr) && (remoteIdResult = this.evaluateW3CXPath(payloadPrefix, remoteXpathStr, false, doc)) != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Found receiver id '{}'.", (Object)remoteIdResult);
                }
                xpMessage.setReceiverInternalId(remoteIdResult);
            }
            if (contentReceiverLookup && this.hasContent(schema.getEnvelopeMapping().getContentReceiverPartyIdXPath()) && (contentReceiverIdResult = this.evaluateW3CXPath(payloadPrefix, contentReceiverXpathStr, false, doc)) != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Found content receiver id '{}'.", (Object)contentReceiverIdResult);
                }
                xpMessage.setProcessingDirective("ContentReceiverID", contentReceiverIdResult);
            }
            for (SchemasetParameter schemasetParameter : schemasetParameters) {
                String value = this.evaluateW3CXPath(payloadPrefix, schemasetParameter.getXPath(), schemasetParameter.isRepeatable(), doc);
                if (value == null) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug("Found content '{}' for processing directive '{}'.", (Object)value, (Object)schemasetParameter.getProcessingDirectiveName());
                }
                xpMessage.setProcessingDirective(schemasetParameter.getProcessingDirectiveName(), value);
            }
        }
        catch (Exception e) {
            _log.error("could not fetch xml content", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void evaluatePontonXPaths(File payload, String payloadPrefix, SchemaData schema, boolean senderLookup, boolean receiverLookup, boolean logInfoLookup, boolean messageIdLookup, boolean conversationIdLookup, boolean contentReceiverLookup, XpMessage xpMessage, List<SchemasetParameter> schemasetParameters) throws FactoryConfigurationError {
        Map<StAXXPath, String> xpathLookup;
        StAXXPath sender = this.getStaxxPath(senderLookup, schema.getEnvelopeMapping().getLocalPartyIdXPath(), payloadPrefix);
        StAXXPath receiver = this.getStaxxPath(receiverLookup, schema.getEnvelopeMapping().getRemotePartyIdXPath(), payloadPrefix);
        StAXXPath messageId = this.getStaxxPath(messageIdLookup, schema.getEnvelopeMapping().getMessageIdXPath(), payloadPrefix);
        StAXXPath conversationId = this.getStaxxPath(conversationIdLookup, schema.getEnvelopeMapping().getConversationIdXPath(), payloadPrefix);
        StAXXPath logInfo = this.getStaxxPath(logInfoLookup, schema.getEnvelopeMapping().getLogInfoXPath(), payloadPrefix);
        StAXXPath contentReceiverId = this.getStaxxPath(contentReceiverLookup, schema.getEnvelopeMapping().getContentReceiverPartyIdXPath(), payloadPrefix);
        HashMap<StAXXPath, SchemasetParameter> processingDirectiveStaXXPaths = HashMap.newHashMap(schemasetParameters.size());
        for (SchemasetParameter schemasetParameter : schemasetParameters) {
            processingDirectiveStaXXPaths.put(new StAXXPath(payloadPrefix + schemasetParameter.getXPath(), schemasetParameter.isRepeatable()), schemasetParameter);
        }
        List<StAXXPath> xpaths = Stream.of(sender, receiver, messageId, conversationId, logInfo, contentReceiverId).filter(Objects::nonNull).collect(Collectors.toList());
        xpaths.addAll(processingDirectiveStaXXPaths.keySet().stream().toList());
        try (InputStream inputStream = Files.newInputStream(payload.toPath(), new OpenOption[0]);){
            xpathLookup = new XmlParser().parse(inputStream, xpaths);
        }
        catch (Exception e) {
            _log.error("Could not read xml content", (Throwable)e);
            return;
        }
        this.executeWhenValueFound(xpathLookup, sender, "senderId", xpMessage::setSenderInternalId);
        this.executeWhenValueFound(xpathLookup, receiver, "receiverId", xpMessage::setReceiverInternalId);
        this.executeWhenValueFound(xpathLookup, messageId, "messageId", xpMessage::setMessageId);
        this.executeWhenValueFound(xpathLookup, conversationId, "conversationId", xpMessage::setConversationId);
        this.executeWhenValueFound(xpathLookup, logInfo, "logInfo", value -> xpMessage.setProcessingDirective("LogInfo", (String)value));
        this.executeWhenValueFound(xpathLookup, contentReceiverId, "contentReceiverId", value -> xpMessage.setProcessingDirective("ContentReceiverID", (String)value));
        for (Map.Entry keyPair : processingDirectiveStaXXPaths.entrySet()) {
            this.executeWhenValueFound(xpathLookup, (StAXXPath)keyPair.getKey(), String.format("processing directive '%s' with content", ((SchemasetParameter)keyPair.getValue()).getProcessingDirectiveName()), value -> xpMessage.setProcessingDirective(((SchemasetParameter)keyPair.getValue()).getProcessingDirectiveName(), (String)value));
        }
    }

    private void executeWhenValueFound(Map<StAXXPath, String> lookup, StAXXPath value, String description, Consumer<String> callback) {
        if (value != null && lookup.containsKey(value)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Found {} '{}'.", (Object)description, (Object)value.getValue());
            }
            callback.accept(lookup.get(value));
        }
    }

    private StAXXPath getStaxxPath(boolean doLookup, String xpath, String payloadPrefix) {
        if (doLookup && this.hasContent(xpath)) {
            return new StAXXPath(payloadPrefix + xpath);
        }
        return null;
    }
}

