/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class StAXXPath {
    private static final Logger log = LogManager.getLogger((String)"Messenger.StAXXPath");
    private static final String XMLSCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMALOCATION = "schemaLocation";
    private static final String NO_NAMESPACE_SCHEMALOCATION = "noNamespaceSchemaLocation";
    private static final String XPATH_ELEMENT_REGEX = "/[^,)']+";
    private final String _elementNeeded;
    private String _attributeNeeded;
    private int _levelNeeded;
    private String _xpath;
    private String _xpathFunction;
    private final List<String> _values = new ArrayList<String>();
    private QName _qname;
    private String _schemaLocation;
    private boolean _found;
    private boolean _preFound;
    private boolean _elementFound;
    private int _foundElementCount = 0;
    private int _foundElementXPath = -1;
    private String _elementName;
    private boolean _repeatable;

    public StAXXPath(String xpath) {
        this._xpath = this.extractXPathElement(xpath);
        if (!this._xpath.equals(xpath)) {
            this._xpathFunction = xpath.replace(this._xpath, "'%s'");
        }
        StringTokenizer tokens = new StringTokenizer(this._xpath, "/");
        this._levelNeeded = tokens.countTokens();
        int offset = this._xpath.indexOf(64);
        if (offset == -1) {
            this._elementNeeded = this._xpath;
        } else {
            this._elementNeeded = this._xpath.substring(0, offset - 1);
            this._attributeNeeded = this._xpath.substring(offset + 1);
            --this._levelNeeded;
        }
    }

    private String extractXPathElement(String xPath) {
        Pattern pattern = Pattern.compile(XPATH_ELEMENT_REGEX);
        Matcher matcher = pattern.matcher(xPath);
        if (matcher.find()) {
            return matcher.group();
        }
        return xPath;
    }

    public StAXXPath(String xpath, boolean repeatable) {
        this(xpath);
        this._repeatable = repeatable;
    }

    public void handleStartElement(XMLStreamReader reader, int xpathLevel, String currentXpath) {
        block6: {
            if (this._found || !this.isMatched(currentXpath)) break block6;
            this._qname = reader.getName();
            this._foundElementXPath = xpathLevel;
            if (this._attributeNeeded != null) {
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if (!this._attributeNeeded.equals(reader.getAttributeName(i).getLocalPart())) continue;
                    this._values.add(reader.getAttributeValue(i));
                    this._preFound = true;
                    if (this._repeatable) break;
                    this._found = true;
                    break;
                }
            } else {
                this._xpath = currentXpath;
                this._elementFound = true;
                ++this._foundElementCount;
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if (XMLSCHEMA_NAMESPACE_URI.equals(reader.getAttributeNamespace(i)) && NO_NAMESPACE_SCHEMALOCATION.equals(reader.getAttributeLocalName(i))) {
                        this._schemaLocation = reader.getAttributeValue(i);
                    } else {
                        if (!XMLSCHEMA_NAMESPACE_URI.equals(reader.getAttributeNamespace(i)) || !SCHEMALOCATION.equals(reader.getAttributeLocalName(i))) continue;
                        this._schemaLocation = reader.getAttributeValue(i);
                    }
                    break;
                }
            }
        }
    }

    private boolean isMatched(String currentXpath) {
        StringTokenizer currentXpathST = new StringTokenizer(currentXpath, "/");
        if (this._levelNeeded != currentXpathST.countTokens()) {
            return false;
        }
        StringTokenizer xpathST = new StringTokenizer(this._elementNeeded, "/");
        while (xpathST.hasMoreTokens()) {
            String elementName = xpathST.nextToken();
            String currentElementName = currentXpathST.nextToken();
            if (elementName.equals("*")) {
                this._elementName = currentElementName;
                continue;
            }
            if (elementName.equals(currentElementName)) continue;
            return false;
        }
        return true;
    }

    public void handleEndElement(int xpathLevel) {
        if (this._elementFound) {
            if (this._values.size() < this._foundElementCount) {
                this._values.add("");
            }
            this._elementFound = false;
            this._preFound = true;
            if (!this._repeatable) {
                this._found = true;
            }
        } else if (this._preFound && xpathLevel < this._foundElementXPath) {
            this._found = true;
        }
    }

    public void handleText(XMLStreamReader reader) {
        if (this._elementFound) {
            String text = reader.getText();
            if (text != null) {
                this._values.add(text.trim());
            }
            this._elementFound = false;
            this._preFound = true;
            if (!this._repeatable) {
                this._found = true;
            }
        }
    }

    public String getValue() {
        if (!this._values.isEmpty()) {
            String value = this._values.getFirst();
            if (this._xpathFunction != null) {
                try {
                    XPathFactory xpathFactory = XPathFactory.newInstance();
                    XPath xpath = xpathFactory.newXPath();
                    value = xpath.evaluate(String.format(this._xpathFunction, value), new InputSource(new StringReader("<root/>")));
                }
                catch (Exception e) {
                    log.debug("{} while evaluating XPath function [{}]: {}", (Object)e.getClass().getName(), (Object)this._xpathFunction, (Object)e.toString());
                }
            }
            return value;
        }
        return null;
    }

    public List<String> getValues() {
        return this._values;
    }

    public String getElementName() {
        return this._elementName;
    }

    public String getXPath() {
        return this._xpath;
    }

    public QName getQName() {
        return this._qname;
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public boolean isFound() {
        return this._found;
    }

    public void reset() {
        this._preFound = false;
        this._found = false;
        this._elementFound = false;
        this._values.clear();
        this._qname = null;
        this._schemaLocation = null;
    }
}

