/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.common.encoding.Base64Encoder;
import de.pontonconsulting.xmlpipe.activation.ActivationControl;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.listener.AbstractMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.ISoapProcessor;
import de.pontonconsulting.xmlpipe.listener.ISoapProcessorFactory;
import de.pontonconsulting.xmlpipe.listener.MessageRequest;
import de.pontonconsulting.xmlpipe.listener.MessageResponse;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import de.pontonconsulting.xmlpipe.util.SOAPMessageUtils;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.ParseException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class SoapListener
extends AbstractMessageReceiver<SOAPMessage> {
    private static final String SOAP_MESSAGING_IS_DISABLED = "SOAP messaging is disabled.";
    public static final String SERVICE_NAME = "SoapListener";
    static final String MIME_BOUNDARY_PREFIX = "--";
    private static int _processCount = 1;
    private static AtomicLong _callNumber = new AtomicLong(0L);
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.SoapListener" + _processCount++);
    private final ISoapProcessorFactory _soapProcessorFactory;
    private final IFolders _folders;
    private final MessageFactory messageFactory;

    public SoapListener(ActivationControl activationControl, MessengerActivation activationProvider, MaintenanceManager maintenanceManager, ReferenceDateTask referenceDateTask, IMessengerProperties messengerProperties, ISoapProcessorFactory soapProcessorFactory, IFolders folders, MessageFactory messageFactory, MetricsService metricsService) {
        super(activationControl, activationProvider, maintenanceManager, referenceDateTask, messengerProperties, metricsService);
        this._soapProcessorFactory = soapProcessorFactory;
        this._folders = folders;
        this.messageFactory = messageFactory;
        this.initLog();
    }

    private synchronized void initLog() {
        _log.debug((Object)"new instance");
    }

    @Override
    protected Log getLogger() {
        return _log;
    }

    @Override
    protected boolean isFeatureEnabled() throws ActivationException {
        return this.activationProvider.isSoapListenerEnabled();
    }

    @Override
    protected String getMessengerExceptionText() {
        return SOAP_MESSAGING_IS_DISABLED;
    }

    @Override
    protected SOAPMessage processRequest(MessageRequest messageRequest) throws Exception {
        return this.processRequest(messageRequest, Optional.empty(), messageRequest.getRequestURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processResult(SOAPMessage reply, MessageResponse messageResponse) throws Exception {
        try {
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
            this.putHeaders(reply.getMimeHeaders(), messageResponse);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if ("base64".equalsIgnoreCase(messageResponse.getHeader("Content-Transfer-Encoding"))) {
                Base64Encoder base64Encoder = new Base64Encoder(byteArrayOutputStream);
                reply.writeTo((OutputStream)base64Encoder);
                IOUtils.closeQuietly((Closeable)base64Encoder, exception -> _log.error(exception));
            } else {
                reply.writeTo((OutputStream)byteArrayOutputStream);
            }
            byteArrayOutputStream.size();
            messageResponse.addHeader("Content-Length", String.valueOf(byteArrayOutputStream.size()));
            messageResponse.write(byteArrayOutputStream.toByteArray());
        }
        finally {
            SOAPMessageUtils.purgeAttachments(reply);
        }
    }

    @Override
    protected void handleException(Throwable exception, MessageResponse messageResponse) throws IOException {
        try {
            _log.error((Object)"Error while receiving SOAP message: ", exception);
            _log.debug((Object)"creating SOAP Fault message.");
            SOAPMessage msg = this.messageFactory.createMessage();
            SOAPPart sp = msg.getSOAPPart();
            SOAPEnvelope envelope = sp.getEnvelope();
            SOAPBody bdy = envelope.getBody();
            SOAPFault fault = bdy.addFault();
            String namespace = fault.getElementName().getPrefix();
            fault.setFaultCode(namespace + ":Server");
            fault.setFaultString("internal error while processing received SOAP message");
            if (msg.saveRequired()) {
                msg.saveChanges();
            }
            messageResponse.addHeader("Content-Type", "text/xml; charset=UTF-8");
            this.putHeaders(msg.getMimeHeaders(), messageResponse);
            messageResponse.setResult(500, "Error while processing SoapMessage");
            OutputStream os = messageResponse.getOutputStream();
            msg.writeTo(os);
            os.flush();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SOAPMessage processRequest(MessageRequest messageRequest, Optional<Long> refDbId, String uri) throws SOAPException, IOException, MessagingException {
        try (SharedFileInputStream sharedInputStream = new SharedFileInputStream(messageRequest.getRequestDataFile());){
            SOAPMessage sOAPMessage;
            String protocol;
            MimeMessage mimeMessage = new MimeMessage(null, (InputStream)sharedInputStream);
            String realProtocol = messageRequest.getHeader("X-inbound-protocol");
            if (realProtocol != null) {
                protocol = realProtocol;
            } else {
                try {
                    protocol = new URI(uri).getScheme().toUpperCase();
                }
                catch (Exception e) {
                    protocol = "unknown";
                }
            }
            this.logUserInformation(mimeMessage);
            try {
                sOAPMessage = this.handleSoapMessage(mimeMessage, protocol, refDbId);
            }
            catch (Throwable throwable) {
                sharedInputStream.dispose();
                throw throwable;
            }
            sharedInputStream.dispose();
            return sOAPMessage;
        }
    }

    private long getCallNumber() {
        return _callNumber.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage handleSoapMessage(MimeMessage mimeMessage, String protocol, Optional<Long> refDbId) throws IOException, SOAPException, MessagingException {
        MimeHeaders mimeHeaders = MimeMultipartUtils.createMimeHeader((Part)mimeMessage);
        this.addBoundaryParameterIfMissing(mimeMessage, mimeHeaders);
        SOAPMessage soapMessage = this.messageFactory.createMessage(mimeHeaders, mimeMessage.getInputStream());
        try {
            SOAPMessage reply;
            if (soapMessage.getSOAPHeader() == null) {
                throw new SOAPException("SOAP 'Header' element is missing.");
            }
            if (soapMessage.getSOAPBody() == null) {
                throw new SOAPException("SOAP 'Body' element is missing.");
            }
            ISoapProcessor processor = this.findSoapProcessor(soapMessage);
            if (processor == null) {
                throw new SOAPException("No Supported Service Handler found.");
            }
            HashMap<AttachmentPart, DataHandler> originalDataHandlers = new HashMap<AttachmentPart, DataHandler>();
            Iterator iter = soapMessage.getAttachments();
            while (iter.hasNext()) {
                AttachmentPart attachmentPart2 = (AttachmentPart)iter.next();
                originalDataHandlers.put(attachmentPart2, attachmentPart2.getDataHandler());
            }
            try {
                reply = processor.processMessage(soapMessage, protocol, refDbId);
                if (reply != null) {
                    _log.debug((Object)"returning SOAP reply from processor");
                }
            }
            finally {
                SOAPMessageUtils.purgeAttachments(soapMessage);
                originalDataHandlers.forEach((attachmentPart, dataHandler) -> attachmentPart.setDataHandler(dataHandler));
            }
            SOAPMessage sOAPMessage = reply;
            return sOAPMessage;
        }
        finally {
            SOAPMessageUtils.purgeAttachments(soapMessage);
        }
    }

    private void addBoundaryParameterIfMissing(MimeMessage mimeMessage, MimeHeaders mimeHeaders) throws IOException {
        block11: {
            String[] contentTypeValues;
            if (mimeHeaders != null && (contentTypeValues = mimeHeaders.getHeader("Content-Type")) != null && contentTypeValues.length > 0) {
                try {
                    ContentType contentType = new ContentType(contentTypeValues[0]);
                    if (!contentType.getPrimaryType().equalsIgnoreCase("multipart") || contentType.getParameter("boundary") != null) break block11;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(mimeMessage.getInputStream()));){
                        String line = reader.readLine();
                        if (line.startsWith(MIME_BOUNDARY_PREFIX)) {
                            String mimeBoundary = line.replaceFirst(MIME_BOUNDARY_PREFIX, "");
                            contentType.setParameter("boundary", mimeBoundary);
                            mimeHeaders.setHeader("Content-Type", contentType.toString());
                            _log.warn((Object)("Missing boundary parameter " + mimeBoundary + " added to Content-Type of message " + mimeMessage.getMessageID()));
                        }
                    }
                    catch (MessagingException e) {
                        _log.error((Object)"Cannot open MIME Message.", (Throwable)e);
                    }
                }
                catch (ParseException e) {
                    _log.error((Object)"Cannot parse content type.", (Throwable)e);
                }
            }
        }
    }

    private ISoapProcessor findSoapProcessor(SOAPMessage soapMessage) throws SOAPException {
        SOAPHeaderElement elem;
        String uri;
        ISoapProcessor processor;
        Name name;
        Iterator it = soapMessage.getSOAPHeader().getChildElements();
        while (it.hasNext()) {
            name = null;
            Object headerSubElement = it.next();
            if (!(headerSubElement instanceof SOAPHeaderElement) || (processor = this._soapProcessorFactory.getProcessor(uri = (name = (elem = (SOAPHeaderElement)headerSubElement).getElementName()).getURI())) == null) continue;
            _log.debug((Object)("header-uri-name:" + uri));
            return processor;
        }
        it = soapMessage.getSOAPBody().getChildElements();
        while (it.hasNext()) {
            name = null;
            Object temp = it.next();
            if (!(temp instanceof SOAPBodyElement) || (processor = this._soapProcessorFactory.getProcessor(uri = (name = (elem = (SOAPBodyElement)temp).getElementName()).getURI())) == null) continue;
            _log.debug((Object)("body-uri-name:" + uri));
            return processor;
        }
        return null;
    }

    private void putHeaders(MimeHeaders headers, MessageResponse messageResponse) {
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            String[] values = headers.getHeader(header.getName());
            if (values.length == 1) {
                messageResponse.addHeader(header.getName(), header.getValue());
                continue;
            }
            StringBuilder concat = new StringBuilder();
            int i = 0;
            while (i < values.length) {
                if (i != 0) {
                    concat.append(',');
                }
                concat.append(values[i++]);
            }
            messageResponse.addHeader(header.getName(), concat.toString());
        }
    }

    public void processSyncResponse(Map<String, String> headers, byte[] dataBytes, String protocol, long refDbId) throws Exception {
        Object lock = new Object();
        File tempStore = new File(this._folders.getWorkInboundFolder(), "soapcall-" + this.getCallNumber());
        try {
            this.storeWiredData(tempStore, headers, dataBytes);
            this.putLock(lock);
            MessageRequest messageRequest = new MessageRequest(tempStore, headers);
            SOAPMessage response = this.processRequest(messageRequest, Optional.of(refDbId), protocol + "://dummy");
            if (response != null) {
                _log.warn((Object)"Processing of Sync-Response created another response. unable to deliver it !");
                SOAPMessageUtils.purgeAttachments(response);
            }
        }
        catch (SOAPException e) {
            _log.fatal((Object)("SyncResponse could not be processed: " + String.valueOf((Object)e)));
            throw e;
        }
        catch (IOException e) {
            _log.fatal((Object)("SyncResponse could not be processed: " + String.valueOf(e)));
            throw e;
        }
        catch (Exception e) {
            _log.error((Object)"unexpected problem with SyncResponse", (Throwable)e);
            throw e;
        }
        finally {
            this.removeLock(lock);
            FileUtils.deleteQuietly((File)tempStore);
        }
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }
}

