/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import java.io.File;
import java.util.Map;

public class MessageRequest {
    public static final String HEADER_REQUEST_METHOD = "X-Request-Method";
    public static final String HEADER_REQUEST_SERVLET_PATH = "X-Request-Servlet-Path";
    public static final String HEADER_REQUEST_URL = "X-Request-URL";
    private final Map<String, String> controlHeaders;
    private final File wiredDataFile;

    public MessageRequest(File wiredDataFile, Map<String, String> controlHeaders) {
        this.controlHeaders = controlHeaders;
        this.wiredDataFile = wiredDataFile;
    }

    public File getRequestDataFile() {
        return this.wiredDataFile;
    }

    public String getHeader(String header) {
        return this.controlHeaders.get(header);
    }

    public String getRequestServletPath() {
        return this.getHeader(HEADER_REQUEST_SERVLET_PATH);
    }

    public String getRequestURL() {
        return this.getHeader(HEADER_REQUEST_URL);
    }

    public String getMethod() {
        return this.getHeader(HEADER_REQUEST_METHOD);
    }
}

