/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class ListenerCertificateGulagService {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + ListenerCertificateGulagService.class.getName()));
    private static final TypeReference<List<RevokedCertificate>> valueTypeRef = new TypeReference<List<RevokedCertificate>>(){};
    private static final String CERTIFICATE_GULAG_FILE = "revokedListenerCertificates.json";
    private final File gulagFile;
    private final ObjectMapper objectMapper;

    public ListenerCertificateGulagService(IServerConfigBean serverConfigBean, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.gulagFile = Path.of(serverConfigBean.getConfigFolder().toPath().toString(), CERTIFICATE_GULAG_FILE).toFile();
    }

    public List<ListenerCertificate> importGulagFile() {
        if (this.gulagFileExists()) {
            try {
                List<ListenerCertificate> certificates = ((List)this.objectMapper.readValue(this.gulagFile, valueTypeRef)).stream().map(e -> {
                    try {
                        ListenerCertificate listenerCertificate = new ListenerCertificate();
                        listenerCertificate.setAliasAndType(e.alias, ListenerCertificate.Type.CLIENT);
                        OffsetDateTime lastCheck = OffsetDateTime.ofInstant(Instant.ofEpochMilli(e.lastCheck), ZoneOffset.UTC);
                        listenerCertificate.setLastCheck(lastCheck);
                        listenerCertificate.setLastSuccessfulCheck(lastCheck.minusDays(1L));
                        listenerCertificate.setCertificate(e.base64EncodedCertificate.getBytes());
                        return listenerCertificate;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.toList());
                if (this.gulagFile.delete()) {
                    LOG.info("Imported {} revoked certificates from {} and deleted this file.", (Object)certificates.size(), (Object)CERTIFICATE_GULAG_FILE);
                }
                return certificates;
            }
            catch (IOException e2) {
                LOG.error("Could not import revoked certificates from {}: {}", (Object)CERTIFICATE_GULAG_FILE, (Object)e2.toString());
            }
        }
        return Collections.emptyList();
    }

    public boolean gulagFileExists() {
        return this.gulagFile.exists();
    }

    @Deprecated
    void writeCertificateToGulagFile(String alias, String certificateData) throws IOException {
        ArrayList<RevokedCertificate> revokedCertificates = this.gulagFileExists() ? (List)this.objectMapper.readValue(this.gulagFile, valueTypeRef) : new ArrayList<RevokedCertificate>();
        RevokedCertificate revokedCertificate = new RevokedCertificate(alias, certificateData, System.currentTimeMillis());
        revokedCertificates.add(revokedCertificate);
        this.objectMapper.writeValue(this.gulagFile, revokedCertificates);
    }

    private record RevokedCertificate(String alias, String base64EncodedCertificate, long lastCheck) {
    }
}

