/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.common.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.as.AS1Message;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.ASObject;
import de.pontonconsulting.xmlpipe.as.ASReport;
import de.pontonconsulting.xmlpipe.as.ASReportException;
import de.pontonconsulting.xmlpipe.as.FatalASProcessingException;
import de.pontonconsulting.xmlpipe.as.IAS2Object;
import de.pontonconsulting.xmlpipe.as.IAS3Object;
import de.pontonconsulting.xmlpipe.as.MDNParameters;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationResult;
import de.pontonconsulting.xmlpipe.listener.ErrorNotificationService;
import de.pontonconsulting.xmlpipe.listener.IASProcessor;
import de.pontonconsulting.xmlpipe.listener.ProcessingResultToErrorNotificationResultConverter;
import de.pontonconsulting.xmlpipe.mail.DispositionNotification;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageExistsException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.ASPackager;
import de.pontonconsulting.xmlpipe.messenger.transport.MDNData;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateInfo;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEDecrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEUnknownSignCertificateExeption;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEValidationException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifier;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifyResult;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import jakarta.activation.DataHandler;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;
import org.springframework.util.FileSystemUtils;

abstract class ASProcessor
implements IASProcessor {
    private Logger _log;
    private final Agreements _agreements;
    private final MessengerConfig _messengerConfig;
    protected final Profiles _profiles;
    private final ReceiveFromListener _receiveFromListener;
    private final ReferenceDateTask _referenceDate;
    protected ASObject _incomingMessage;
    protected XpMessage _xpMessage;
    private CppPartner _sender;
    private CppPartner _receiver;
    protected boolean _includeHeaderInDigestCalculation;
    protected final MessengerLog _messengerLog;
    private final MessageDAO _messageDAO;
    private final FileRefDAO _fileRefDAO;
    private final MDNDataDAO _mdnDataDAO;
    protected final IFolders _folders;
    private final IdGenerator _idGenerator;
    private final ArchiveProcessor _archiveProcessor;
    protected final CertificateUtility _certificateUtility;
    private final ErrorNotificationService _errorNotificationService;
    private final SMIMEVerifier _smimeVerifier;
    private final SMIMEDecrypter _smimeDecrypter;
    private final SMIMEDecompressor _smimeDecompressor;
    private final RegistryProfileUpdater _registryProfileUpdater;
    private final MessageWorkDataDAO messageWorkDataDAO;
    private boolean _ignoreDuplicate = false;
    private boolean _inProcessing = false;
    private boolean _decompressed = false;

    public ASProcessor(Agreements agreements, MessengerConfig messengerConfig, Profiles profiles, ReceiveFromListener receiveFromListener, ReferenceDateTask referenceDate, MessengerLog messengerLog, MessageDAO messageDAO, FileRefDAO fileRefDAO, MDNDataDAO mdnDataDAO, IFolders folders, IdGenerator idGenerator, ArchiveProcessor archiveProcessor, CertificateUtility certificateUtility, ErrorNotificationService errorNotificationService, SMIMEVerifier smimeVerifier, SMIMEDecrypter smimeDecrypter, SMIMEDecompressor smimeDecompressor, RegistryProfileUpdater registryProfileUpdater, MessageWorkDataDAO messageWorkDataDAO) {
        this._agreements = agreements;
        this._messengerConfig = messengerConfig;
        this._profiles = profiles;
        this._receiveFromListener = receiveFromListener;
        this._referenceDate = referenceDate;
        this._messengerLog = messengerLog;
        this._messageDAO = messageDAO;
        this._fileRefDAO = fileRefDAO;
        this._mdnDataDAO = mdnDataDAO;
        this._folders = folders;
        this._idGenerator = idGenerator;
        this._archiveProcessor = archiveProcessor;
        this._certificateUtility = certificateUtility;
        this._errorNotificationService = errorNotificationService;
        this._smimeVerifier = smimeVerifier;
        this._smimeDecrypter = smimeDecrypter;
        this._smimeDecompressor = smimeDecompressor;
        this._registryProfileUpdater = registryProfileUpdater;
        this.messageWorkDataDAO = messageWorkDataDAO;
        this._includeHeaderInDigestCalculation = false;
    }

    @Override
    public void setLogger(Logger log) {
        this._log = log;
    }

    protected abstract CppPartner identifySender() throws ASException;

    protected abstract CppPartner identifyReceiver() throws ASException;

    protected abstract ASReport createOkReport(String var1);

    protected ASReport createPositiveMDN(String statusDescription) {
        ASReport report = this.createOkReport(statusDescription);
        try {
            this.registerReport(report);
            this._messengerLog.log2dbWithHref(2, this._xpMessage.getDatabaseId(), report.getMessageId(), report.getXpMessage().getMessageId(), report.getXpMessage().getDatabaseId(), false);
            return report;
        }
        catch (ASReportException | CommunicationNotFoundException | DbException | MessagingException | JAXBException | IOException e) {
            this._log.error("Could not create positive MDN. " + String.valueOf(e), e);
            try {
                long databaseId = report.getXpMessage().getDatabaseId();
                this._messengerLog.log2dbWithHref(2, this._xpMessage.getDatabaseId(), report.getMessageId(), report.getXpMessage().getMessageId(), report.getXpMessage().getDatabaseId(), false);
                this._messengerLog.log2db(522, databaseId, "Could not create positive MDN. " + e.getMessage());
                this._messageDAO.updateMessageStatus(databaseId, report.getMessageId(), 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    protected abstract ASReport createErrorReport(ASReport.DispositionModifier var1, ASReport.DispositionModifierExtension var2, String var3, List<String> var4);

    protected ASReport createNegativeMDN(ASReport.DispositionModifier dispositionModifier, ASReport.DispositionModifierExtension dispositionModifierExtension, String statusDescription, List<String> details) {
        ASReport report = this.createErrorReport(dispositionModifier, dispositionModifierExtension, statusDescription, details);
        try {
            this.registerReport(report);
            this._messengerLog.log2dbWithHref(7, this._xpMessage.getDatabaseId(), report.getMessageId(), report.getXpMessage().getMessageId(), report.getXpMessage().getDatabaseId(), false);
            return report;
        }
        catch (ASReportException | CommunicationNotFoundException | DbException | MessagingException | JAXBException | IOException e) {
            this._log.error("Could not create negative MDN. " + String.valueOf(e), e);
            try {
                long databaseId = report.getXpMessage().getDatabaseId();
                this._messengerLog.log2dbWithHref(7, this._xpMessage.getDatabaseId(), report.getMessageId(), report.getXpMessage().getMessageId(), report.getXpMessage().getDatabaseId(), false);
                this._messengerLog.log2db(522, databaseId, "Could not create negative MDN. " + e.getMessage());
                this._messageDAO.updateMessageStatus(databaseId, report.getMessageId(), 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    protected abstract MessageDigestCalculator createMessageDigestCalculator(String var1) throws SecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ASReport processMessage(ASMessage message, String protocol) throws FatalASProcessingException, DbException {
        this.createXPMessage(message, protocol);
        if (this._inProcessing) {
            return null;
        }
        try {
            ASReport aSReport = this.processSMIME();
            return aSReport;
        }
        finally {
            message.cleanupTempFiles();
        }
    }

    private void checkDecompressionIsRequired() throws ASException {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue("/CompressMessage");
            if (!this._decompressed && Boolean.parseBoolean(option)) {
                throw new ASException(43000, "Message should be compressed, but is not compressed.");
            }
        }
        catch (OptionNotFoundException e) {
            this._log.debug(e.getMessage(), (Throwable)e);
        }
    }

    private ASReport processSMIME() {
        try {
            this.decryptMessage();
        }
        catch (ASException ase) {
            return this.handleException(ase, 536, ASReport.DispositionModifierExtension.ERROR_DECRYPTION_FAILED);
        }
        try {
            this.decompressMessage();
        }
        catch (ASException ase) {
            return this.handleException(ase, 538, ASReport.DispositionModifierExtension.ERROR_DECOMPRESSION_FAILED);
        }
        try {
            this.checkSignature();
        }
        catch (ASException ase) {
            return this.handleException(ase, 534, ASReport.DispositionModifierExtension.ERROR_AUTH_FAILED);
        }
        if (this._incomingMessage.wasSigned()) {
            try {
                this.calculateMIC();
            }
            catch (ASException ase) {
                return this.handleException(ase, 527, ASReport.DispositionModifierExtension.ERROR_UNEXPECTED_PROCESSING_ERROR);
            }
        }
        try {
            this.decompressMessage();
        }
        catch (ASException ase) {
            return this.handleException(ase, 538, ASReport.DispositionModifierExtension.ERROR_DECOMPRESSION_FAILED);
        }
        try {
            this.checkDecompressionIsRequired();
        }
        catch (ASException ase) {
            return this.handleException(ase, 538, ASReport.DispositionModifierExtension.ERROR_DECOMPRESSION_FAILED);
        }
        if (!this._incomingMessage.wasSigned()) {
            try {
                this.calculateMIC();
            }
            catch (ASException ase) {
                return this.handleException(ase, 527, ASReport.DispositionModifierExtension.ERROR_UNEXPECTED_PROCESSING_ERROR);
            }
        }
        return this.processMessage();
    }

    private ASReport handleException(ASException ase, int logMessageKey, ASReport.DispositionModifierExtension dispositionModifierExtension) {
        this._log.error("Unable to process incoming message. Aborting. " + ase.getMessage(), (Throwable)ase);
        this._messengerLog.log2db(logMessageKey, this._xpMessage.getDatabaseId(), "Unable to process incoming message. Aborting. " + ase.getMessage());
        String description = "Incoming message could not be processed.";
        this.notifyAdapter(ErrorNotificationResult.ErrorType.PACKAGING_ERROR, ase.getMessage());
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(this._xpMessage.getDatabaseId(), this._xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)this._xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            this._log.error("Couldn't upload message folder for {} to database: {}", (Object)this._xpMessage.getDatabaseId(), (Object)e.getMessage());
        }
        this._archiveProcessor.sendFilesToArchive(this._xpMessage.getDatabaseId(), true);
        if (!this._ignoreDuplicate) {
            try {
                this._messageDAO.updateMessageAndStatus(this._xpMessage, 4);
            }
            catch (DbException e) {
                this._log.error("Could not update status for an AS report: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.createNegativeMDN(ASReport.DispositionModifier.ERROR, dispositionModifierExtension, "Incoming message could not be processed.", Collections.singletonList(ase.getMessage()));
    }

    @Override
    public void processReport(ASReport asReport, String protocol) throws FatalASProcessingException, DbException {
        this.createXPMessage(asReport, protocol);
        if (this._inProcessing || this._ignoreDuplicate) {
            return;
        }
        asReport.setMessengerLog(this._messengerLog);
        this.processReport(asReport);
    }

    private void storeMDN(ASReport report, XpMessage xpMessage) throws ASReportException, IOException, MessagingException {
        File workFolder = null;
        String databaseId = String.valueOf(xpMessage.getDatabaseId());
        workFolder = xpMessage.isInbound() ? new File(this._folders.getWorkInboundFolder(), databaseId) : new File(this._folders.getWorkOutboundFolder(), databaseId);
        if (!workFolder.exists()) {
            workFolder.mkdirs();
        }
        File mdnFile = new File(workFolder, "headers.txt");
        this._log.debug("Storing MDN data to: " + mdnFile.getAbsolutePath());
        try (BufferedOutputStream mdnOut = new BufferedOutputStream(Files.newOutputStream(mdnFile.toPath(), new OpenOption[0]));){
            MimeBodyPart mimePart = report.getReportMimePart();
            mimePart.writeTo((OutputStream)mdnOut);
            ((OutputStream)mdnOut).flush();
        }
    }

    private void createXPMessage(ASObject asObject, String protocol) throws FatalASProcessingException, DbException {
        int messageStatus;
        boolean isASMessage = asObject instanceof ASMessage;
        this._incomingMessage = asObject;
        this._xpMessage = new XpMessage();
        this._xpMessage.setMessagePackaging(this._incomingMessage.getPackagingName());
        this._xpMessage.setProtocol(protocol);
        this._xpMessage.setInboundMessage(true);
        this._xpMessage.setMessageTimestamp(this._referenceDate.getReferenceDate());
        String messageId = this._incomingMessage.getMessageId();
        if (messageId == null || messageId.trim().length() == 0) {
            if (asObject instanceof ASMessage) {
                throw new FatalASProcessingException(-1, "No Message Id found.");
            }
            messageId = this._idGenerator.generateMessageId();
        }
        this._xpMessage.setMessageId(messageId);
        if (isASMessage) {
            this._xpMessage.setConversationId(messageId);
        } else {
            this._xpMessage.setReferenceId(((ASReport)this._incomingMessage).getMDN().getOriginalMessageID());
            this._xpMessage.setConversationId(this._xpMessage.getReferenceId());
        }
        this._xpMessage.setSenderLocalId(this._incomingMessage.getFrom());
        this._xpMessage.setReceiverLocalId(this._incomingMessage.getTo());
        if (isASMessage) {
            this._xpMessage.setAckRequested(((ASMessage)this._incomingMessage).isMDNRequested());
            this._xpMessage.setSyncReplyRequested(((ASMessage)this._incomingMessage).getMDNParameters().isSyncReplyRequested());
        }
        this._xpMessage.setMessengerId(this._messengerConfig.getMessengerId());
        if (this.registerMessage(this._xpMessage)) {
            messageStatus = 0;
        } else {
            boolean updated;
            messageStatus = this.getMessageStatus();
            int direction = this._xpMessage.isInbound() ? 1 : 0;
            this._xpMessage.setDatabaseId(this._messageDAO.getMessageDataID(this._xpMessage.getMessageId(), direction));
            if (messageStatus == 4 && !(updated = this._messageDAO.updateMessageStatus(this._xpMessage.getDatabaseId(), messageStatus, 1))) {
                messageStatus = this.getMessageStatus();
            }
        }
        Object versionIdentifier = " unknown";
        if (this._incomingMessage instanceof IAS3Object) {
            versionIdentifier = " AS3 " + ((IAS3Object)((Object)asObject)).getAS3Version();
        } else if (this._incomingMessage instanceof IAS2Object) {
            versionIdentifier = " AS2 " + ((IAS2Object)((Object)asObject)).getAS2Version();
        } else if (this._incomingMessage instanceof AS1Message) {
            versionIdentifier = " AS1";
        }
        this._messengerLog.log2db(60, this._xpMessage.getDatabaseId(), (String)versionIdentifier + " via " + this._xpMessage.getProtocol());
        try {
            boolean duplicateElimination;
            String originalFilename;
            this._sender = this.identifySender();
            if (this._log.isDebugEnabled() && this._sender != null) {
                this._log.debug("sender: {}", (Object)this._sender.getLocalId());
            }
            this._xpMessage.setSenderLocalId(this._sender.getLocalId());
            this._xpMessage.setSenderInternalId(this._sender.getInternalId());
            this._receiver = this.identifyReceiver();
            if (this._log.isDebugEnabled() && this._receiver != null) {
                this._log.debug("receiver: {}", (Object)this._receiver.getLocalId());
            }
            this._xpMessage.setReceiverLocalId(this._receiver.getLocalId());
            this._xpMessage.setReceiverInternalId(this._receiver.getInternalId());
            this.identifyAgreement();
            String[] originalFilenameValues = this._incomingMessage.getInternetHeaders().getHeader("X-Original-Filename");
            if (originalFilenameValues != null && originalFilenameValues.length > 0 && StringUtils.isNotBlank((CharSequence)(originalFilename = originalFilenameValues[0]))) {
                String decoded = "";
                try {
                    decoded = MimeUtility.decodeText((String)originalFilename);
                }
                catch (UnsupportedEncodingException ex) {
                    this._log.error((Object)ex);
                    decoded = originalFilename;
                }
                this._xpMessage.setProcessingDirective("OriginalFilename", decoded.trim());
                if (this._log.isTraceEnabled()) {
                    this._log.trace("Set processing directive {} to {}", (Object)"OriginalFilename", (Object)originalFilename);
                }
            }
            Optional.ofNullable(asObject.getInternetHeaders().getHeader("X-Remote-Address")).ifPresent(e -> {
                if (((String[])e).length > 0) {
                    try {
                        this._xpMessage.setProcessingDirective("X-RemoteAddress", asObject.getInternetHeaders().getHeader("X-Remote-Address")[0]);
                    }
                    catch (MessagingException ex) {
                        this._log.warn(ex.getMessage());
                    }
                }
            });
            Optional.ofNullable(asObject.getInternetHeaders().getHeader("X-Forwarded-For")).ifPresent(e -> {
                if (((String[])e).length > 0) {
                    try {
                        this._xpMessage.setProcessingDirective("X-ForwardedFor", asObject.getInternetHeaders().getHeader("X-Forwarded-For")[0]);
                    }
                    catch (MessagingException ex) {
                        this._log.warn(ex.getMessage());
                    }
                }
            });
            Optional.ofNullable(asObject.getInternetHeaders().getHeader("User-Agent")).ifPresent(e -> {
                if (((String[])e).length > 0) {
                    try {
                        this._xpMessage.setProcessingDirective("X-UserAgent", asObject.getInternetHeaders().getHeader("User-Agent")[0]);
                    }
                    catch (MessagingException ex) {
                        this._log.warn(ex.getMessage());
                    }
                }
            });
            try {
                String duplString = this._xpMessage.getCommunication().getPackagingOptionValue("/DuplicateElimination");
                duplicateElimination = Boolean.parseBoolean(duplString);
            }
            catch (OptionNotFoundException e2) {
                duplicateElimination = false;
            }
            if (messageStatus == 0 || messageStatus == 4) {
                this._ignoreDuplicate = false;
                this._inProcessing = false;
            } else if (messageStatus == 2) {
                this._ignoreDuplicate = true;
                this._inProcessing = false;
                this._log.warn("Message is currently in the inbound queue.");
            } else if (messageStatus == 3) {
                if (duplicateElimination || asObject instanceof ASReport) {
                    this._ignoreDuplicate = true;
                    this._inProcessing = false;
                } else {
                    this._ignoreDuplicate = false;
                    this._inProcessing = false;
                }
            } else {
                this._log.info("Message received which is currently being processed:{} (status:{})", (Object)this._xpMessage.getMessageId(), (Object)messageStatus);
                this._inProcessing = true;
                return;
            }
            if (this._ignoreDuplicate) {
                this._log.warn("Ignored duplicate message.");
                this._messengerLog.log2db(106, this._xpMessage.getDatabaseId(), null);
            } else {
                this.updateMessage();
            }
        }
        catch (ASException ase) {
            this._log.fatal("Unable to process incoming message. Aborting.", (Throwable)ase);
            this._messengerLog.log2db(527, this._xpMessage.getDatabaseId(), "Unable to identify communication partners. " + ase.getMessage());
            if (!this._ignoreDuplicate) {
                this._messageDAO.updateMessageStatus(this._xpMessage.getDatabaseId(), this._xpMessage.getMessageId(), 4);
            }
            throw new FatalASProcessingException(45001, "Unable to identify communication partners. " + ase.getMessage());
        }
        catch (MessagingException e3) {
            throw new FatalASProcessingException(-1, "Could not read message headers.", e3);
        }
    }

    private void processReport(ASReport asReport) {
        try {
            File workFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(this._xpMessage.getDatabaseId()));
            workFolder.mkdirs();
            this._xpMessage.setCurrentContentReferenceFolder(workFolder);
            try {
                this._messageDAO.updateMessageFolder(this._xpMessage.getDatabaseId(), workFolder);
                this._log.debug("Storing message header data.");
                this.storeMDN(asReport, this._xpMessage);
            }
            catch (Exception me) {
                throw new ASException(43005, "Could not write MDN to headers.txt.", me);
            }
            this._xpMessage.setIsAck(true);
            this._xpMessage.setMessageType("ACK");
            this._xpMessage.setMessageVersion("2.1");
            this._xpMessage.setSchemaSet("ponton");
            try {
                this.checkSignature();
            }
            catch (ASException ase) {
                String errorMessage = ase.getMessage();
                this.actOnSignatureErrorOfMDN(errorMessage);
                return;
            }
            this.handleMDN(asReport);
            if (this._ignoreDuplicate) {
                this._log.warn("Ignored duplicate message.");
                this._messengerLog.log2db(106, this._xpMessage.getDatabaseId(), null);
                this.setOkStatusForReportMessageInDB();
                return;
            }
            this._receiveFromListener.handleMessage(this._xpMessage);
        }
        catch (ASException ase) {
            this._log.fatal("Unable to process incoming message. Aborting.", (Throwable)ase);
            this._messengerLog.log2db(527, this._xpMessage.getDatabaseId(), "Unable to process incoming message. Aborting. " + ase.getMessage());
            if (this._xpMessage.getReferenceDatabaseId() > -1L) {
                this._messengerLog.log2dbWithHref(215, this._xpMessage.getReferenceDatabaseId(), this._xpMessage.getMessageId(), this._xpMessage.getMessageId(), this._xpMessage.getDatabaseId(), this._xpMessage.isInbound());
            }
            try {
                this.messageWorkDataDAO.uploadDirectoryToDB(this._xpMessage.getDatabaseId(), this._xpMessage.getCurrentContentReferenceFolder());
                FileSystemUtils.deleteRecursively((File)this._xpMessage.getCurrentContentReferenceFolder());
            }
            catch (DbException e) {
                this._log.error("Couldn't upload message folder for {} to database: {}", (Object)this._xpMessage.getDatabaseId(), (Object)e.getMessage());
            }
            this._archiveProcessor.sendFilesToArchive(this._xpMessage.getDatabaseId(), true);
            this._messageDAO.updateMessageStatus(this._xpMessage.getDatabaseId(), this._xpMessage.getMessageId(), 4);
        }
    }

    private void setOkStatusForReportMessageInDB() {
        try {
            this._messageDAO.updateMessage(this._xpMessage);
            this._messageDAO.updateMessageStatus(this._xpMessage.getDatabaseId(), this._xpMessage.getMessageId(), 3);
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    private void actOnSignatureErrorOfMDN(String errorMessage) {
        this._log.error("Unable to process incoming message. Aborting. Cause: " + errorMessage);
        this._messengerLog.log2db(534, this._xpMessage.getDatabaseId(), "Unable to process incoming message. Aborting. " + errorMessage);
        if (this._xpMessage.getReferenceDatabaseId() > -1L) {
            this._messengerLog.log2dbWithHref(215, this._xpMessage.getReferenceDatabaseId(), errorMessage, this._xpMessage.getMessageId(), this._xpMessage.getDatabaseId(), this._xpMessage.isInbound());
        }
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(this._xpMessage.getDatabaseId(), this._xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)this._xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            this._log.error("Couldn't upload message folder for {} to database: {}", (Object)this._xpMessage.getDatabaseId(), (Object)e.getMessage());
        }
        this._archiveProcessor.sendFilesToArchive(this._xpMessage.getDatabaseId(), true);
        this._messageDAO.updateMessageStatus(this._xpMessage.getDatabaseId(), this._xpMessage.getMessageId(), 4);
    }

    private ASReport processMessage() {
        try {
            File workFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(this._xpMessage.getDatabaseId()));
            workFolder.mkdirs();
            this._xpMessage.setCurrentContentReferenceFolder(workFolder);
            this.storePackagingEnvelope(workFolder);
            if (this._ignoreDuplicate) {
                this._log.debug("Creating OK MDN.");
                return this.createPositiveMDN("Duplicate message successfully processed.");
            }
            this.handleMessage();
            ProcessingResult[] result = this._receiveFromListener.handleMessage(this._xpMessage);
            if (result != null && result.length > 0 && ((ASMessage)this._incomingMessage).isMDNRequested()) {
                return this.createMDNFromProcessingResult(result);
            }
            if (result != null && result.length == 0) {
                return this.createMDNforUnexpectedProcessingError();
            }
            return null;
        }
        catch (ASException ase) {
            return this.handleException(ase, 527, ASReport.DispositionModifierExtension.ERROR_UNEXPECTED_PROCESSING_ERROR);
        }
    }

    private ASReport createMDNforUnexpectedProcessingError() {
        String description = "No reply from receiving process.";
        this.notifyAdapter(ErrorNotificationResult.ErrorType.OTHER_ERROR, "No reply from receiving process.");
        this._log.error("No reply from receiving process.");
        this._messengerLog.log2db(527, this._xpMessage.getDatabaseId(), "No reply from receiving process. Aborting.");
        return this.createNegativeMDN(ASReport.DispositionModifier.ERROR, ASReport.DispositionModifierExtension.ERROR_UNEXPECTED_PROCESSING_ERROR, "Incoming message could not be processed.", List.of("No reply from receiving process."));
    }

    private ASReport createMDNFromProcessingResult(ProcessingResult[] result) {
        if (result[result.length - 1].getResultCode() == 0) {
            this._log.debug("Creating OK MDN.");
            return this.createPositiveMDN("Message successfully processed. " + result[result.length - 1].getDescription());
        }
        List<ErrorNotificationResult> notifications = ProcessingResultToErrorNotificationResultConverter.mapResultsToNotificationCodes(result);
        this._errorNotificationService.notifyAdapter(this._xpMessage, notifications);
        this._log.debug("Creating Error MDN.");
        return this.createNegativeMDN(ASReport.DispositionModifier.ERROR, ASReport.DispositionModifierExtension.ERROR_UNEXPECTED_PROCESSING_ERROR, "Incoming message could not be processed.", this.extractDescriptions(result));
    }

    private void storePackagingEnvelope(File workFolder) throws ASException {
        try {
            this._messageDAO.updateMessageFolder(this._xpMessage.getDatabaseId(), workFolder);
            this._log.debug("Storing message header data.");
            File headersFile = new File(workFolder, "headers.txt");
            MimeMultipartUtils.writeHeadersFile(headersFile, this._incomingMessage.getInternetHeaders());
        }
        catch (Exception ex) {
            throw new ASException(43005, "Could not write message headers.", ex);
        }
    }

    private List<String> extractDescriptions(ProcessingResult[] processingResults) {
        ArrayList<String> result = new ArrayList<String>(processingResults.length);
        for (ProcessingResult processingResult : processingResults) {
            result.add(processingResult.getDescription());
        }
        return result;
    }

    private void notifyAdapter(ErrorNotificationResult.ErrorType code, String description) {
        ArrayList<ErrorNotificationResult> errorNotificationResults = new ArrayList<ErrorNotificationResult>(1);
        errorNotificationResults.add(new ErrorNotificationResult(code, description));
        this._errorNotificationService.notifyAdapter(this._xpMessage, errorNotificationResults);
    }

    private void decryptMessage() throws ASException {
        try {
            boolean encrypted = MimeMultipartUtils.isSMIMEEncrypted((Part)this._incomingMessage.getMimePart());
            String expectedEncryptionAlgorithm = this.getEncAlgorithm();
            if (encrypted) {
                if (expectedEncryptionAlgorithm == null) {
                    throw new ASException(-1, "Message is encrypted, but decryption is disabled in agreement.");
                }
                List<SignCertInfo> signCertInfos = this._receiver.getAllKeys();
                this._log.debug("Decrypting message");
                if (signCertInfos.isEmpty()) {
                    throw new ASException(43000, "S/MIME decryption failed. No certificate for receiver is installed.");
                }
                SMIMEDecrypter.SMIMEDecryptResult smimeDecryptResult = this._smimeDecrypter.decryptMimeMessage(signCertInfos, this._incomingMessage.getMimePart());
                this._incomingMessage.setMimePart(smimeDecryptResult.getDecryptedContent());
                this._includeHeaderInDigestCalculation = true;
                String usedEncAlgorithm = smimeDecryptResult.getUsedAlgorithm();
                if (!expectedEncryptionAlgorithm.equals(usedEncAlgorithm)) {
                    String errorMsg = "Message should be encrypted with '" + expectedEncryptionAlgorithm + "' but '" + usedEncAlgorithm + "' was used by sender.";
                    throw new ASException(-1, errorMsg);
                }
                String usingInfoText = this._certificateUtility.toUsingInfoText(smimeDecryptResult.getUsedCertificate(), smimeDecryptResult.getUsedAlgorithm() + " and certificate");
                this._log.debug("Successfully decrypted S/MIME message " + usingInfoText);
                this._messengerLog.log2db(85, this._xpMessage.getDatabaseId(), usingInfoText);
            } else {
                if (expectedEncryptionAlgorithm != null) {
                    throw new ASException(-1, "Message should be encrypted, but is not encrypted.");
                }
                this._log.debug("Message is not S/MIME encrypted.");
            }
        }
        catch (MessagingException | IOException | NoSuchAlgorithmException | CMSException | SMIMEException e) {
            throw new ASException(-1, "Could not decrypt message: " + e.getMessage(), e);
        }
    }

    private String getEncAlgorithm() {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue("/EncryptMessage");
            if ("true".equals(option)) {
                try {
                    Object encryptionAlgo = this._xpMessage.getCommunication().getPackagingOptionValue("/EncryptMessage/ExtendedEncryptionAlgorithm");
                    if (((String)encryptionAlgo).endsWith("/OAEP")) {
                        encryptionAlgo = (String)encryptionAlgo + "_SHA1";
                    }
                    return encryptionAlgo;
                }
                catch (OptionNotFoundException onfe) {
                    return "DES_EDE3_CBC";
                }
            }
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private void decompressMessage() throws ASException {
        block10: {
            try {
                if (MimeMultipartUtils.isSMIMECompressed((Part)this._incomingMessage.getMimePart())) {
                    this._log.debug("Decompressing message.");
                    try {
                        MimeBodyPart compressedContent = this._incomingMessage.getMimePart();
                        int beforeSize = compressedContent.getSize();
                        MimeBodyPart decompressedContent = this._smimeDecompressor.decompressMimeMessage(this._incomingMessage.getMimePart());
                        int afterSize = decompressedContent.getSize();
                        this._incomingMessage.setMimePart(decompressedContent);
                        this._decompressed = true;
                        String text = null;
                        if (beforeSize > 0 && afterSize > 0) {
                            text = beforeSize + " bytes -> " + afterSize + " bytes";
                            this._log.debug("Successfully decompressed S/MIME message: " + text);
                        } else {
                            this._log.debug("Successfully decompressed S/MIME message.");
                        }
                        this._messengerLog.log2db(87, this._xpMessage.getDatabaseId(), text);
                        break block10;
                    }
                    catch (IllegalArgumentException compressedContent) {
                        break block10;
                    }
                    catch (SMIMEException se) {
                        throw new ASException(43000, "S/MIME decompression error.", se);
                    }
                    catch (CMSException ce) {
                        throw new ASException(43000, "S/MIME decompression error.", ce);
                    }
                }
                this._log.debug("Message is not S/MIME compressed.");
            }
            catch (ASException asex) {
                throw asex;
            }
            catch (Exception e) {
                this._log.error("unexpected error", (Throwable)e);
                throw new ASException(43000, "S/MIME Message could not be decompressed");
            }
        }
    }

    private void checkSignature() throws ASException {
        block11: {
            try {
                boolean isSigned = MimeMultipartUtils.isSMIMESigned((Part)this._incomingMessage.getMimePart());
                String expectedBusinessSignAlgorithm = this.getBuisnessSignAlgorithm();
                String expectedMDNSignAlgorithm = this.getMDNSignAlgorithm();
                String expectedSignAlgorithm = this._xpMessage.isAck() ? expectedMDNSignAlgorithm : this.getBuisnessSignAlgorithm();
                if (isSigned) {
                    if (this._xpMessage.isAck() && !this.isSignedMDNRequested()) {
                        this._log.warn("Expected unsigned MDN, but it was signed.");
                    }
                    if (!this._xpMessage.isAck() && expectedBusinessSignAlgorithm == null) {
                        throw new ASException(-1, "Message is signed, but signature is disabled in agreement.");
                    }
                    this._incomingMessage.setWasSigned(true);
                    String usedCertificate = null;
                    CppPartner sender = this._sender;
                    try {
                        usedCertificate = this.verifySignature(expectedSignAlgorithm, sender);
                    }
                    catch (SMIMEUnknownSignCertificateExeption e) {
                        usedCertificate = this.tryUpdateFromRegistryAndVerifyAgain(expectedSignAlgorithm, e);
                    }
                    this._log.debug("S/MIME signature of the message successfully verified " + usedCertificate);
                    this._messengerLog.log2db(83, this._xpMessage.getDatabaseId(), usedCertificate);
                    break block11;
                }
                if (!this._xpMessage.isAck() && expectedBusinessSignAlgorithm != null) {
                    throw new ASException(-1, "Message should be signed, but is not signed.");
                }
                if (this._xpMessage.isAck() && this.isSignedMDNRequested()) {
                    throw new ASException(-1, "Expected signed MDN, but it was unsigned.");
                }
                this._log.debug("No S/MIME signature found.");
            }
            catch (SMIMEValidationException e) {
                throw new ASException(-1, e.getMessage());
            }
            catch (ASException asex) {
                throw asex;
            }
            catch (Exception e) {
                this._log.error("unexpected error", (Throwable)e);
                throw new ASException(43000, "S/MIME Signature could not be validated");
            }
        }
    }

    private String tryUpdateFromRegistryAndVerifyAgain(String expectedSignAlgorithm, SMIMEUnknownSignCertificateExeption e) throws ASException, SMIMEValidationException {
        CppPartner updated;
        if (this._sender.isFromRegistry() && this._sender.isAutoupdate() && (updated = this._registryProfileUpdater.updateProfile(this._sender)) != null) {
            this._log.debug("verifying signature with new certificates of updated profile");
            return this.verifySignature(expectedSignAlgorithm, updated);
        }
        throw e;
    }

    private String verifySignature(String expectedSignAlgorithm, CppPartner sender) throws ASException, SMIMEValidationException {
        Set<X509Certificate> listOfSenderCertificate = sender.getAllCertificates();
        if (listOfSenderCertificate.isEmpty()) {
            this._log.trace("No certificate is installed for sender " + String.valueOf(this._sender));
            throw new SMIMEUnknownSignCertificateExeption(-1, "No certificate is installed for sender " + String.valueOf(this._sender), new ArrayList<CertificateInfo>());
        }
        this._log.debug("Signature check");
        SMIMEVerifyResult verifySignatureResult = this._smimeVerifier.verifySignature((MimePart)this._incomingMessage.getMimePart(), listOfSenderCertificate);
        String usedSignAlgorithm = verifySignatureResult.getSignatureAlgorithm();
        if (!(this._xpMessage.isAck() && expectedSignAlgorithm == null || expectedSignAlgorithm.equals(usedSignAlgorithm))) {
            StringBuilder errorMsg = new StringBuilder();
            if (this._xpMessage.isAck()) {
                errorMsg.append("Response");
            } else {
                errorMsg.append("Message");
            }
            errorMsg.append(" should be signed with '");
            errorMsg.append(expectedSignAlgorithm);
            errorMsg.append("' but '");
            errorMsg.append(usedSignAlgorithm);
            errorMsg.append("' was used by sender.");
            throw new ASException(-1, errorMsg.toString());
        }
        this._incomingMessage.setMimePart(verifySignatureResult.getBodyPart());
        String usedCertificate = this._certificateUtility.toUsingInfoText(verifySignatureResult.getSenderCertificate(), usedSignAlgorithm + " and certificate");
        this._includeHeaderInDigestCalculation = true;
        return usedCertificate;
    }

    private boolean isSignedMDNRequested() {
        try {
            Communication outboundCommunication = this._xpMessage.getAgreement().getCommunication(this._xpMessage.getReceiverLocalId(), this._xpMessage.getSenderLocalId());
            String requestMDNValue = outboundCommunication.getPackagingOptionValue("/RequestMDN");
            return requestMDNValue != null && !"unsigned".equals(requestMDNValue);
        }
        catch (CommunicationNotFoundException | OptionNotFoundException xMLPipeException) {
            return false;
        }
    }

    private String getBuisnessSignAlgorithm() {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue("/SignMessage");
            return ASPackager.getSignAlgorithm(option);
        }
        catch (OptionNotFoundException optionNotFoundException) {
            return null;
        }
    }

    private String getMDNSignAlgorithm() {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue("/SmimeMdnSignature");
            if ("Same as business signature".equals(option)) {
                return this.getBuisnessSignAlgorithm();
            }
            return ASPackager.getSignAlgorithm(option);
        }
        catch (OptionNotFoundException onfe) {
            return this.getBuisnessSignAlgorithm();
        }
    }

    private String[] getSupportedMicAlgorithms(String[] micAlgorithms) throws NoSuchAlgorithmException {
        StringBuilder suppliedAlgorithmIdentifiers = new StringBuilder();
        for (int i = 0; i < micAlgorithms.length; ++i) {
            if (i > 0) {
                suppliedAlgorithmIdentifiers.append(", ");
            }
            String micAlgorithm = micAlgorithms[i];
            suppliedAlgorithmIdentifiers.append(micAlgorithm);
            String[] result = this.normalizeMicAlgorithm(micAlgorithm);
            if (result == null) continue;
            return result;
        }
        throw new NoSuchAlgorithmException("Cannot identify algorithm by '" + String.valueOf(suppliedAlgorithmIdentifiers) + "'");
    }

    private String[] normalizeMicAlgorithm(String micAlgorithm) {
        Object result = this.isSHA512(micAlgorithm) ? new String[]{"sha-512", micAlgorithm} : (this.isSHA384(micAlgorithm) ? new String[]{"sha-384", micAlgorithm} : (this.isSHA256(micAlgorithm) ? new String[]{"sha-256", micAlgorithm} : (this.isSHA224(micAlgorithm) ? new String[]{"sha-224", micAlgorithm} : (this.isSHA1(micAlgorithm) ? new String[]{"sha1", micAlgorithm} : (this.isMD5(micAlgorithm) ? new String[]{"md5", micAlgorithm} : null)))));
        return result;
    }

    private boolean isSHA512(String micAlgorithm) {
        return "sha-512".equalsIgnoreCase(micAlgorithm) || "SHA512".equalsIgnoreCase(micAlgorithm) || "SHA_512".equalsIgnoreCase(micAlgorithm);
    }

    private boolean isSHA384(String micAlgorithm) {
        return "sha-384".equalsIgnoreCase(micAlgorithm) || "SHA384".equalsIgnoreCase(micAlgorithm) || "SHA_384".equalsIgnoreCase(micAlgorithm);
    }

    private boolean isSHA256(String micAlgorithm) {
        return "sha-256".equalsIgnoreCase(micAlgorithm) || "SHA256".equalsIgnoreCase(micAlgorithm) || "SHA_256".equalsIgnoreCase(micAlgorithm);
    }

    private boolean isSHA224(String micAlgorithm) {
        return "sha-224".equalsIgnoreCase(micAlgorithm) || "SHA224".equalsIgnoreCase(micAlgorithm) || "SHA_224".equalsIgnoreCase(micAlgorithm);
    }

    private boolean isSHA1(String micAlgorithm) {
        return "sha1".equalsIgnoreCase(micAlgorithm) || "SHA-1".equalsIgnoreCase(micAlgorithm) || "SHA_1".equalsIgnoreCase(micAlgorithm);
    }

    private boolean isMD5(String micAlgorithm) {
        return "md5".equalsIgnoreCase(micAlgorithm) || "MD-5".equalsIgnoreCase(micAlgorithm) || "MD_5".equalsIgnoreCase(micAlgorithm);
    }

    private void calculateMIC() throws ASException {
        if (((ASMessage)this._incomingMessage).isMDNRequested() && ((ASMessage)this._incomingMessage).getMDNParameters().isSignedReceiptProtocolRequired() && ((ASMessage)this._incomingMessage).getMDNParameters().isSignedReceiptMicAlgRequired()) {
            this._log.debug("A signed MDN is requested - going to calculate the message digest");
            try {
                String[] micAlgorithms = ((ASMessage)this._incomingMessage).getMDNParameters().getSignedReceiptMicAlgValues();
                String[] recognizedDigestAlgorithm = this.getSupportedMicAlgorithms(micAlgorithms);
                String pontonLikeDigestAlgorithm = recognizedDigestAlgorithm[0];
                String receivedDigestAlgorithm = recognizedDigestAlgorithm[1];
                String digestAlgorithm = MDNParameters.getDigestAlgorithm(pontonLikeDigestAlgorithm);
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Using '" + pontonLikeDigestAlgorithm + "' algorithm to calculate the digest. Include MIME headers in calculation: " + this._includeHeaderInDigestCalculation);
                }
                MessageDigestCalculator mdc = this.createMessageDigestCalculator(digestAlgorithm);
                if (this._log.isTraceEnabled()) {
                    this._log.trace("base64-digest: {}", (Object)mdc.getDigestBase64());
                    this._log.trace("binary-digest: 0x{}", (Object)new BigInteger(mdc.getDigest()).toString(16));
                }
                ((ASMessage)this._incomingMessage).setMICValue(mdc.getDigestBase64(), receivedDigestAlgorithm);
            }
            catch (SecurityException se) {
                throw new ASException(43006, (Throwable)se);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new ASException(43006, (Throwable)nsae);
            }
        }
    }

    private int getMessageStatus() throws DbException {
        int messageStatus = 0;
        messageStatus = this._messageDAO.getStatusOfMessage(this._incomingMessage.getMessageId(), 1);
        return messageStatus;
    }

    private boolean registerMessage(XpMessage xpMessage) throws DbException {
        try {
            this._messageDAO.registerMessage(xpMessage);
            return true;
        }
        catch (MessageExistsException e) {
            return false;
        }
        catch (DbException e) {
            this._log.fatal("Error while registering Message: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void identifyAgreement() throws ASException {
        try {
            Agreement agreement = this._agreements.getAgreement(this._receiver.getLocalId(), this._sender.getLocalId(), true);
            this._xpMessage.setAgreement(agreement);
            this._xpMessage.setOwnPartner(this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true));
            this._xpMessage.setCommunicationPartner(this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
            this._xpMessage.setCommunication(agreement.getCommunication(this._sender.getLocalId(), this._receiver.getLocalId()));
            this.validateSupportedPackager(this._xpMessage);
            this._xpMessage.setAdapterId(this._xpMessage.getAgreement().getDefaultAdapterId());
        }
        catch (AgreementNotFoundException e) {
            this._log.error("CPA is not found on the System: {}", (Object)e.getMessage());
            throw new ASException(43000, "CPA is not found.", e);
        }
        catch (AgreementException e) {
            this._log.error("Communication is not defined in Agreement: {}", (Object)e.getMessage());
            throw new ASException(43000, "CPA is incomplete", e);
        }
        catch (ProfileException e) {
            this._log.error("CPP is not found on the System: {}", (Object)e.getMessage());
            throw new ASException(43000, "CPP is not found.", e);
        }
    }

    abstract void validateSupportedPackager(XpMessage var1) throws ASException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleMessage() throws ASException {
        this._log.debug("Storing message payload data.");
        try {
            block10: {
                MimeMultipart mp;
                block9: {
                    block7: {
                        ContentType contentType;
                        DataHandler handler;
                        block8: {
                            handler = this._incomingMessage.getMimePart().getDataHandler();
                            contentType = new ContentType(handler.getContentType());
                            this._log.debug("Received message includes Content-Type '{}'.", (Object)contentType.toString());
                            if (!contentType.getPrimaryType().equalsIgnoreCase("multipart")) break block7;
                            if (!contentType.getSubType().equalsIgnoreCase("related")) break block8;
                            mp = (MimeMultipart)handler.getContent();
                            break block9;
                        }
                        if (!this.isMailClientSupported()) {
                            String errorText = "Received content MIME part with not supported Content-Type '" + contentType.getBaseType() + "'.";
                            this._log.error(errorText);
                            throw new ASException(-1, errorText);
                        }
                        this.findPayloadAttachmentInMimeMultipart(handler);
                        break block10;
                    }
                    MimeMultipartUtils.saveAsXpPayload(this._xpMessage, (BodyPart)this._incomingMessage.getMimePart());
                    break block10;
                }
                for (int mimePartCouner = 0; mimePartCouner < mp.getCount(); ++mimePartCouner) {
                    BodyPart bodyPart = mp.getBodyPart(mimePartCouner);
                    if (!this.isPayloadSet()) {
                        MimeMultipartUtils.saveAsXpPayload(this._xpMessage, bodyPart);
                        continue;
                    }
                    MimeMultipartUtils.saveAsXpAttachment(this._xpMessage, bodyPart);
                }
            }
            if (!this.isPayloadSet()) {
                String errorText = "No payload was found.";
                this._log.error("No payload was found.");
                throw new ASException(-1, "No payload was found.");
            }
            this.updateMessage();
            return;
        }
        catch (ASException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ASException(43005, ex.getMessage(), ex);
        }
    }

    private void findPayloadAttachmentInMimeMultipart(DataHandler handler) throws IOException, MessagingException {
        MimeMultipart mp = (MimeMultipart)handler.getContent();
        for (int mimePartCouner = 0; mimePartCouner < mp.getCount(); ++mimePartCouner) {
            BodyPart bodyPart = mp.getBodyPart(mimePartCouner);
            ContentType bpContentType = MimeMultipartUtils.getContentType((Part)bodyPart);
            if (this._log.isDebugEnabled()) {
                this._log.debug("MIME part at the position '{}' contains Content-Type '{}'.", (Object)mimePartCouner, (Object)bpContentType.toString());
            }
            if (bpContentType.getPrimaryType().equalsIgnoreCase("multipart")) {
                this._log.debug("The messenger ignores the MIME part number '{}'.", (Object)mimePartCouner);
                continue;
            }
            String disposition = bodyPart.getDisposition();
            if (disposition == null || !disposition.equalsIgnoreCase("attachment")) {
                this._log.debug("The messenger ignores the MIME part number '{}'.", (Object)mimePartCouner);
                continue;
            }
            ContentDisposition bpContentDisposition = MimeMultipartUtils.getContentDisposition(bodyPart);
            if (!this.isSupportedType(bpContentType, bpContentDisposition)) continue;
            MimeMultipartUtils.saveAsXpPayload(this._xpMessage, bodyPart);
            break;
        }
    }

    private boolean isSupportedType(ContentType contentType, ContentDisposition contentDisposition) {
        String fileExtension = MimeTypeMapper.getExtension(contentType.getBaseType());
        if (this.isSupportedFileExtension(fileExtension)) {
            return true;
        }
        String filename = contentDisposition.getParameter("filename");
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            fileExtension = filename.substring(filename.lastIndexOf(46));
            return this.isSupportedFileExtension(fileExtension);
        }
        return false;
    }

    private boolean isSupportedFileExtension(String fileExtension) {
        return ".xml".equalsIgnoreCase(fileExtension) || ".edi".equalsIgnoreCase(fileExtension) || ".x12".equalsIgnoreCase(fileExtension);
    }

    private boolean isMailClientSupported() {
        try {
            String value = this._xpMessage.getCommunication().getPackagingOptionValue("/MailClientSupport");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return Boolean.parseBoolean(value);
            }
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean isPayloadSet() {
        return this._xpMessage.getCurrentContentReference() != null;
    }

    private void handleMDN(ASReport report) throws ASException {
        boolean failed = false;
        DispositionNotification mdn = report.getMDN();
        try {
            XpAcknowledgment ack = new XpAcknowledgment(report.getMessageId(), this._incomingMessage.getMessageDate(), mdn.getOriginalMessageID());
            ack.setMessageTime(this._incomingMessage.getMessageDate());
            long messageDataID = this._messageDAO.getMessageDataID(mdn.getOriginalMessageID(), 0);
            int status = this._messageDAO.getStatusOfMessage(mdn.getOriginalMessageID(), 0);
            MDNData mdnData = this._mdnDataDAO.getMDNDataById(messageDataID);
            if (status == 3) {
                this._ignoreDuplicate = true;
                return;
            }
            this.copyErrorsAndWarningsFromMDN(mdn, ack);
            boolean bl = failed = !ack.getOverallResult().equals("Success");
            if (!failed && this._xpMessage.isAck() && this.isSignedMDNRequested() && !this._incomingMessage.wasSigned()) {
                String errorMessage = "Response should be signed, but is not signed.";
                this.actOnSignatureErrorOfMDN(errorMessage);
                throw new ASException(-1, errorMessage);
            }
            if (!failed && mdnData != null) {
                failed = this.verifyMIC(mdn, ack, mdnData);
            }
            if (!failed) {
                ack.addError("Success", "Message was successfully received");
            } else {
                ack.setOverallResult("Error");
            }
            File workFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(this._xpMessage.getDatabaseId()));
            workFolder.mkdirs();
            File ackRef = ack.saveToDisk(workFolder);
            this._xpMessage.setCurrentContentReference(ackRef);
            this.updateMessage();
            this.storeMDN(report, this._xpMessage);
        }
        catch (ASReportException | MessagingException | IOException e) {
            this._log.error("could not store MDN... stop further processing now:" + e.getMessage(), e);
        }
        catch (DbException | JAXBException je) {
            this._log.error("could not store Xp-ACK... stop further processing now:" + je.getMessage(), je);
        }
    }

    private boolean verifyMIC(DispositionNotification mdn, XpAcknowledgment ack, MDNData mdnData) {
        boolean failed = false;
        if (StringUtils.isBlank((CharSequence)mdn.getReceivedContentMIC()) || StringUtils.isBlank((CharSequence)mdn.getReceivedContentMICAlg())) {
            ack.addError("Error", "Receiver did not send a MIC value with the MDN.");
            failed = true;
        } else {
            String[] receivedMicAlgorithm = this.normalizeMicAlgorithm(mdn.getReceivedContentMICAlg());
            String[] expectedMicAlgorithm = this.normalizeMicAlgorithm(mdnData.getMessageDigestAlgorithm());
            if (receivedMicAlgorithm == null || !receivedMicAlgorithm[0].equals(expectedMicAlgorithm[0])) {
                ack.addError("Error", "Receiver used MIC algorithm '" + mdn.getReceivedContentMICAlg() + "', but '" + mdnData.getMessageDigestAlgorithm() + "' was requested.");
                failed = true;
            } else if (mdn.getReceivedContentMIC().equals(mdnData.getMessageDigest())) {
                ack.addError("Success", "Message digest successfully verified using " + mdnData.getMessageDigestAlgorithm() + ".");
            } else {
                ack.addError("Error", "Message digest is different. Used digest algorithm '" + mdnData.getMessageDigestAlgorithm() + "'.");
                failed = true;
            }
        }
        return failed;
    }

    private void copyErrorsAndWarningsFromMDN(DispositionNotification mdn, XpAcknowledgment ack) {
        if (ASReport.DispositionType.PROCESSED.getEnumValue().equalsIgnoreCase(mdn.getDispositionType())) {
            ack.setOverallResult("Success");
        } else {
            ack.setOverallResult("Error");
        }
        if (StringUtils.isNotBlank((CharSequence)mdn.getDispositionModifier())) {
            if (this.getLowerCaseDispositionModifier(mdn).startsWith(ASReport.DispositionModifier.ERROR.getEnumValue()) || this.getLowerCaseDispositionModifier(mdn).startsWith(ASReport.DispositionModifier.FAILURE.getEnumValue())) {
                ack.setOverallResult("Error");
                if (StringUtils.isNotBlank((CharSequence)mdn.getDispositionModifierText())) {
                    ack.addError("Error", mdn.getDispositionModifierText());
                }
            } else if (this.getLowerCaseDispositionModifier(mdn).startsWith(ASReport.DispositionModifier.WARNING.getEnumValue()) && StringUtils.isNotBlank((CharSequence)mdn.getDispositionModifierText())) {
                ack.addError("Warning", mdn.getDispositionModifierText());
            }
        }
        Iterator<String> failures = mdn.getFailureIterator();
        while (failures.hasNext()) {
            ack.addError("Error", failures.next());
        }
        Iterator<String> errors = mdn.getErrorIterator();
        while (errors.hasNext()) {
            ack.addError("Error", errors.next());
        }
        Iterator<String> warnings = mdn.getWarningIterator();
        while (warnings.hasNext()) {
            ack.addError("Warning", warnings.next());
        }
    }

    private String getLowerCaseDispositionModifier(DispositionNotification mdn) {
        return mdn.getDispositionModifier().toLowerCase();
    }

    private void updateMessage() {
        try {
            this._messageDAO.updateMessage(this._xpMessage);
        }
        catch (DbException e) {
            this._log.fatal("Error while updating Message: {}", (Object)e.getMessage());
        }
    }

    private void registerReport(ASReport report) throws CommunicationNotFoundException, DbException, JAXBException, ASReportException, IOException, MessagingException {
        XpMessage xpMessage = new XpMessage();
        xpMessage.setMessageId(report.getMessageId());
        xpMessage.setInboundMessage(false);
        xpMessage.setConversationId(this._xpMessage.getConversationId());
        xpMessage.setMessageType("ACK");
        xpMessage.setSchemaSet("ponton");
        xpMessage.setMessageVersion("2.1");
        xpMessage.setProtocol(this._xpMessage.getProtocol());
        xpMessage.setReceiverLocalId(this._xpMessage.getSenderLocalId());
        xpMessage.setSenderLocalId(this._xpMessage.getReceiverLocalId());
        xpMessage.setAgreement(this._xpMessage.getAgreement());
        xpMessage.setOwnPartner(this._xpMessage.getOwnPartner());
        xpMessage.setCommunicationPartner(this._xpMessage.getCommunicationPartner());
        xpMessage.setCommunication(xpMessage.getAgreement().getCommunication(xpMessage.getSenderLocalId(), xpMessage.getReceiverLocalId()));
        xpMessage.setMessageTimestamp(this._referenceDate.getReferenceDate());
        xpMessage.setReferenceId(this._xpMessage.getMessageId());
        xpMessage.setSyncReplyRequested(((ASMessage)this._incomingMessage).getMDNParameters().isSyncReplyRequested());
        xpMessage.setPackaged(true);
        xpMessage.setMessagePackaging(report.getPackagingName());
        xpMessage.setMessengerId(this._messengerConfig.getMessengerId());
        this._messageDAO.registerMessage(xpMessage);
        report.setXpMessage(xpMessage);
        XpAcknowledgment ack = new XpAcknowledgment(report.getMessageId(), this._xpMessage.getMessageTimestamp(), this._xpMessage.getMessageId());
        ack.setMessageTime(this._incomingMessage.getMessageDate());
        xpMessage.setReferenceId(this._xpMessage.getMessageId());
        if (ASReport.DispositionType.PROCESSED.getEnumValue().equalsIgnoreCase(report.getMDN().getDispositionType())) {
            ack.setOverallResult("Success");
            ack.addError("Success", "Message was successfully received");
        } else {
            ack.setOverallResult("Error");
        }
        if (report.getMDN().getDispositionModifier() != null && report.getMDN().getDispositionModifier().length() > 0) {
            if (report.getMDN().getDispositionModifier().toLowerCase().startsWith(ASReport.DispositionModifier.ERROR.getEnumValue()) || report.getMDN().getDispositionModifier().toLowerCase().startsWith(ASReport.DispositionModifier.FAILURE.getEnumValue())) {
                if (report.getMDN().getDispositionModifierText() != null && report.getMDN().getDispositionModifierText().length() > 0) {
                    ack.addError("Error", report.getMDN().getDispositionModifierText());
                }
            } else if (report.getMDN().getDispositionModifier().toLowerCase().startsWith(ASReport.DispositionModifier.WARNING.getEnumValue()) && report.getMDN().getDispositionModifierText() != null && report.getMDN().getDispositionModifierText().length() > 0) {
                ack.addError("Warning", report.getMDN().getDispositionModifierText());
            }
        }
        File workFolder = new File(this._folders.getWorkOutboundFolder(), String.valueOf(xpMessage.getDatabaseId()));
        workFolder.mkdirs();
        File ackRef = ack.saveToDisk(workFolder);
        xpMessage.setCurrentContentReference(ackRef);
        this._fileRefDAO.insertMessageFileReference(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder(), xpMessage.getCurrentContentReference().getName(), xpMessage.getCurrentContentType());
        this.storeMDN(report, xpMessage);
        xpMessage.setAgreement(this._xpMessage.getAgreement());
        xpMessage.setOwnPartner(this._xpMessage.getOwnPartner());
        xpMessage.setCommunicationPartner(this._xpMessage.getCommunicationPartner());
        try {
            Communication responseSettings = xpMessage.getAgreement().getCommunication(this._xpMessage.getReceiverLocalId(), this._xpMessage.getSenderLocalId());
            xpMessage.setCommunication(responseSettings);
        }
        catch (AgreementException agreementException) {
            // empty catch block
        }
        this._messageDAO.updateMessage(xpMessage);
    }

    public void setIncomingMessage(ASMessage incomingMessage) {
        this._incomingMessage = incomingMessage;
    }
}

