/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.listener;

import de.pontonconsulting.xmlpipe.jaxb.as4.Description;
import de.pontonconsulting.xmlpipe.jaxb.as4.Envelope;
import de.pontonconsulting.xmlpipe.jaxb.as4.Error;
import de.pontonconsulting.xmlpipe.jaxb.as4.MessageInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.ObjectFactory;
import de.pontonconsulting.xmlpipe.jaxb.as4.SignalMessage;
import de.pontonconsulting.xmlpipe.listener.AS4Exception;
import de.pontonconsulting.xmlpipe.listener.AS4ProcessorHelper;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4Error;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4MessageHelper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS4ErrorProcessor {
    private static final String CONTENT_ID = "Content-ID";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AS4SIGNAL_PONTON_DE = "as4signal@ponton.de";
    private static final String APPLICATION_SOAP_XML = "application/soap+xml";
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.AS4Processor");
    private final MessageFactory _messageFactory;
    private final JAXBContext _as4JAXBContext;
    private final ReferenceDateTask referenceDateTask;
    private final IdGenerator _idGenerator;
    private final AS4ProcessorHelper _as4ProcessorHelper;
    private final ObjectFactory _as4ObjectFactory;

    public AS4ErrorProcessor(MessageFactory messageFactory, JAXBContext as4JAXBContext, ReferenceDateTask referenceDateTask, IdGenerator idGenerator, AS4ProcessorHelper as4ProcessorHelper, ObjectFactory as4ObjectFactory) {
        this._messageFactory = messageFactory;
        this._as4JAXBContext = as4JAXBContext;
        this.referenceDateTask = referenceDateTask;
        this._idGenerator = idGenerator;
        this._as4ProcessorHelper = as4ProcessorHelper;
        this._as4ObjectFactory = as4ObjectFactory;
    }

    public SOAPMessage createErrorMessage(Source refMessageEnvelope, Exception exception) throws IOException, SOAPException {
        String refMessageId = this._as4ProcessorHelper.evalXPath(refMessageEnvelope, AS4ProcessorHelper.USER_MESSAGE_MSGID);
        return this.createErrorMessage(refMessageId, exception);
    }

    public SOAPMessage createErrorMessage(String refMessageId, Exception exception) throws IOException, SOAPException {
        AS4Error as4Error = null;
        as4Error = exception instanceof AS4Exception ? ((AS4Exception)exception).getError() : AS4Error.EBMS_0003;
        String description = exception.getMessage();
        ArrayList<AS4ErrorObject> errors = new ArrayList<AS4ErrorObject>(1);
        errors.add(new AS4ErrorObject(this, as4Error, description));
        return this.createErrorMessage(refMessageId, errors);
    }

    private SOAPMessage createErrorMessage(String refMessageId, List<AS4ErrorObject> errors) throws IOException, SOAPException {
        SOAPMessage sOAPMessage;
        block8: {
            InputStream inputstream = this.createInputStream(refMessageId, errors);
            try {
                MimeHeaders mimeheaders = new MimeHeaders();
                mimeheaders.addHeader(CONTENT_TYPE, APPLICATION_SOAP_XML);
                mimeheaders.addHeader(CONTENT_ID, AS4SIGNAL_PONTON_DE);
                sOAPMessage = this._messageFactory.createMessage(mimeheaders, inputstream);
                if (inputstream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SOAPException e) {
                    LOG.error("Could not create error message for the message '{}': {}", (Object)refMessageId, (Object)e.getMessage());
                    throw e;
                }
            }
            inputstream.close();
        }
        return sOAPMessage;
    }

    public SOAPMessage createErrorMessage(ProcessingResult[] results, String refMessageId) throws IOException, SOAPException {
        ArrayList<AS4ErrorObject> errors = new ArrayList<AS4ErrorObject>();
        for (ProcessingResult processingResult : results) {
            errors.add(new AS4ErrorObject(this, this.interpreteResult(processingResult), processingResult.getDescription()));
        }
        return this.createErrorMessage(refMessageId, errors);
    }

    private AS4Error interpreteResult(ProcessingResult result) {
        int code = result.getResultCode();
        if (result.getResultCode() != 0) {
            switch (code) {
                case 2: 
                case 4: {
                    return AS4Error.EBMS_0102;
                }
                case 5: {
                    return AS4Error.EBMS_0303;
                }
            }
            return AS4Error.EBMS_0003;
        }
        return AS4Error.EBMS_0003;
    }

    private InputStream createInputStream(String refMessageId, List<AS4ErrorObject> errors) {
        MessageInfo messageInfo = this.createMessageInfo(refMessageId);
        SignalMessage signalMessage = this.createSignalMessage(refMessageId, errors);
        signalMessage.setMessageInfo(messageInfo);
        AS4MessageHelper messageHelper = new AS4MessageHelper();
        messageHelper.addSignal(signalMessage);
        StringWriter byteWriter = new StringWriter();
        try {
            this.marshal(messageHelper.getEnvelope(), byteWriter);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        byte[] contentArray = byteWriter.toString().getBytes();
        ByteArrayInputStream result = new ByteArrayInputStream(contentArray);
        return result;
    }

    private void marshal(Envelope envelope, Writer byteWriter) throws JAXBException {
        Marshaller marshaller = this._as4JAXBContext.createMarshaller();
        marshaller.marshal((Object)envelope, byteWriter);
    }

    private MessageInfo createMessageInfo(String refMessageId) {
        MessageInfo result = this._as4ObjectFactory.createMessageInfo();
        result.setMessageId(this._idGenerator.generateMessageId());
        result.setTimestamp(this.referenceDateTask.getReferenceDate());
        if (StringUtils.isNotBlank((CharSequence)refMessageId)) {
            result.setRefToMessageId(refMessageId);
        }
        return result;
    }

    private SignalMessage createSignalMessage(String refMessageId, List<AS4ErrorObject> errors) {
        SignalMessage signalMessage = this._as4ObjectFactory.createSignalMessage();
        for (AS4ErrorObject as4ErrorObject : errors) {
            AS4Error as4Error = as4ErrorObject.getAs4Error();
            String description = as4ErrorObject.getDescription();
            Error error = this._as4ObjectFactory.createError();
            error.setCategory(as4Error.getCategory().name());
            error.setErrorCode(as4Error.getErrorCode());
            error.setOrigin(as4Error.getOrigin().name());
            if (StringUtils.isNotBlank((CharSequence)refMessageId)) {
                error.setRefToMessageInError(refMessageId);
            }
            error.setSeverity(as4Error.getSeverity().name());
            error.setShortDescription(as4Error.getShortDescription());
            if (StringUtils.isNotBlank((CharSequence)description)) {
                Description descr = this._as4ObjectFactory.createDescription();
                descr.setLang("en");
                descr.setValue(description);
                error.setDescription(descr);
            }
            signalMessage.getError().add(error);
        }
        return signalMessage;
    }

    class AS4ErrorObject {
        private final AS4Error _as4Error;
        private final String _description;

        public AS4ErrorObject(AS4ErrorProcessor this$0, AS4Error as4Error, String description) {
            this._as4Error = as4Error;
            this._description = description;
        }

        protected AS4Error getAs4Error() {
            return this._as4Error;
        }

        protected String getDescription() {
            return this._description;
        }
    }
}

