/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class CertificateModel
implements Comparable<CertificateModel> {
    private final SortedSet<String> keyUsages = new TreeSet<String>();
    private final SortedSet<String> extendedKeyUsages = new TreeSet<String>();
    private final String id;
    private final Date notAfter;

    public CertificateModel(String certificateId, Date notAfter) {
        this.id = certificateId;
        this.notAfter = notAfter;
    }

    public String getId() {
        return this.id;
    }

    public CertificateModel addKeyUsage(KeyUsage keyUsage) {
        this.keyUsages.add(keyUsage.getValue());
        return this;
    }

    public List<String> getKeyUsages() {
        return List.copyOf(this.keyUsages);
    }

    public CertificateModel addExtendedKeyUsage(ExtendedKeyUsage extendedkeyUsage) {
        this.extendedKeyUsages.add(extendedkeyUsage.getValue());
        return this;
    }

    public List<String> getExtendedKeyUsages() {
        return List.copyOf(this.extendedKeyUsages);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateModel)) {
            return false;
        }
        CertificateModel that = (CertificateModel)o;
        return Objects.equals(this.keyUsages, that.keyUsages) && Objects.equals(this.extendedKeyUsages, that.extendedKeyUsages) && Objects.equals(this.id, that.id) && Objects.equals(this.notAfter, that.notAfter);
    }

    public int hashCode() {
        return Objects.hash(this.keyUsages, this.extendedKeyUsages, this.id, this.notAfter);
    }

    @Override
    public int compareTo(CertificateModel other) {
        int compareToResult = this.notAfter.compareTo(other.notAfter);
        return compareToResult == 0 ? this.id.compareTo(other.id) : compareToResult;
    }

    public static enum KeyUsage {
        DIGITAL_SIGNATURE("digitalSignature"),
        NON_REPUDIATION("nonRepudiation"),
        KEY_ENCIPHERMENT("keyEncipherment"),
        DATA_ENCIPHERMENT("dataEncipherment"),
        KEY_AGREEMENT("keyAgreement"),
        KEY_CERT_SIGN("keyCertSign"),
        C_RL_SIGN("cRLSign"),
        ENCIPHER_ONLY("encipherOnly"),
        DECIPHER_ONLY("decipherOnly");

        final String value;

        private KeyUsage(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ExtendedKeyUsage {
        SERVER_AUTH("serverAuth"),
        CLIENT_AUTH("clientAuth"),
        CODE_SIGNING("codeSigning"),
        EMAIL_PROTECTION("emailProtection"),
        TIME_STAMPING("timeStamping"),
        OCSP_SIGNING("OCSPSigning"),
        IPSEC_IKE("ipsecIKE");

        final String value;

        private ExtendedKeyUsage(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

