/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cpa;

import de.ponton.xmlpipe.rest.cpa.AgreementTemplateListItemDto;
import de.pontonconsulting.xmlpipe.config.AgreementTemplateBundle;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.DistributionConfigFinder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgreementTemplates {
    private static final Log LOG = LogFactory.getLog((String)"Messenger.AgreementTemplates");
    private final DistributionConfigFinder distributionConfigFinder;
    private final ConfigResourceService configResourceService;

    public AgreementTemplates(DistributionConfigFinder distributionConfigFinder, ConfigResourceService configResourceService) {
        this.distributionConfigFinder = distributionConfigFinder;
        this.configResourceService = configResourceService;
    }

    public File loadAgreementTemplate(String agreementTemplateId, Boolean isPublic) throws FileNotFoundException {
        Path templatePath;
        try {
            templatePath = this.getTemplatePath(agreementTemplateId, isPublic);
        }
        catch (IOException | URISyntaxException e) {
            LOG.error((Object)("Error getting agreement template file path for: " + agreementTemplateId), (Throwable)e);
            return null;
        }
        File templateFile = templatePath.toFile();
        if (!templateFile.exists()) {
            throw new FileNotFoundException();
        }
        return templateFile;
    }

    public String getAgreementTemplateContent(String agreementTemplateId, Boolean isPublic) throws FileNotFoundException {
        File file = this.loadAgreementTemplate(agreementTemplateId, isPublic);
        try {
            return Files.readString(file.toPath());
        }
        catch (IOException e) {
            LOG.error((Object)("Error reading agreement template file: " + file.getAbsolutePath()), (Throwable)e);
            return "";
        }
    }

    public void createAgreementTemplate(URL publicFileUrl, URL privateFileUrl, String username) throws IOException {
        try {
            this.distributionConfigFinder.checkForAgreementTemplatesRefresh();
            String agreementTemplateId = AgreementTemplates.extractTemplateId(publicFileUrl);
            List<AgreementTemplateListItemDto> templateList = this.distributionConfigFinder.getAgreementTemplateList();
            for (AgreementTemplateListItemDto template : templateList) {
                if (!template.getAgreementTemplateId().equals(agreementTemplateId) || !template.getIsCustom().booleanValue()) continue;
                throw new IllegalArgumentException("A custom agreement template with the same ID already exists: " + agreementTemplateId);
            }
            Path folderPath = this.configResourceService.getAgreementTemplateFolder().toAbsolutePath();
            Path targetPublicFilePath = folderPath.resolve(agreementTemplateId + "_public.vm");
            Path targetPrivateFilePath = folderPath.resolve(agreementTemplateId + "_private.vm");
            AgreementTemplates.moveFiles(publicFileUrl, privateFileUrl, targetPublicFilePath, targetPrivateFilePath);
            this.configResourceService.storeAgreementTemplates(username);
        }
        catch (IOException e) {
            LOG.error((Object)"Error creating agreement template files", (Throwable)e);
            throw e;
        }
    }

    public void saveAgreementTemplate(String agreementTemplateId, Boolean isPublic, String content, String username) throws IOException {
        block14: {
            try {
                this.distributionConfigFinder.checkForAgreementTemplatesRefresh();
                Path templatePath = this.getTemplatePathSafely(agreementTemplateId, isPublic);
                if (templatePath == null) {
                    return;
                }
                AgreementTemplateListItemDto agreementTemplateDto = this.distributionConfigFinder.getAgreementTemplateListItem(agreementTemplateId, isPublic);
                if (agreementTemplateDto.getIsCustom().booleanValue()) {
                    this.saveContentToFile(templatePath, content, username);
                    break block14;
                }
                Path configFolderPath = this.configResourceService.getAgreementTemplateFolder().toAbsolutePath();
                Path customTemplatePath = configFolderPath.resolve(templatePath.getFileName());
                if (customTemplatePath.toString().endsWith(".tmp")) {
                    try (BufferedWriter writer = Files.newBufferedWriter(customTemplatePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                        writer.write(content);
                        ((Writer)writer).flush();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Error writing to temporary agreement template file: " + String.valueOf(customTemplatePath.toAbsolutePath())), (Throwable)e);
                        throw e;
                    }
                    Path renamedPath = configFolderPath.resolve(agreementTemplateId + "_" + (isPublic != false ? "public" : "private") + ".vm");
                    Files.move(customTemplatePath, renamedPath, StandardCopyOption.REPLACE_EXISTING);
                    this.configResourceService.storeAgreementTemplates(username);
                } else {
                    this.saveContentToFile(customTemplatePath, content, username);
                }
                this.distributionConfigFinder.addTemplateToList(agreementTemplateId, isPublic);
            }
            catch (IOException e) {
                LOG.error((Object)("Error saving agreement template file: " + agreementTemplateId), (Throwable)e);
                throw e;
            }
        }
    }

    public void deleteAgreementTemplate(String agreementTemplateId, Boolean isPublic, String username) throws IOException {
        try {
            this.distributionConfigFinder.checkForAgreementTemplatesRefresh();
            AgreementTemplateListItemDto agreementTemplateDto = this.distributionConfigFinder.getAgreementTemplateListItem(agreementTemplateId, isPublic);
            if (agreementTemplateDto != null) {
                if (!agreementTemplateDto.getIsCustom().booleanValue()) {
                    LOG.warn((Object)("Could not delete agreement template '" + agreementTemplateId + "' because it is a default template."));
                    return;
                }
                Path templatePath = this.getTemplatePathSafely(agreementTemplateId, isPublic);
                if (templatePath != null) {
                    Files.deleteIfExists(templatePath);
                    this.configResourceService.storeAgreementTemplates(username);
                } else {
                    LOG.info((Object)("Agreement template file not found: " + agreementTemplateId));
                }
                this.updateTemplateList(agreementTemplateId, isPublic, username);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error deleting agreement template: " + agreementTemplateId), (Throwable)e);
            throw e;
        }
    }

    private void updateTemplateList(String agreementTemplateId, Boolean isPublic, String username) {
        try {
            this.distributionConfigFinder.removeAgreementTemplateListItem(agreementTemplateId, isPublic);
            this.restoreDefaultTemplateIfNeeded(agreementTemplateId, isPublic, username);
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not retrieve agreement template URL from resources services", (Throwable)e);
        }
    }

    private void restoreDefaultTemplateIfNeeded(String agreementTemplateId, Boolean isPublic, String username) throws IOException {
        Map.Entry<URI, InputStream> templateUrlSafely = this.getTemplateUrlSafely(agreementTemplateId, isPublic);
        if (templateUrlSafely != null && (templateUrlSafely.getKey().toURL().getPath().contains("/classes/") || "jar".equalsIgnoreCase(templateUrlSafely.getKey().toURL().getProtocol()))) {
            FileTime lastModified = this.distributionConfigFinder.getFileLastModified(templateUrlSafely.getKey().toURL(), false);
            this.distributionConfigFinder.addDefaultTemplateToList(agreementTemplateId, isPublic, lastModified);
        } else {
            this.removeOtherPartOfTemplate(agreementTemplateId, isPublic, username);
        }
    }

    private void removeOtherPartOfTemplate(String agreementTemplateId, Boolean isPublic, String username) throws IOException {
        AgreementTemplateListItemDto oppositeTemplateDto = this.distributionConfigFinder.getAgreementTemplateListItem(agreementTemplateId, isPublic == false);
        if (oppositeTemplateDto != null) {
            Path oppositeTemplatePath = this.getTemplatePathSafely(agreementTemplateId, isPublic == false);
            if (oppositeTemplatePath != null) {
                Files.deleteIfExists(oppositeTemplatePath);
                this.configResourceService.storeAgreementTemplates(username);
            } else {
                LOG.info((Object)("Agreement template file not found: " + agreementTemplateId));
            }
            this.distributionConfigFinder.removeAgreementTemplateListItem(agreementTemplateId, isPublic == false);
            this.distributionConfigFinder.removeAgreementTemplateBundle(agreementTemplateId);
        }
    }

    private String getTemplateLocation(String agreementTemplateId, Boolean isPublic) {
        AgreementTemplateBundle bundle = this.distributionConfigFinder.getAgreementTemplateBundle(agreementTemplateId);
        return isPublic != false ? bundle.getAgreementTemplate() : bundle.getAgreementPrivateTemplate();
    }

    private Map.Entry<URI, InputStream> getTemplateUrlSafely(String agreementTemplateId, Boolean isPublic) {
        try {
            return this.configResourceService.getResource(this.getTemplateLocation(agreementTemplateId, isPublic));
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("Default template file not found for: " + agreementTemplateId + ". Removing Agreement template bundle."));
            return null;
        }
        catch (IOException e) {
            LOG.warn((Object)("Error getting agreement template URL for: " + agreementTemplateId), (Throwable)e);
            return null;
        }
    }

    private Path getTemplatePathSafely(String agreementTemplateId, Boolean isPublic) {
        try {
            return this.getTemplatePath(agreementTemplateId, isPublic);
        }
        catch (IOException | URISyntaxException e) {
            LOG.error((Object)("Error getting agreement template file path for: " + agreementTemplateId), (Throwable)e);
            return null;
        }
    }

    private Path getTemplatePath(String agreementTemplateId, Boolean isPublic) throws IOException, URISyntaxException {
        AgreementTemplateBundle bundle = this.distributionConfigFinder.getAgreementTemplateBundle(agreementTemplateId);
        String templateLocation = isPublic != false ? bundle.getAgreementTemplate() : bundle.getAgreementPrivateTemplate();
        Map.Entry<URI, InputStream> resourceAsStream = this.configResourceService.getResource(templateLocation);
        if ("jar".equalsIgnoreCase(resourceAsStream.getKey().toURL().getProtocol())) {
            Path tempFile = Files.createTempFile(String.valueOf(Paths.get(templateLocation, new String[0]).getFileName()), ".tmp", new FileAttribute[0]);
            return AgreementTemplates.extractFileFromJar(resourceAsStream.getKey().toURL(), tempFile);
        }
        return Paths.get(resourceAsStream.getKey());
    }

    private static Path extractFileFromJar(URL jarUrl, Path tempFile) {
        try {
            String[] parts = jarUrl.getPath().split("!");
            URI jarFileUri = URI.create("jar:" + parts[0] + "/");
            FileSystem fs = FileSystems.getFileSystem(jarFileUri);
            Path filePath = fs.getPath(parts[1], new String[0]);
            Files.copy(filePath, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.error((Object)("Error extracting agreement template file from JAR: " + String.valueOf(jarUrl)), (Throwable)e);
        }
        return tempFile;
    }

    private static String extractTemplateId(URL publicFileUrl) {
        String fileName;
        String[] parts = publicFileUrl.getFile().split("/");
        if (parts.length > 0 && (fileName = parts[parts.length - 1]).endsWith("_public.vm")) {
            return fileName.substring(0, fileName.length() - "_public.vm".length());
        }
        throw new IllegalArgumentException("Invalid file URL: " + String.valueOf(publicFileUrl));
    }

    private static void moveFiles(URL publicFileUrl, URL privateFileUrl, Path targetPublicFilePath, Path targetPrivateFilePath) throws IOException {
        try {
            Path tempPublicFilePath = Paths.get(publicFileUrl.toURI());
            Path tempPrivateFilePath = Paths.get(privateFileUrl.toURI());
            Files.move(tempPublicFilePath, targetPublicFilePath, StandardCopyOption.REPLACE_EXISTING);
            Files.move(tempPrivateFilePath, targetPrivateFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)"Error getting agreement template file paths", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void saveContentToFile(Path filePath, String content, String username) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(content);
            ((Writer)writer).flush();
            this.configResourceService.storeAgreementTemplates(username);
        }
        catch (IOException e) {
            LOG.error((Object)("Error saving agreement template file: " + String.valueOf(filePath.toAbsolutePath())), (Throwable)e);
            throw e;
        }
    }
}

