/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Option
implements Cloneable {
    public static final String SEPARATOR = "/";
    public static final String FIRST_OPTION_NAME = "id";
    public static final String TYPE_LIST = "list";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BOOL = "boolean";
    public static final String NAME_NEXT_DEFAULT_CERT_REF_ID = "nextDefaultCertificateRefId";
    public static final String NAME_CERT_REF_ID = "certificateRefId";
    public static final String VALUE_DEFAULT = "default";
    public static final String NAME_CERT_ALIAS = "certificateAlias";
    public static final String TYPE_BASE64 = "base64";
    public static final String NAME_CERT = "certificate";
    public static final String NAME_PROCESSING = "processing";
    public static final String VALUE_EXCEPTION = "exception";
    public static final String TYPE_OPTION_GROUP = "optionGroup";
    public static final String NAME_SCHEMALOCATION = "schemaLocation";
    public static final String LIST_SEPARATOR = ",";
    private Option[] subOptions;
    private String name;
    private String value;
    private String type;
    private String path;

    public Option(String name, String value, String type) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.path = FIRST_OPTION_NAME.equals(this.name) ? "" : SEPARATOR + this.name;
        this.subOptions = new Option[0];
    }

    public Option clone() {
        Option newOption = new Option(this.getName(), this.getValue(), this.getType());
        Option[] subOptions = this.getSubOptions();
        for (int i = 0; i < subOptions.length; ++i) {
            Option newSubOption = subOptions[i].clone();
            newOption.addSubOption(newSubOption);
        }
        return newOption;
    }

    public static Option[] clone(Option[] options) {
        Option[] newOptions = new Option[options.length];
        for (int i = 0; i < options.length; ++i) {
            newOptions[i] = options[i].clone();
        }
        return newOptions;
    }

    public void setSubOptions(Option[] options) {
        this.subOptions = options;
        Option tempOption = null;
        for (int i = 0; i < options.length; ++i) {
            tempOption = options[i];
            tempOption.setPath(this.getPath() + SEPARATOR + tempOption.getName());
        }
    }

    public Option[] getSubOptions() {
        return this.subOptions;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        for (int i = 0; i < this.subOptions.length; ++i) {
            Option subOption = this.subOptions[i];
            String subOptionPath = subOption.getPath();
            subOption.setPath(path + subOptionPath.replaceAll(subOption.getParentPath(), ""));
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Option)) {
            return false;
        }
        Option option = (Option)obj;
        if (!(this.getName().equals(option.getName()) && this.getType().equals(option.getType()) && this.getValue().equals(option.getValue()))) {
            return false;
        }
        Option[] selfSubOptions = this.getSubOptions();
        Option[] optionSubOptions = option.getSubOptions();
        Comparator<Option> comparator = new Comparator<Option>(this){

            @Override
            public int compare(Option o1, Option o2) {
                return o1.getName().compareTo(o1.getName());
            }
        };
        Arrays.sort(selfSubOptions, comparator);
        Arrays.sort(optionSubOptions, comparator);
        boolean compareSubOptions = false;
        if (selfSubOptions != null && optionSubOptions != null) {
            if (selfSubOptions.length != optionSubOptions.length) {
                compareSubOptions = false;
            } else {
                compareSubOptions = true;
                Option tempOption = null;
                Option tempOption_2 = null;
                boolean tempCompare = false;
                for (int i = 0; i < selfSubOptions.length; ++i) {
                    tempOption = selfSubOptions[i];
                    tempOption_2 = optionSubOptions[i];
                    tempCompare = tempOption.equals(tempOption_2);
                    if (tempCompare) continue;
                    compareSubOptions = false;
                    break;
                }
            }
        } else {
            compareSubOptions = selfSubOptions == null && optionSubOptions == null;
        }
        return this.type.equals(option.getType()) && this.value.equals(option.getValue()) && this.name.equals(this.getName()) && compareSubOptions;
    }

    public String toString() {
        return "NAME: " + this.getName() + ", VALUE: " + this.getValue() + ", TYPE: " + this.getType() + ", PATH: " + this.getPath() + "; ";
    }

    public String getParentPath() {
        return Option.getParentPath(this.path);
    }

    public static String getParentPath(String path) {
        StringBuilder parentPath = new StringBuilder();
        String[] optionNames = path.split(SEPARATOR);
        for (int i = 0; i < optionNames.length - 2; ++i) {
            parentPath.append(SEPARATOR + optionNames[i + 1]);
        }
        return parentPath.toString();
    }

    public void addSubOption(Option option) {
        ArrayList<Option> newSubOptions = new ArrayList<Option>(Arrays.asList(this.getSubOptions()));
        for (Option oldOption : newSubOptions) {
            oldOption.setPath(this.getPath().replace(oldOption.getParentPath(), ""));
        }
        newSubOptions.add(option);
        this.setSubOptions(newSubOptions.toArray(new Option[newSubOptions.size()]));
    }

    public void deleteSubOption(String optionType, String optionName) {
        ArrayList<Option> newSubOptions = new ArrayList<Option>(Arrays.asList(this.getSubOptions()));
        Option optionToDelete = null;
        for (Option option : newSubOptions) {
            if (!option.getType().equals(optionType) || !option.getName().equals(optionName)) continue;
            optionToDelete = option;
            break;
        }
        this.deleteSubOption(optionToDelete);
    }

    public void deleteSubOption(Option optionToDelete) {
        ArrayList<Option> newSubOptions = new ArrayList<Option>(Arrays.asList(this.getSubOptions()));
        newSubOptions.remove(optionToDelete);
        this.setSubOptions(newSubOptions.toArray(new Option[newSubOptions.size()]));
    }

    public List<Option> getSuccessorOptions(String optionType, String optionName, String optionValue) {
        ArrayList<Option> options = new ArrayList<Option>();
        if (optionType == null && optionName == null && optionValue == null) {
            return options;
        }
        Option[] subOptions = this.getSubOptions();
        boolean typeOK = false;
        boolean nameOK = false;
        boolean valueOK = false;
        for (int i = 0; i < subOptions.length; ++i) {
            Option subOption = subOptions[i];
            typeOK = optionType == null ? true : (subOption.getType() == null ? true : subOption.getType().equals(optionType));
            nameOK = optionName == null ? true : (subOption.getName() == null ? true : subOption.getName().equals(optionName));
            valueOK = optionValue == null ? true : (subOption.getValue() == null ? true : subOption.getValue().equals(optionValue));
            if (typeOK && nameOK && valueOK) {
                options.add(subOption);
                continue;
            }
            options.addAll(subOption.getSuccessorOptions(optionType, optionName, optionValue));
        }
        return options;
    }

    public List<Option> getSuccessorOptions(String optionType, String optionName) {
        return this.getSuccessorOptions(optionType, optionName, null);
    }

    public List<Option> getSubOptions(String optionType, String optionName) {
        return this.getSubOptions(optionType, optionName, null);
    }

    public List<Option> getSubOptions(String optionType, String optionName, String optionValue) {
        ArrayList<Option> options = new ArrayList<Option>();
        if (optionType == null && optionName == null && optionValue == null) {
            return options;
        }
        Option[] subOptions = this.getSubOptions();
        boolean typeOK = false;
        boolean nameOK = false;
        boolean valueOK = false;
        for (int i = 0; i < subOptions.length; ++i) {
            Option subOption = subOptions[i];
            typeOK = optionType == null ? true : subOption.getType().equals(optionType);
            nameOK = optionName == null ? true : subOption.getName().equals(optionName);
            valueOK = optionValue == null ? true : subOption.getValue().equals(optionValue);
            if (!typeOK || !nameOK || !valueOK) continue;
            options.add(subOption);
        }
        return options;
    }
}

