/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config.listener;

import de.ponton.securelistener.ftp.FtpExchangeUserProperties;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerCommand;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.config.listener.ListenerResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.util.encoders.Base64;

public class LoadFtpExchangeUserConfiguration
extends ListenerCommand {
    public LoadFtpExchangeUserConfiguration(ListenerConfig listenerConfig) {
        super(listenerConfig);
        this._command = "getFtpUsersConfig";
    }

    @Override
    public void handleResponse(ListenerResponse response) throws ListenerConfigException {
        try {
            byte[] cfg = response.getContent();
            if (cfg.length > 0) {
                cfg = Base64.decode((byte[])cfg);
                MessageDigest md5 = MessageDigest.getInstance("MD5", "BC");
                md5.update(cfg);
                String digestLocal = new String(Base64.encode((byte[])md5.digest()));
                String digestRemote = response.getHeaders().get("X-Ponton-SecureListener-FtpUsersCfgDigest");
                if (!digestLocal.equals(digestRemote)) {
                    _log.fatal((Object)"Unable to load the ftp users configuration from the listener. Digest mismatch.");
                    throw new ListenerConfigException(47002, "Unable to load the ftp users configuration from the listener. Digest mismatch.");
                }
                FtpExchangeUserProperties pum = new FtpExchangeUserProperties((InputStream)new ByteArrayInputStream(cfg));
                this.listenerConfig.setFtpExchangeUserProperties(pum);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }
}

