/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config.listener;

import de.ponton.securelistener.config.ListenerProperties;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ListenerCommand;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.config.listener.ListenerResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.util.encoders.Base64;

public class LoadConfiguration
extends ListenerCommand {
    public LoadConfiguration(ListenerConfig listenerConfig) {
        super(listenerConfig);
        this._command = "getConfig";
    }

    @Override
    public void handleResponse(ListenerResponse response) throws ListenerConfigException {
        try {
            byte[] cfg = Base64.decode((byte[])response.getContent());
            MessageDigest md5 = MessageDigest.getInstance("MD5", "BC");
            md5.update(cfg);
            String digestLocal = new String(Base64.encode((byte[])md5.digest()));
            String digestRemote = response.getHeaders().get("X-Ponton-SecureListener-CfgDigest");
            if (!digestLocal.equals(digestRemote)) {
                _log.fatal((Object)"Unable to load the configuration from the listener. Digest mismatch.");
                throw new ListenerConfigException(47002, "Unable to load the configuration from the listener. Digest mismatch.");
            }
            this.listenerConfig.setProperties(new ListenerProperties(cfg));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }
}

