/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.DatabaseType;

public enum SupportedDatabase {
    MSSQL_SERVER_2019(DatabaseType.MSSQL, 15, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    MSSQL_SERVER_2022(DatabaseType.MSSQL, 16, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    AZURE_SQL_1(DatabaseType.MSSQL, 15, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    AZURE_SQL_2(DatabaseType.MSSQL, 16, 0, "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false"),
    ORACLE_19C(DatabaseType.ORACLE, 19, null, "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>"),
    ORACLE_21C(DatabaseType.ORACLE, 21, null, "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>"),
    ORACLE_23AI(DatabaseType.ORACLE, 23, null, "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>"),
    MYSQL_80(DatabaseType.MYSQL, 8, 0, "jdbc:mysql://<hostname>:<port>/<database>?useSSL=true"),
    MYSQL_84(DatabaseType.MYSQL, 8, 4, "jdbc:mysql://<hostname>:<port>/<database>?useSSL=true"),
    POSTGRES_14(DatabaseType.POSTGRESQL, 14, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true"),
    POSTGRES_15(DatabaseType.POSTGRESQL, 15, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true"),
    POSTGRES_16(DatabaseType.POSTGRESQL, 16, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true"),
    POSTGRES_17(DatabaseType.POSTGRESQL, 17, null, "jdbc:postgresql://<hostname>/<databasename>?ssl=true");

    private final DatabaseType databaseType;
    private final Integer majorVersion;
    private final Integer minorVersion;
    private final String urlSample;

    private SupportedDatabase(DatabaseType databaseType, Integer major, Integer minor, String urlSample) {
        this.databaseType = databaseType;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.urlSample = urlSample;
    }

    public static SupportedDatabase valueOf(DatabaseType databaseType, int databaseMajorVersion, int databaseMinorVersion) {
        for (SupportedDatabase db : SupportedDatabase.values()) {
            if (!db.databaseType.equals((Object)databaseType) || db.majorVersion != databaseMajorVersion || db.minorVersion != null && db.minorVersion != databaseMinorVersion) continue;
            return db;
        }
        throw new IllegalArgumentException("database not supported");
    }

    public String getUrlSample() {
        return this.urlSample;
    }

    private static class Constants {
        public static final String JDBC_URL_POSTGRES = "jdbc:postgresql://<hostname>/<databasename>?ssl=true";
        public static final String JDBC_URL_MSSQL = "jdbc:sqlserver://<hostname>:<port>;databaseName=<db>;encrypt=true;trustServerCertificate=true;sendStringParametersAsUnicode=false";
        public static final String JDBC_URL_ORACLE = "jdbc:oracle:thin:@tcps://<hostname>:<port>/<service>";
        public static final String JDBC_URL_MYSQL = "jdbc:mysql://<hostname>:<port>/<database>?useSSL=true";

        private Constants() {
        }
    }
}

