/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.ponton.xmlpipe.websocket.WebsocketClient;
import de.pontonconsulting.common.file.DBConfigChangeWatcher;
import de.pontonconsulting.xmlpipe.config.EMailSendSetting;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.NotificationReceiver;
import de.pontonconsulting.xmlpipe.config.NtpServer;
import de.pontonconsulting.xmlpipe.config.ServerSettings;
import de.pontonconsulting.xmlpipe.config.SubjectElement;
import de.pontonconsulting.xmlpipe.config.SystemEvent;
import de.pontonconsulting.xmlpipe.config.SystemEventReceiver;
import de.pontonconsulting.xmlpipe.config.messenger.Messenger;
import de.pontonconsulting.xmlpipe.config.model.common.authentication.XpAuthenticationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.XpMessengerConfigurationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.adapterapi.XpAdapterApiDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpArchiveDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpArchiverType;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpCleanupDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.archive.XpMessagePart;
import de.pontonconsulting.xmlpipe.config.model.messenger.authtoken.XpAuthenticationTokenDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpCommunicationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpFtpProxyConfigDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpHttpProxyConfigDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.communication.XpLdapProxyConfigDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.database.XpDatabaseDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.display.XpDisplayDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailInboundProtocol;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailOutboundProtocol;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.XpEmailNotificationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.IXpSubjectElement;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpSubjectElementTextDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpSubjectElementVariableDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpSubjectElementXPathDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.system.XpSystemEventReceiverDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.listener.XpListenerConnectionDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.logging.XpLoggingDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.maintenance.XpMaintenanceDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.maintenance.XpMaintenancePeriodDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.messagequeue.XpMessageQueueDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.partnerregistry.XpPartnerRegistryDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpConnectorDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpServerDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpServerProtocol;
import de.pontonconsulting.xmlpipe.config.model.messenger.server.XpService;
import de.pontonconsulting.xmlpipe.config.model.messenger.timeserver.XpTimeServerDto;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceService;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.security.ldap.LdapConnectionPool;
import de.pontonconsulting.xmlpipe.server.ILoggingSystem;
import de.pontonconsulting.xmlpipe.util.ThrowingSupplier;
import jakarta.xml.bind.JAXBException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class MessengerConfigUpdateManager {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessengerConfigUpdateManager.class.getName()));
    private final MessengerConfig messengerConfig;
    private final IServerConfigBean serverConfig;
    private final ReferenceDateTask referenceDateTask;
    private final ILoggingSystem loggingSystem;
    private final MaintenanceManager maintenanceManager;
    private final MessengerLog messengerLog;
    private final WebsocketClient listenerConnector;
    private final LdapConnectionPool ldapConnectionPool;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final DBConfigChangeWatcher messengerConfigChangeWatcher;
    private final AtomicInteger lastListenerListHashCode = new AtomicInteger(-1);
    private final AtomicInteger ntpServerListHashCode = new AtomicInteger(-1);
    private final AtomicInteger maintenanceServiceListHashCode = new AtomicInteger(-1);

    public MessengerConfigUpdateManager(MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask, IServerConfigBean serverConfigBean, ILoggingSystem loggingSystem, MaintenanceManager maintenanceManager, MessengerLog messengerLog, WebsocketClient listenerConnector, LdapConnectionPool ldapConnectionPool, DBConfigChangeWatcher messengerConfigChangeWatcher, ApplicationEventPublisher applicationEventPublisher) {
        this.messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
        this.serverConfig = serverConfigBean;
        this.loggingSystem = loggingSystem;
        this.maintenanceManager = maintenanceManager;
        this.messengerLog = messengerLog;
        this.listenerConnector = listenerConnector;
        this.ldapConnectionPool = ldapConnectionPool;
        this.applicationEventPublisher = applicationEventPublisher;
        this.messengerConfigChangeWatcher = messengerConfigChangeWatcher;
        messengerConfigChangeWatcher.addFileChangeListener(this::triggerOnConfigChangeActions);
    }

    public void updateConfiguration(XpMessengerConfigurationDto configurationDto) throws JAXBException {
        this.updateArchiveConfiguration(configurationDto.getArchive());
        this.updateCommunicationConfiguration(configurationDto.getCommunication());
        this.updateDatabaseConfiguration(configurationDto.getDatabase());
        this.updateEmailConfiguration(configurationDto.getEmail());
        this.updateLoggingConfiguration(configurationDto.getLogging());
        this.updateMaintenanceConfiguration(configurationDto.getMaintenance());
        this.updateEmailNotificationConfiguration(configurationDto.getEmailNotification());
        this.updateMessageQueueConfiguration(configurationDto.getMessageQueue());
        this.updateServerConfiguration(configurationDto.getServer());
        this.updateTimeServerConfiguration(configurationDto.getTimeServer());
        this.updatePartnerRegistryConfiguration(configurationDto.getPartnerRegistry());
        this.updateListenerConnectionConfiguration(configurationDto.getListenerConnection());
        this.updateAdapterApiConfiguration(configurationDto.getAdapterApi());
        this.updateAuthenticationTokenConfiguration(configurationDto.getAuthenticationToken());
        this.updateDisplayConfiguration(configurationDto.getDisplay());
    }

    private void updateAuthenticationTokenConfiguration(XpAuthenticationTokenDto authenticationTokenDto) {
        if (authenticationTokenDto != null) {
            this.messengerConfig.setRandomSecret(authenticationTokenDto.isRandomSecretAtRestart());
            this.messengerConfig.setJwtExpiration(authenticationTokenDto.getExpiration());
            this.messengerConfig.setJwtIgnoreIpAddress(authenticationTokenDto.isIgnoreIpAddress());
        }
    }

    private void updateDisplayConfiguration(XpDisplayDto displayDto) {
        if (displayDto != null && !this.maintenanceManager.isConfigError()) {
            this.messengerConfig.setMessengerName(displayDto.getMessengerName());
            this.messengerConfig.setColorAdjustment(displayDto.getColorAdjustment());
            this.messengerConfig.setEnvironment(displayDto.getEnvironment());
        }
    }

    private void updateListenerConnectionConfiguration(List<XpListenerConnectionDto> listenerConnection) {
        List<Messenger.XpListener> list = listenerConnection.stream().map(e -> {
            Messenger.XpListener xpListener = new Messenger.XpListener();
            xpListener.setPort(e.getPort());
            xpListener.setSsl(Boolean.valueOf(e.isUseSsl()));
            xpListener.setEnabled(Boolean.valueOf(e.isEnabled()));
            xpListener.setDataConnectionCount(e.getNumberOfDataConnections());
            xpListener.setHost(e.getHost());
            return xpListener;
        }).toList();
        this.messengerConfig.setXpListeners(list);
    }

    private void updateAdapterApiConfiguration(XpAdapterApiDto adapterApiDto) {
        this.setAdapterApiEnabled(adapterApiDto.isAdapterApiEnabled());
        this.setAdapterApiAddress(adapterApiDto.getAdapterApiAddress());
        this.setAdapterApiPort(adapterApiDto.getAdapterApiPort());
        this.setAdapterApiTimeout(adapterApiDto.getAdapterApiTimeout());
    }

    void setAdapterApiEnabled(boolean enabled) {
        boolean currentValue = ThrowingSupplier.unchecked(this.serverConfig::isAdapterInterfaceEnabled).get();
        if (enabled != currentValue) {
            this.serverConfig.setAdapterInterfaceEnabled(enabled);
        }
    }

    public void setAdapterApiAddress(String address) {
        String currentValue = ThrowingSupplier.unchecked(this.serverConfig::getAdapterInterfaceAddress).get();
        if (!address.equals(currentValue)) {
            this.serverConfig.setAdapterInterfaceAddress(address);
        }
    }

    public void setAdapterApiPort(int port) {
        int currentValue = ThrowingSupplier.unchecked(this.serverConfig::getAdapterInterfacePort).get();
        if (port != currentValue) {
            this.serverConfig.setAdapterInterfacePort(port);
        }
    }

    public void setAdapterApiTimeout(int timeout) {
        int currentValue = ThrowingSupplier.unchecked(this.serverConfig::getAdapterInterfaceTimeout).get();
        if (timeout != currentValue) {
            this.serverConfig.setAdapterInterfaceTimeout(timeout);
        }
    }

    private void updatePartnerRegistryConfiguration(XpPartnerRegistryDto valueObject) {
        try {
            boolean registryUrlUnchanged;
            boolean enableRegistryDownload = valueObject.getPartnerRegistryUpdate() != null;
            this.messengerConfig.setRegistryDownloadEnabled(enableRegistryDownload);
            if (enableRegistryDownload) {
                this.messengerConfig.setAutomaticAgreementUpdateEnabled(valueObject.getPartnerRegistryUpdate().isAutomaticAgreementUpdates());
                this.messengerConfig.setRegistryCleanUpEnabled(valueObject.getPartnerRegistryUpdate().isAutomaticPartnerCleanup());
                this.messengerConfig.setRegistryPartnerCreationEnabled(valueObject.getPartnerRegistryUpdate().isAutomaticPartnerCreation());
                this.messengerConfig.setRegistryDownloadInterval(valueObject.getPartnerRegistryUpdate().getDownloadInterval());
                if (valueObject.getPartnerRegistryUpdate().getAuthentication() != null) {
                    this.messengerConfig.setRegistryUsername(valueObject.getPartnerRegistryUpdate().getAuthentication().getUsername());
                    String password = valueObject.getPartnerRegistryUpdate().getAuthentication().getPassword();
                    if (!"***".equals(password) || this.messengerConfig.getRegistryPassword() == null || this.messengerConfig.getRegistryPassword().isBlank()) {
                        this.messengerConfig.setRegistryPassword(password);
                    }
                } else {
                    this.messengerConfig.setRegistryUsername("");
                    this.messengerConfig.setRegistryPassword("");
                }
            }
            boolean bl = registryUrlUnchanged = valueObject.getRegistryUrl() == null && !this.messengerConfig.isRegistryConfigured() || valueObject.getRegistryUrl() != null && this.messengerConfig.getRegistryURL() != null && valueObject.getRegistryUrl().toString().equals(this.messengerConfig.getRegistryURL());
            if (!registryUrlUnchanged) {
                this.messengerConfig.setRegistryURL(valueObject.getRegistryUrl() != null ? valueObject.getRegistryUrl().toString() : null);
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateTimeServerConfiguration(XpTimeServerDto timeServerDto) {
        this.setNtpEnabled(timeServerDto.isEnabled());
        this.setNtpServerSynchronizeIntervalHours(timeServerDto.getSyncInterval());
        List<String> ntpServers = timeServerDto.getNtpServers();
        List<NtpServer> newServerList = ntpServers.stream().map(NtpServer::new).collect(Collectors.toList());
        this.setNtpServers(newServerList);
    }

    private void updateServerConfiguration(XpServerDto serverDto) {
        List<XpConnectorDto> connectorDtos = serverDto.getConnectors();
        ArrayList<ServerSettings> serverSettings = new ArrayList<ServerSettings>(connectorDtos.size());
        for (XpConnectorDto connector : connectorDtos) {
            ServerSettings settings = new ServerSettings();
            settings.setId(String.valueOf(connectorDtos.indexOf(connector) + 1));
            settings.setAddress("*");
            settings.setPort(connector.getPort());
            settings.setMinThreads(3);
            settings.setMaxThreads(30);
            settings.setLowResources(20);
            settings.setLowResourcePersistTimeMs(60000);
            settings.setMaxIdleTimeMs(60000);
            for (XpService service : connector.getServices()) {
                settings.addService(service.name());
            }
            String sslPassword = this.getSslKeyPassword();
            String sslKeystore = this.getSslKeyStore();
            if (XpServerProtocol.HTTPS == connector.getProtocol()) {
                settings.setSsl(true);
                settings.setNeedClientCert(false);
                settings.setWantClientCert(false);
                settings.setSslKeystore(sslKeystore);
                settings.setTrustKeystore(sslKeystore);
                settings.setTrustPassword(sslPassword);
                settings.setSslPassword(sslPassword);
                settings.setSslKeyPassword(sslPassword);
            } else {
                settings.setSsl(false);
            }
            serverSettings.add(settings);
        }
        this.serverConfig.setConnectors(serverSettings);
    }

    private String getSslKeyPassword() {
        Optional<ServerSettings> s = this.serverConfig.getConnectors().values().stream().filter(ServerSettings::isSsl).findFirst();
        if (s.isPresent()) {
            return s.get().getSslKeyPassword();
        }
        return "changeit";
    }

    private String getSslKeyStore() {
        Optional<ServerSettings> s = this.serverConfig.getConnectors().values().stream().filter(ServerSettings::isSsl).findFirst();
        if (s.isPresent()) {
            return s.get().getSslKeystore();
        }
        return "$XP_CONFIG_FOLDER/keystore-ssl";
    }

    private void updateMessageQueueConfiguration(XpMessageQueueDto valueObject) {
        this.messengerConfig.setInboundQueueDeliveryTimeout((long)valueObject.getInboundQueueDeliveryTimeout().intValue() * 1000L);
        this.messengerConfig.setInboundQueueRetryDelay((long)valueObject.getInboundQueueRetryDelay().intValue() * 1000L);
        this.messengerConfig.setInboundQueueScanTime(valueObject.getInboundQueueScanInterval().intValue());
        this.messengerConfig.setOutboundQueueScanTime(valueObject.getOutboundQueueScanInterval().intValue());
    }

    private void updateEmailNotificationConfiguration(XpEmailNotificationDto emailNotificationDto) {
        List<EMailSendSetting> emailSettings = emailNotificationDto.getCronExpressions().stream().map(cron -> new EMailSendSetting(cron.getCronExpression(), cron.getMaxNotificationPerMail())).collect(Collectors.toList());
        this.messengerConfig.setEMailSendSettings(emailSettings);
        List<XpSystemEventReceiverDto> systemEventReceiverDtos = emailNotificationDto.getSystemEventReceivers();
        ArrayList<SystemEventReceiver> systemEventReceivers = new ArrayList<SystemEventReceiver>();
        for (XpSystemEventReceiverDto systemEventReceiver : systemEventReceiverDtos) {
            List<SystemEvent> events = systemEventReceiver.getMessageEventIds().stream().map(SystemEvent::getSystemEvent).collect(Collectors.toList());
            systemEventReceivers.add(new SystemEventReceiver(systemEventReceiver.getEmail(), systemEventReceiver.getSubject(), events));
        }
        this.messengerConfig.setSystemEventReceivers(systemEventReceivers);
        try {
            this.messengerConfig.getNotificationReceivers().stream().map(NotificationReceiver::getEmail).forEach(this.messengerConfig::removeNotificationReceiver);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        emailNotificationDto.getMessageEventReceivers().forEach(email -> {
            List<SubjectElement> subjects = email.getSubjectElements().stream().map(this::mapToSubjectElement).collect(Collectors.toList());
            NotificationReceiver oldReceiver = this.messengerConfig.getNotificationReceiverForEmail(email.getEmail());
            if (oldReceiver == null || oldReceiver.getSubjectElements().size() != subjects.size() || !oldReceiver.getSubjectElements().containsAll(subjects)) {
                // empty if block
            }
            this.messengerConfig.setNotificationCodesForReceiver(email.getEmail(), email.getMessageEventIds(), email.isWithHtmlAttachment(), subjects);
        });
    }

    private SubjectElement mapToSubjectElement(IXpSubjectElement element) {
        if (element instanceof XpSubjectElementTextDto) {
            return new SubjectElement(3, ((XpSubjectElementTextDto)element).getValue());
        }
        if (element instanceof XpSubjectElementVariableDto) {
            return new SubjectElement(1, ((XpSubjectElementVariableDto)element).getValue().getXmlName());
        }
        if (element instanceof XpSubjectElementXPathDto) {
            return new SubjectElement(2, ((XpSubjectElementXPathDto)element).getValue());
        }
        throw new IllegalArgumentException(element.getClass().getName());
    }

    private void updateMaintenanceConfiguration(XpMaintenanceDto maintenanceDto) {
        ArrayList<MaintenanceService> maintenanceServices = new ArrayList<MaintenanceService>();
        for (XpMaintenancePeriodDto maintenancePeriodDto : maintenanceDto.getMaintenancePeriod()) {
            long start = maintenancePeriodDto.getStartDate().toInstant().getEpochSecond() * 1000L;
            long end = maintenancePeriodDto.getEndDate().toInstant().getEpochSecond() * 1000L;
            MaintenanceService maintenanceService = new MaintenanceService(start, end, maintenancePeriodDto.isStopDeliveryToAdapters(), maintenancePeriodDto.isStopDeliveryToPartners(), maintenancePeriodDto.isRejectIncomingMessages(), maintenancePeriodDto.isRejectOutgoingMessages());
            maintenanceServices.add(maintenanceService);
        }
        this.setMaintenanceServices(maintenanceServices);
    }

    private void updateLoggingConfiguration(XpLoggingDto valueObject) {
        this.setJDBCLogLevel(valueObject.getJdbcLogLevel().toString());
        this.setMessengerLogLevel(valueObject.getMessengerLogLevel().toString());
        this.messengerConfig.setDetailLogOnlyErrors(valueObject.isLogOnlyErrorsInDb());
        this.messengerConfig.setOkEventAge(valueObject.getOkEventAge());
    }

    private void updateEmailConfiguration(XpEmailDto valueObject) throws JAXBException {
        if (valueObject.getInbound() != null) {
            XpAuthenticationDto authenticationDto = valueObject.getInbound().getAuthentication();
            if (authenticationDto != null) {
                this.messengerConfig.setMailServerUser(authenticationDto.getUsername());
                if (!"***".equals(authenticationDto.getPassword()) || this.messengerConfig.getMailServerPassword() == null) {
                    this.messengerConfig.setMailServerPassword(authenticationDto.getPassword());
                }
            } else {
                this.messengerConfig.removeMailAuthentication();
            }
            this.messengerConfig.setMailServerHost(valueObject.getInbound().getHost().toString());
            this.messengerConfig.setMailPollInterval(valueObject.getInbound().getInterval());
            this.messengerConfig.setMailServerProtocol(valueObject.getInbound().getProtocol().getXmlName());
            this.messengerConfig.setMailInboxFolder(valueObject.getInbound().getInboxFolderName());
        } else {
            this.messengerConfig.setMailServerUser("");
            this.messengerConfig.setMailServerPassword("");
            this.messengerConfig.setMailServerHost("");
            this.messengerConfig.setMailPollInterval(0);
            this.messengerConfig.setMailServerProtocol(XpEmailInboundProtocol.IMAPS.getXmlName());
            this.messengerConfig.setMailInboxFolder("INBOX");
        }
        if (valueObject.getOutbound() != null) {
            this.messengerConfig.setSmtpServerHost(valueObject.getOutbound().getHost().toString());
            this.messengerConfig.setSmtpServerProtocol(valueObject.getOutbound().getProtocol().getXmlName());
            this.messengerConfig.setSmtpFromAddress(valueObject.getOutbound().getFrom());
            if (valueObject.getOutbound().getAuthentication() != null) {
                this.messengerConfig.setSmtpUser(valueObject.getOutbound().getAuthentication().getUsername());
                String password = valueObject.getOutbound().getAuthentication().getPassword();
                if (!"***".equals(password) || this.messengerConfig.getSmtpPassword() == null) {
                    this.messengerConfig.setSmtpPassword(password);
                }
            } else {
                this.messengerConfig.removeSmtpAuthentication();
            }
        } else {
            this.messengerConfig.setSmtpServerHost("");
            this.messengerConfig.setSmtpServerProtocol(XpEmailOutboundProtocol.SMTPS.getXmlName());
            this.messengerConfig.setSmtpFromAddress("");
            this.messengerConfig.removeSmtpAuthentication();
        }
    }

    private void updateDatabaseConfiguration(XpDatabaseDto valueObject) {
        this.setDatabaseCleanup(valueObject.getDatabaseCleanup());
    }

    private void updateCommunicationConfiguration(XpCommunicationDto communicationDto) throws JAXBException {
        XpLdapProxyConfigDto ldapProxyConfigDto = communicationDto.getLdapProxyConfig();
        if (ldapProxyConfigDto != null) {
            this.messengerConfig.setLdapProxyHost(ldapProxyConfigDto.getHost());
            this.messengerConfig.setLdapProxyPort(ldapProxyConfigDto.getPort());
        } else {
            this.messengerConfig.removeLdapProxyConfig();
        }
        this.ldapConnectionPool.resetConnections();
        XpFtpProxyConfigDto ftpProxyConfigDto = communicationDto.getFtpProxyConfig();
        if (ftpProxyConfigDto != null) {
            this.messengerConfig.setFtpProxyHost(ftpProxyConfigDto.getHost());
            this.messengerConfig.setFtpProxyPort(ftpProxyConfigDto.getPort());
            XpAuthenticationDto authenticationDto = ftpProxyConfigDto.getAuthentication();
            if (authenticationDto != null) {
                if (!"***".equals(authenticationDto.getPassword()) || this.messengerConfig.getFtpProxyPassword() == null) {
                    this.messengerConfig.setFtpProxyPassword(authenticationDto.getPassword());
                }
                this.messengerConfig.setFtpProxyUser(authenticationDto.getUsername());
            } else {
                this.messengerConfig.removeFtpProxyAuthentication();
            }
        } else {
            this.messengerConfig.removeFtpProxyConfig();
        }
        XpHttpProxyConfigDto httpProxyConfigDto = communicationDto.getHttpProxyConfig();
        if (httpProxyConfigDto != null) {
            this.messengerConfig.setProxyHost(httpProxyConfigDto.getHost());
            this.messengerConfig.setProxyDomain(httpProxyConfigDto.getNtDomain());
            this.messengerConfig.setProxyPort(httpProxyConfigDto.getPort());
            XpAuthenticationDto authenticationDto = httpProxyConfigDto.getAuthentication();
            if (authenticationDto != null) {
                this.messengerConfig.setProxyUser(authenticationDto.getUsername());
                if (!"***".equals(authenticationDto.getPassword()) || this.messengerConfig.getProxyPassword() == null) {
                    this.messengerConfig.setProxyPassword(authenticationDto.getPassword());
                }
            } else {
                this.messengerConfig.removeHttpProxyAuthentication();
            }
            this.messengerConfig.setProxyBypassList(httpProxyConfigDto.getBypassProxyFor());
        } else {
            this.messengerConfig.setProxyHost("");
            this.messengerConfig.setProxyPort(0);
        }
        this.messengerConfig.setMessageIdDomain(communicationDto.getMessageIdDomain());
        this.messengerConfig.setDefaultAdapterId(communicationDto.getDefaultAdapter());
        this.messengerConfig.setDefaultRetransmissionRetryInterval(communicationDto.getRetransmission().getRetryInterval());
        this.messengerConfig.setDefaultRetransmissionRetries(communicationDto.getRetransmission().getNumberOfRetries());
        this.messengerConfig.setSSLCertificateCheck(communicationDto.isCheckSslServerCert());
        this.messengerConfig.setRequeueFailedMessages(communicationDto.isRequeueFailedMessages());
        this.messengerConfig.setPartnerCertificateRevocationCheck(communicationDto.isPartnerCertificateRevocationCheck());
        this.setLoopbackEnabled(communicationDto.isAllowLoopback());
        this.setPingAllEnabled(communicationDto.getPingAll().isPingAll());
        this.setPingAllInterval(communicationDto.getPingAll().getPingAllInterval());
    }

    private void updateArchiveConfiguration(XpArchiveDto archiveDto) {
        this.setArchiveFolder(archiveDto.getArchiveFolder());
        this.setArchiveFailedFolder(archiveDto.getArchiveFailedFolder());
        this.setArchivePayload(archiveDto.getMessageParts().contains((Object)XpMessagePart.PAYLOAD));
        this.setArchiveSignature(archiveDto.getMessageParts().contains((Object)XpMessagePart.SIGNATURE));
        this.setArchiveAttachments(archiveDto.getMessageParts().contains((Object)XpMessagePart.ATTACHMENT));
        this.setArchiveCertificate(archiveDto.getMessageParts().contains((Object)XpMessagePart.CERTIFICATE));
        this.setArchiveBackendEnvelope(archiveDto.getMessageParts().contains((Object)XpMessagePart.BACKEND_ENVELOPE));
        this.setArchivePackagingEnvelope(archiveDto.getMessageParts().contains((Object)XpMessagePart.PACKAGING_ENVELOPE));
        this.setArchiverType(archiveDto.getArchiverType());
        this.setArchiverAdapterId(archiveDto.getAdapterId());
        this.setArchiveCompression(archiveDto.isUseZipCompression());
        this.setArchiveCleanup(archiveDto.getArchiveCleanup());
    }

    public void setArchiverType(XpArchiverType archiverType) {
        XpArchiverType currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getArchiverType).get();
        if (!Objects.equals((Object)archiverType, (Object)currentValue)) {
            this.messengerConfig.setArchiverType(archiverType);
        }
    }

    public void setArchiverAdapterId(String adapterId) {
        String currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getArchiveAdapterId).get();
        if (!Objects.equals(adapterId, currentValue)) {
            this.messengerConfig.setArchiveAdapterId(adapterId);
        }
    }

    public void setArchiveFolder(String archiveFolder) {
        String currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getArchiveFolder).get();
        if (archiveFolder != null && !archiveFolder.equals(currentValue)) {
            this.messengerConfig.setArchiveFolder(archiveFolder);
        }
    }

    public void setArchiveFailedFolder(String archiveFailedFolder) {
        String currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getArchiveFolder).get();
        if (archiveFailedFolder != null && !archiveFailedFolder.equals(currentValue)) {
            this.messengerConfig.setArchiveFailedFolder(archiveFailedFolder);
        }
    }

    public void setArchiveBackendEnvelope(boolean archiveBackendEnvelope) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isArchiveBackendEnvelope).get();
        if (archiveBackendEnvelope != currentValue) {
            this.messengerConfig.setArchiveBackendEnvelope(archiveBackendEnvelope);
        }
    }

    public void setArchiveCompression(boolean archiveCompression) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isArchiveCompression).get();
        if (archiveCompression != currentValue) {
            this.messengerConfig.setArchiveCompression(archiveCompression);
        }
    }

    public void setArchiveCertificate(boolean archiveCertificate) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isArchiveCertificate).get();
        if (archiveCertificate != currentValue) {
            this.messengerConfig.setArchiveCertificate(archiveCertificate);
        }
    }

    public void setArchivePackagingEnvelope(boolean archivePackagingEnvelope) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isArchiveEbXml).get();
        if (archivePackagingEnvelope != currentValue) {
            this.messengerConfig.setArchiveEbXml(archivePackagingEnvelope);
        }
    }

    public void setArchivePayload(boolean archivePayload) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isArchivePayload).get();
        if (archivePayload != currentValue) {
            this.messengerConfig.setArchivePayload(archivePayload);
        }
    }

    public void setArchiveSignature(boolean archiveSignature) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isArchiveSignature).get();
        if (archiveSignature != currentValue) {
            this.messengerConfig.setArchiveSignature(archiveSignature);
        }
    }

    public void setArchiveAttachments(boolean archiveAttachments) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isArchiveAttachments).get();
        if (archiveAttachments != currentValue) {
            this.messengerConfig.setArchiveAttachments(archiveAttachments);
        }
    }

    void setArchiveCleanup(XpCleanupDto cleanupDto) {
        boolean deleteArchive = cleanupDto != null;
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isDeleteArchive).get();
        boolean archiveCleanupConfigured = ThrowingSupplier.unchecked(this.messengerConfig::isArchiveCleanupConfigured).get();
        if (deleteArchive != currentValue || !archiveCleanupConfigured) {
            this.messengerConfig.setDeleteArchive(deleteArchive);
        }
        String archiveCleanUpTime = this.getCleanupTime(cleanupDto);
        String currentCleanUpTime = ThrowingSupplier.unchecked(this.messengerConfig::getArchiveCleanupTimeAsString).get();
        if (!Objects.equals(archiveCleanUpTime, currentCleanUpTime)) {
            this.messengerConfig.setArchiveCleanUpTime(archiveCleanUpTime);
        }
        int archiveCleanUpMaxRuntime = cleanupDto == null || cleanupDto.getCleanupMaxRuntime() == null ? 0 : cleanupDto.getCleanupMaxRuntime();
        int currentCleanUpMaxRuntime = ThrowingSupplier.unchecked(this.messengerConfig::getArchiveCleanupMaxRuntime).get();
        if (archiveCleanUpMaxRuntime != currentCleanUpMaxRuntime) {
            this.messengerConfig.setArchiveCleanupMaxRuntime(archiveCleanUpMaxRuntime);
        }
        int archiveMaxAge = cleanupDto == null || cleanupDto.getMaxAge() == null ? 0 : cleanupDto.getMaxAge();
        int currentMaxAge = ThrowingSupplier.unchecked(this.messengerConfig::getArchiveMaxAge).get();
        if (archiveMaxAge != currentMaxAge) {
            this.messengerConfig.setArchiveMaxAge(archiveMaxAge);
        }
    }

    void setDatabaseCleanup(XpCleanupDto cleanupDto) {
        boolean deleteDB = cleanupDto != null;
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isDeleteDatabase).get();
        boolean isDeleteDConfigured = ThrowingSupplier.unchecked(this.messengerConfig::isDeleteDatabaseConfigured).get();
        if (deleteDB != currentValue || !isDeleteDConfigured) {
            this.messengerConfig.setDeleteDatabase(deleteDB);
        }
        String dbCleanUpTime = this.getCleanupTime(cleanupDto);
        String currentCleanUpTime = ThrowingSupplier.unchecked(this.messengerConfig::getDatabaseCleanupTimeAsString).get();
        if (!Objects.equals(dbCleanUpTime, currentCleanUpTime)) {
            this.messengerConfig.setDatabaseCleanUpTime(dbCleanUpTime);
        }
        int dbCleanUpMaxRuntime = cleanupDto == null || cleanupDto.getCleanupMaxRuntime() == null ? 0 : cleanupDto.getCleanupMaxRuntime();
        int currentCleanUpMaxRuntime = ThrowingSupplier.unchecked(this.messengerConfig::getDatabaseCleanupMaxRuntime).get();
        if (dbCleanUpMaxRuntime != currentCleanUpMaxRuntime) {
            this.messengerConfig.setDatabaseCleanupMaxRuntime(dbCleanUpMaxRuntime);
        }
        int dbMaxAge = cleanupDto == null || cleanupDto.getMaxAge() == null ? 0 : cleanupDto.getMaxAge();
        int currentMaxAge = ThrowingSupplier.unchecked(this.messengerConfig::getDatabaseMaxAge).get();
        if (dbMaxAge != currentMaxAge) {
            this.messengerConfig.setDatabaseMaxAge(dbMaxAge);
        }
    }

    private String getCleanupTime(XpCleanupDto cleanupDto) {
        return cleanupDto == null || cleanupDto.getCleanupTime() == null ? null : cleanupDto.getCleanupTime().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public void setNtpServerSynchronizeIntervalHours(int intervalHours) {
        int currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getNtpServerSynchronizeIntervalHours).get();
        if (intervalHours != currentValue) {
            this.messengerConfig.setNtpServerSynchronizeIntervalHours(intervalHours);
        }
    }

    public void setNtpServers(List<NtpServer> ntpServerList) {
        List currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getNtpServers).get();
        if (currentValue.size() != ntpServerList.size() || !currentValue.containsAll(ntpServerList)) {
            this.messengerConfig.setNtpServers(ntpServerList);
        }
    }

    public void setNtpEnabled(boolean enabled) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isNtpEnabled).get();
        if (enabled != currentValue) {
            this.messengerConfig.setNtpEnabled(enabled);
        }
    }

    public void setMessengerLogLevel(String logLevel) {
        String currentValue = ThrowingSupplier.unchecked(this.serverConfig::getMessengerLogLevel).get();
        if (!logLevel.equals(currentValue)) {
            this.serverConfig.setMessengerLogLevel(logLevel);
        }
    }

    public void setJDBCLogLevel(String logLevel) {
        String currentValue = ThrowingSupplier.unchecked(this.serverConfig::getJDBCLogLevel).get();
        if (!logLevel.equals(currentValue)) {
            this.serverConfig.setJDBCLogLevel(logLevel);
        }
    }

    public void setMaintenanceServices(List<MaintenanceService> maintenanceServices) {
        List currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getMaintenanceServices).get();
        if (maintenanceServices.size() != currentValue.size() || !currentValue.containsAll(maintenanceServices)) {
            this.messengerConfig.setMaintenanceServices(maintenanceServices);
        }
    }

    public void setPingAllInterval(int pingAllInterval) {
        int currentValue = ThrowingSupplier.unchecked(this.messengerConfig::getPingAllInterval).get();
        if (pingAllInterval != currentValue) {
            this.messengerConfig.setPingAllInterval(pingAllInterval);
        }
    }

    public void setPingAllEnabled(boolean enabled) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isPingAllEnabled).get();
        if (enabled != currentValue) {
            this.messengerConfig.setPingAllEnabled(enabled);
        }
    }

    public void setLoopbackEnabled(boolean enabled) {
        boolean currentValue = ThrowingSupplier.unchecked(this.messengerConfig::isLoopback).get();
        if (enabled != currentValue) {
            this.messengerConfig.setLoopback(enabled);
        }
    }

    public synchronized void save() throws JAXBException {
        this.save("SYSTEM");
    }

    public void save(String username) throws JAXBException {
        this.messengerConfig.update(username);
        this.serverConfig.save();
        this.messengerConfigChangeWatcher.checkConfigTimestampChanged();
    }

    synchronized void triggerOnConfigChangeActions() {
        LOG.debug("Triggering onConfigChangeActions");
        try {
            this.messengerConfig.loadConfigToMemory();
        }
        catch (JAXBException e) {
            LOG.error("Failed to load messenger config", (Throwable)e);
        }
        try {
            int ntpServerHash = this.getNtpServerListHashCode(this.messengerConfig.getNtpServers());
            if (this.ntpServerListHashCode.get() != ntpServerHash) {
                this.ntpServerListHashCode.set(ntpServerHash);
                LOG.debug("NtpServerConfig changed => start updateNow on ReferenceDateTask");
                this.referenceDateTask.updateNow();
            }
        }
        catch (JAXBException e) {
            LOG.error("Error while updating ntp server list", (Throwable)e);
        }
        this.loggingSystem.updateLogConfig();
        this.messengerLog.reinitLogChannels();
        int maintenanceHash = this.getMaintenanceServiceListHashCode(this.messengerConfig.getMaintenanceServices());
        if (this.maintenanceServiceListHashCode.get() != maintenanceHash) {
            this.maintenanceServiceListHashCode.set(maintenanceHash);
            LOG.debug("MaintenanceModeConfig changed => restart MaintenanceManager");
            this.maintenanceManager.restart();
        }
        int listenersHash = this.getListenerListHashCode(this.messengerConfig.getXpListeners());
        if (this.lastListenerListHashCode.get() != listenersHash) {
            this.lastListenerListHashCode.set(listenersHash);
            LOG.debug("ListenerConfig changed => reconnect listener(s)");
            try {
                List<Future<Boolean>> reconnect = this.listenerConnector.reconnect();
                for (Future<Boolean> future : reconnect) {
                    try {
                        future.get(5000L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        LOG.warn("Error while waiting for listener connection establishment: {}", (Object)e.toString());
                    }
                }
            }
            catch (JAXBException e) {
                LOG.error("Can't reconnect to listener(s): {}", (Object)e.toString());
            }
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ReloadConfiguration(this, true));
    }

    private int getListenerListHashCode(List<Messenger.XpListener> listeners) {
        int hashCode = 1;
        for (Messenger.XpListener listener : listeners) {
            int listenerHash = Objects.hash(listener.getHost(), listener.getPort(), listener.isEnabled(), listener.isSsl(), listener.getDataConnectionCount());
            hashCode = 31 * hashCode + listenerHash;
        }
        return hashCode;
    }

    private int getNtpServerListHashCode(List<NtpServer> ntpServers) {
        int hashCode = 1;
        for (NtpServer ntpServer : ntpServers) {
            int listenerHash = Objects.hash(ntpServer.getHostname(), ntpServer.getPort());
            hashCode = 31 * hashCode + listenerHash;
        }
        return hashCode;
    }

    private int getMaintenanceServiceListHashCode(List<MaintenanceService> maintenanceServices) {
        int hashCode = 1;
        for (MaintenanceService maintenanceService : maintenanceServices) {
            int listenerHash = Objects.hash(maintenanceService.getStartTime(), maintenanceService.getEndTime(), maintenanceService.isTurnOffToAdapters(), maintenanceService.isTurnOffToPartners(), maintenanceService.isRejectInboundMSGs(), maintenanceService.isRejectOutboundMSGs());
            hashCode = 31 * hashCode + listenerHash;
        }
        return hashCode;
    }
}

