/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.ponton.securelistener.administration.certs.Certificate;
import de.ponton.securelistener.administration.certs.ServerCertificate;
import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.ftp.FtpExchangeUser;
import de.ponton.securelistener.ftp.FtpExchangeUserProperties;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.listener.ClientCertificateInstaller;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import de.pontonconsulting.xmlpipe.events.ListenerCertificatesChanged;
import de.pontonconsulting.xmlpipe.events.ListenerConfigChanged;
import de.pontonconsulting.xmlpipe.events.ListenerConnected;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.listener.ListenerCertificateGulagService;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificateId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerFTPUser;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ListenerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.runtime.SwitchBootstraps;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ListenerConfigService
implements ApplicationListener<ApplicationEvent> {
    private static final Logger log = LogManager.getLogger((String)"Listener.ListenerConfigService");
    private final MessengerConfig messengerConfig;
    private final MessengerConfigDAO messengerConfigDAO;
    private final ListenerConfigDAO listenerConfigDAO;
    private final ListenerConfig listenerConfig;
    private final ClientCertificateInstaller clientCertificateInstaller;
    private final ExecutorService applicationEventExecutorService;
    private final ListenerCertificateGulagService listenerCertificateGulagService;
    private final AtomicBoolean initDone = new AtomicBoolean(false);
    private final AtomicBoolean restartNeeded = new AtomicBoolean(false);
    private final AtomicBoolean initScheduled = new AtomicBoolean(false);

    public ListenerConfigService(MessengerConfig messengerConfig, MessengerConfigDAO messengerConfigDAO, ListenerConfigDAO listenerConfigDAO, ListenerConfig listenerConfig, ClientCertificateInstaller clientCertificateInstaller, ExecutorService applicationEventExecutorService, ListenerCertificateGulagService listenerCertificateGulagService) {
        this.messengerConfig = messengerConfig;
        this.messengerConfigDAO = messengerConfigDAO;
        this.listenerConfigDAO = listenerConfigDAO;
        this.listenerConfig = listenerConfig;
        this.clientCertificateInstaller = clientCertificateInstaller;
        this.applicationEventExecutorService = applicationEventExecutorService;
        this.listenerCertificateGulagService = listenerCertificateGulagService;
    }

    public void init() {
        try {
            log.info("Start initialize ListenerConfigService");
            if (!this.isListenerEnabled()) {
                log.info("Listener connection is disabled");
                return;
            }
            if (!this.listenerConfig.isConnected()) {
                log.info("Listener is not connected");
                return;
            }
            this.initDone.set(false);
            this.restartNeeded.set(false);
            this.synchronizeDBCertsToListener(ListenerCertificate.Type.SERVER_CA);
            this.synchronizeDBCertsToListener(ListenerCertificate.Type.SERVER);
            this.synchronizeDBCertsToListener(ListenerCertificate.Type.CLIENT_CA);
            this.synchronizeDBCertsToListener(ListenerCertificate.Type.CLIENT);
            this.synchronizeProperties();
            this.synchronizeFtpUsers();
            if (this.clientCertificateInstaller.installAllPartnerCertificate()) {
                this.restartNeeded.set(true);
            }
            this.listenerCertificateGulagService.importGulagFile().forEach(this.listenerConfigDAO::importCertificate);
            if (this.restartNeeded.get()) {
                this.listenerConfig.restartServices();
            }
            this.initDone.set(true);
            log.info("Finished initialize ListenerConfigService");
        }
        catch (Exception e) {
            log.error("Can't synchronize Listener configuration due to {}", (Object)e.toString(), (Object)(log.isDebugEnabled() ? e : null));
        }
        finally {
            this.initScheduled.set(false);
        }
    }

    private boolean isListenerEnabled() {
        try {
            return this.messengerConfig.isListenerEnabled();
        }
        catch (JAXBException e) {
            return false;
        }
    }

    void synchronizeProperties() throws ListenerConfigException, IOException {
        ListenerProperties listenerProperties = this.listenerConfig.getProperties(true);
        de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig listenerConfigRecord = this.messengerConfigDAO.loadMessengerConfig("listener.properties");
        if (Objects.isNull(listenerConfigRecord)) {
            this.saveConfigFromListener(listenerProperties, "SYSTEM");
        } else {
            Properties propsFromDB = new Properties();
            propsFromDB.load(new ByteArrayInputStream(listenerConfigRecord.getData()));
            Properties propsFromListener = new Properties();
            propsFromListener.load(new StringReader(this.listenerConfig.getProperties(false).createConfig().toString()));
            if (!this.areEqual(propsFromDB, propsFromListener)) {
                listenerProperties.updateConfig(propsFromDB);
                this.listenerConfig.setProperties(listenerProperties);
                this.listenerConfig.updateConfiguration();
                this.restartNeeded.set(true);
                log.info("Sent updated ConfigProperties to listener");
            } else {
                log.debug("Listener ConfigProperties didn't change => no update needed");
            }
        }
    }

    private boolean areEqual(Properties p1, Properties p2) {
        if (!p1.keySet().equals(p2.keySet())) {
            log.trace("ListenerPropertyKeySets doesn't match {} / {}", p1.keySet(), p2.keySet());
            return false;
        }
        for (Object keyObj : p1.keySet()) {
            String key = keyObj.toString();
            String value1 = p1.getProperty(key);
            String value2 = p2.getProperty(key);
            if (key.endsWith(".Password") || Objects.equals(value1, value2)) continue;
            log.trace("ListenerPropertyValues on property {} don't match {} / {}", (Object)key, (Object)value1, (Object)value2);
            return false;
        }
        return true;
    }

    void synchronizeFtpUsers() throws ListenerConfigException {
        FtpExchangeUserProperties ftpUserFromListener = this.listenerConfig.getFtpExchangeUserProperties(true);
        List<ListenerFTPUser> ftpUsersFromDB = this.listenerConfigDAO.loadFtpUsers();
        if (ftpUsersFromDB.isEmpty()) {
            this.saveFtpUsersFromListener(ftpUserFromListener, "SYSTEM");
        } else {
            List<FtpExchangeUser> ftpExchangeUsersFromDB = ftpUsersFromDB.stream().map(ftp -> {
                FtpExchangeUser ftpUser = new FtpExchangeUser();
                ftpUser.setUserName(ftp.getName());
                ftpUser.setEncryptedPassword(ftp.getPassword());
                ftpUser.setPartnerLocalId(ftp.getPartnerLocalId());
                return ftpUser;
            }).toList();
            if (!this.equals(ftpExchangeUsersFromDB, ftpUserFromListener.getFtpExchangeUsers())) {
                FtpExchangeUserProperties ftpExchangeUserProperties = new FtpExchangeUserProperties(ftpExchangeUsersFromDB);
                this.listenerConfig.setFtpExchangeUserProperties(ftpExchangeUserProperties);
                this.listenerConfig.updateFtpUserProperties();
                this.restartNeeded.set(true);
                log.info("Updated {} FtpUsers on Listener", (Object)ftpExchangeUsersFromDB.size());
            } else {
                log.debug("FtpUsers didn't change => no update needed");
            }
        }
    }

    private boolean equals(List<FtpExchangeUser> ftpExchangeUsers, List<FtpExchangeUser> ftpExchangeUsers2) {
        if (ftpExchangeUsers.size() != ftpExchangeUsers2.size()) {
            return false;
        }
        for (FtpExchangeUser ftpExchangeUser : ftpExchangeUsers) {
            Optional<FtpExchangeUser> ftpExchangeUser2 = ftpExchangeUsers2.stream().filter(u -> StringUtils.equals((CharSequence)ftpExchangeUser.getUserName(), (CharSequence)u.getUserName())).findFirst();
            if (ftpExchangeUser2.isEmpty()) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)ftpExchangeUser.getEncryptedPassword(), (CharSequence)ftpExchangeUser2.get().getEncryptedPassword())) {
                return false;
            }
            if (StringUtils.equals((CharSequence)ftpExchangeUser.getPartnerLocalId(), (CharSequence)ftpExchangeUser2.get().getPartnerLocalId())) continue;
            return false;
        }
        return true;
    }

    void synchronizeDBCertsToListener(ListenerCertificate.Type type) {
        List<ListenerCertificate> certsFromDB = this.listenerConfigDAO.loadListenerCertificatesByType(type);
        Set<String> aliasesFromListener = this.getCertAliasesFromListener(type);
        if (!certsFromDB.isEmpty()) {
            Set aliasesFromDB = certsFromDB.stream().map(ListenerCertificate::getAlias).collect(Collectors.toSet());
            certsFromDB.stream().filter(cert -> !aliasesFromListener.contains(cert.getAlias())).forEach(this::installCertOnListener);
            aliasesFromListener.stream().filter(alias -> !aliasesFromDB.contains(alias)).forEach(alias -> this.deleteCertFromListener(type, (String)alias));
        } else {
            aliasesFromListener.forEach(alias -> this.downloadCertificateToDB(type, (String)alias));
        }
    }

    private void downloadCertificateToDB(ListenerCertificate.Type type, String alias) {
        Certificate certificate = this.getCertFromListener(type, alias);
        if (Objects.nonNull(certificate)) {
            ListenerCertificate listenerCertificate = new ListenerCertificate();
            listenerCertificate.setId(new ListenerCertificateId(alias, type));
            listenerCertificate.setCertificate(certificate.getCertificate());
            listenerCertificate.setStatus(ListenerCertificate.Status.TRUSTED);
            listenerCertificate.setLastCheck(OffsetDateTime.now(ZoneOffset.UTC));
            listenerCertificate.setLastSuccessfulCheck(OffsetDateTime.now(ZoneOffset.UTC));
            this.listenerConfigDAO.saveListenerCertificate(listenerCertificate);
            log.info("Saved {} certificate '{}' from listener in DB", (Object)type, (Object)alias);
        } else {
            log.error("Can't get {} certificate '{}' from listener", (Object)type, (Object)alias);
        }
    }

    void synchronizeListenerCertsToDB(ListenerCertificate.Type type) {
        try {
            Set<String> aliasesFromListener = this.getCertAliasesFromListener(type);
            List<String> aliasesFromDB = this.listenerConfigDAO.loadListenerCertificateAliasesByType(type);
            aliasesFromListener.stream().filter(alias -> !aliasesFromDB.contains(alias)).forEach(alias -> this.downloadCertificateToDB(type, (String)alias));
            aliasesFromDB.stream().filter(alias -> !aliasesFromListener.contains(alias)).forEach(alias -> this.listenerConfigDAO.deleteCertificate((String)alias, type));
            log.info("Synchronized {} certificates from listener to database", (Object)type);
            if (ListenerCertificate.Type.SERVER == type) {
                this.saveConfigFromListener(this.listenerConfig.getProperties(true), "SYSTEM");
            }
        }
        catch (Exception e) {
            log.error("Can't synchronize {} certificates from listener to database: {}", (Object)type, (Object)e.toString(), (Object)(log.isDebugEnabled() ? e : null));
        }
    }

    private Set<String> getCertAliasesFromListener(ListenerCertificate.Type type) {
        try {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ListenerCertificate.Type.CLIENT -> this.listenerConfig.listClientCertificates();
                case ListenerCertificate.Type.SERVER -> this.listenerConfig.listServerCertificates();
                case ListenerCertificate.Type.CLIENT_CA -> this.listenerConfig.listClientCACertificates();
                case ListenerCertificate.Type.SERVER_CA -> this.listenerConfig.listServerCACertificates();
            };
        }
        catch (ListenerConfigException e) {
            log.error("Can't get {} certificate aliases from listener: {}", (Object)type, (Object)e.toString());
            throw new IllegalStateException(e);
        }
    }

    private Certificate getCertFromListener(ListenerCertificate.Type type, String alias) {
        try {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ListenerCertificate.Type.CLIENT -> this.listenerConfig.getClientCertificate(alias);
                case ListenerCertificate.Type.SERVER -> new Certificate(this.listenerConfig.exportServerCertificate(alias, this.getServerCertPassword(alias)));
                case ListenerCertificate.Type.CLIENT_CA -> this.listenerConfig.getClientCACertificate(alias);
                case ListenerCertificate.Type.SERVER_CA -> this.listenerConfig.getServerCACertificate(alias);
            };
        }
        catch (ListenerConfigException | IOException e) {
            log.error("Can't get {} certificate '{}' from listener: {}", (Object)type, (Object)alias, (Object)e.toString());
            throw new IllegalStateException(e);
        }
    }

    private void deleteCertFromListener(ListenerCertificate.Type type, String alias) {
        try {
            switch (type) {
                case CLIENT: {
                    this.listenerConfig.deleteClientCertificate(alias);
                    break;
                }
                case SERVER: {
                    this.listenerConfig.deleteServerCertificate(alias);
                    break;
                }
                case CLIENT_CA: {
                    this.listenerConfig.deleteClientCACertificate(alias);
                    break;
                }
                case SERVER_CA: {
                    this.listenerConfig.deleteServerCACertificate(alias);
                }
            }
            this.restartNeeded.set(true);
            log.info("Deleted {} certificate '{}' from listener", (Object)type, (Object)alias);
        }
        catch (ListenerConfigException e) {
            log.error("Can't delete {} certificate '{}' from listener: {}", (Object)type, (Object)alias, (Object)e.toString());
        }
    }

    private void installCertOnListener(ListenerCertificate certificate) {
        try {
            Certificate cert = new Certificate(certificate.getCertificate());
            switch (certificate.getType()) {
                case CLIENT: {
                    this.listenerConfig.installClientCertificate(cert, false);
                    break;
                }
                case SERVER: {
                    this.listenerConfig.installServerCertificate(this.createServerCert(certificate, this.getServerCertPassword(certificate.getAlias())));
                    break;
                }
                case CLIENT_CA: {
                    this.listenerConfig.installClientCACertificate(cert);
                    break;
                }
                case SERVER_CA: {
                    this.listenerConfig.installServerCACertificate(cert, certificate.getAlias());
                }
            }
            this.restartNeeded.set(true);
            log.info("Installed {} certificate '{}' on listener", (Object)certificate.getType(), (Object)certificate.getAlias());
        }
        catch (ListenerConfigException | IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IllegalStateException("Can't install " + String.valueOf((Object)certificate.getType()) + " '" + certificate.getAlias() + "': " + e.getMessage(), e);
        }
    }

    ServerCertificate createServerCert(ListenerCertificate certificate, String password) throws ListenerConfigException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        String alias = certificate.getAlias();
        char[] pwChars = password.toCharArray();
        byte[] pkcs12Bytes = Base64.getDecoder().decode(certificate.getCertificate());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(pkcs12Bytes);){
            keyStore.load(inputStream, pwChars);
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, pwChars);
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
        return new ServerCertificate(Base64.getEncoder().encode(cert.getEncoded()), Base64.getEncoder().encode(privateKey.getEncoded()), password);
    }

    private String getServerCertPassword(String alias) throws ListenerConfigException, IOException {
        ListenerProperties listenerProperties = this.listenerConfig.getProperties(false);
        for (ListenerProperties.PrivateKeyInfo privateKeyInfo : listenerProperties.getPrivateKeyInfos()) {
            if (!privateKeyInfo.alias().equals(alias)) continue;
            return privateKeyInfo.password();
        }
        listenerProperties = this.listenerConfig.getProperties(true);
        for (ListenerProperties.PrivateKeyInfo privateKeyInfo : listenerProperties.getPrivateKeyInfos()) {
            if (!privateKeyInfo.alias().equals(alias)) continue;
            return privateKeyInfo.password();
        }
        de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig listenerConfigRecord = this.messengerConfigDAO.loadMessengerConfig("listener.properties");
        if (Objects.nonNull(listenerConfigRecord)) {
            Properties propsFromDB = new Properties();
            propsFromDB.load(new ByteArrayInputStream(listenerConfigRecord.getData()));
            listenerProperties.updateConfig(propsFromDB);
            for (ListenerProperties.PrivateKeyInfo privateKeyInfo : listenerProperties.getPrivateKeyInfos()) {
                if (!privateKeyInfo.alias().equals(alias)) continue;
                return privateKeyInfo.password();
            }
        }
        log.warn("Can't get password for SERVER certificate '{}' from listener.properties. Use default password", (Object)alias);
        return "changeit";
    }

    private void saveConfigFromListener(ListenerProperties listenerProperties, String userName) {
        this.messengerConfigDAO.storeMessengerConfig(listenerProperties.createConfig().toString().getBytes(), "listener.properties", userName);
        log.info("Saved ListenerConfig properties in DB");
    }

    private void saveFtpUsersFromListener(FtpExchangeUserProperties ftpExchangeUserProperties, String userName) {
        ftpExchangeUserProperties.getFtpExchangeUsers().forEach(ftpUser -> {
            this.listenerConfigDAO.saveFtpUser(ftpUser.getUserName(), ftpUser.getEncryptedPassword(), ftpUser.getPartnerLocalId(), userName);
            log.info("Saved FTPUser '{}' from Listener in DB", (Object)ftpUser.getUserName());
        });
    }

    private void storeCurrentConfigToDB(String userName) {
        try {
            log.debug("Store current ListenerConfig in DB");
            this.saveConfigFromListener(this.listenerConfig.getProperties(false), userName);
            this.saveFtpUsersFromListener(this.listenerConfig.getFtpExchangeUserProperties(false), userName);
        }
        catch (Exception e) {
            log.error("Can't save ListenerConfig and FTP users to DB: {}", (Object)e.toString());
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ApplicationEvent applicationEvent = event;
        Objects.requireNonNull(applicationEvent);
        ApplicationEvent applicationEvent2 = applicationEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ReloadConfiguration.class, ListenerConfigChanged.class, ListenerConnected.class, ListenerCertificatesChanged.class}, (Object)applicationEvent2, n)) {
            case 0: {
                ReloadConfiguration reloadConfig = (ReloadConfiguration)applicationEvent2;
                if (!reloadConfig.isMessengerConfigChanged() || this.initDone.get() || !this.initScheduled.compareAndSet(false, true)) break;
                log.debug("Received ReloadConfiguration-Event => schedule init");
                this.applicationEventExecutorService.submit(this::init);
                break;
            }
            case 1: {
                ListenerConfigChanged listenerConfigChanged = (ListenerConfigChanged)applicationEvent2;
                log.debug("Received ListenerConfigChanged-Event");
                this.applicationEventExecutorService.submit(() -> this.storeCurrentConfigToDB(listenerConfigChanged.getUserName()));
                break;
            }
            case 2: {
                ListenerConnected listenerConnected = (ListenerConnected)applicationEvent2;
                if (!this.initScheduled.compareAndSet(false, true)) break;
                log.debug("Received ListenerConnected-Event => schedule init");
                this.applicationEventExecutorService.submit(this::init);
                break;
            }
            case 3: {
                ListenerCertificatesChanged listenerCertificatesChanged = (ListenerCertificatesChanged)applicationEvent2;
                if (!this.initDone.get()) break;
                log.debug("Received ListenerCertificatesChanged-Event for {}", (Object)listenerCertificatesChanged.getType());
                this.applicationEventExecutorService.submit(() -> this.synchronizeListenerCertsToDB(listenerCertificatesChanged.getType()));
                break;
            }
        }
    }
}

