/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.EnvelopeModel;
import de.pontonconsulting.xmlpipe.config.IEnvelopeConfig;
import de.pontonconsulting.xmlpipe.config.XpValidationEventHandler;
import de.pontonconsulting.xmlpipe.config.envelope.EnvelopeMapping;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvelopeConfig
implements IEnvelopeConfig {
    private static Logger LOG = LogManager.getLogger((String)"Messenger.EnvelopeConfig");
    private static final String ENVELOPE_CONFIG_CLASSES = "de.pontonconsulting.xmlpipe.config.envelope";
    private static final String ENVELOPE_FOLDER = "Envelopes";
    private final List<EnvelopeModel> _envelopes = new ArrayList<EnvelopeModel>();
    private ConfigResourceService _configResourceService;

    public EnvelopeConfig(ConfigResourceService configResourceService) throws IOException {
        this._configResourceService = configResourceService;
        this.loadEnvelopesToMemory();
        LOG.debug("Found {} envelopes.", (Object)this._envelopes.size());
    }

    private void loadEnvelopesToMemory() throws IOException {
        for (Map.Entry<URI, InputStream> entry : this._configResourceService.getResources("Envelopes/*.xml").entrySet()) {
            XpValidationEventHandler validation = new XpValidationEventHandler();
            try {
                InputStream envelopeStream = entry.getValue();
                try {
                    JAXBContext jc = JAXBContext.newInstance((String)ENVELOPE_CONFIG_CLASSES);
                    Unmarshaller u = jc.createUnmarshaller();
                    u.setEventHandler((ValidationEventHandler)validation);
                    EnvelopeMapping envelopeMapping = (EnvelopeMapping)u.unmarshal(envelopeStream);
                    this.addEnvelope(envelopeMapping);
                }
                finally {
                    if (envelopeStream == null) continue;
                    envelopeStream.close();
                }
            }
            catch (JAXBException jaxb) {
                if (validation.getMessage() != null) {
                    LOG.error("Could not load envelope file '" + String.valueOf(entry.getKey()) + "'Reason: XML Error in " + String.valueOf(entry.getKey()) + " (Line:" + validation.getLine() + " / Column:" + validation.getColumn() + ") " + validation.getMessage(), (Throwable)jaxb);
                    continue;
                }
                LOG.error("Could not load envelope file '" + String.valueOf(entry.getKey()) + "'", (Throwable)jaxb);
            }
            catch (IOException e) {
                LOG.error("Could not load envelope file '" + String.valueOf(entry.getKey()) + "'", (Throwable)e);
            }
        }
    }

    private void addEnvelope(EnvelopeMapping envelopeMapping) {
        EnvelopeModel envelopeModel = new EnvelopeModel();
        envelopeModel.setEnvelopeName(envelopeMapping.getName());
        envelopeModel.setRootElement(envelopeMapping.getRootElement());
        envelopeModel.setSchemaFile(new File(ENVELOPE_FOLDER, envelopeMapping.getSchemaFile()));
        envelopeModel.setNamespace(envelopeMapping.getNamespace());
        envelopeModel.setSchemaLocation(envelopeMapping.getSchemaLocation());
        EnvelopeMapping.Mapping mapping = envelopeMapping.getMapping();
        envelopeModel.setXPathType(mapping.getXPathType());
        envelopeModel.setSenderIdXPath(mapping.getSenderIdXPath());
        envelopeModel.setReceiverIdXPath(mapping.getReceiverIdXPath());
        envelopeModel.setMessageIdXPath(mapping.getMessageIdXPath());
        envelopeModel.setMessageTypeXPath(mapping.getMessageTypeXPath());
        envelopeModel.setMessageVersionXPath(mapping.getMessageVersionXPath());
        envelopeModel.setSchemaSetXPath(mapping.getSchemaSetXPath());
        envelopeModel.setPayloadXPath(mapping.getPayloadXPath());
        envelopeModel.setLogInfoXPath(mapping.getLogInfoXPath());
        EnvelopeMapping.Mapping.TestFlag testFlag = mapping.getTestFlag();
        if (testFlag != null) {
            envelopeModel.setTestXPath(testFlag.getXPath());
            envelopeModel.setTestValue(testFlag.getTestValue());
        }
        this._envelopes.add(envelopeModel);
    }

    @Override
    public List<EnvelopeModel> getMatchedEnvelopes(String rootElement, String namespace, String schemaLocation) {
        ArrayList<EnvelopeModel> result = new ArrayList<EnvelopeModel>();
        for (EnvelopeModel envelopeModel : this._envelopes) {
            if (!envelopeModel.getRootElement().equals(rootElement) || envelopeModel.getNamespace() != null && !envelopeModel.getNamespace().equals(namespace) || envelopeModel.getSchemaLocation() != null && !envelopeModel.getSchemaLocation().equalsIgnoreCase(schemaLocation)) continue;
            result.add(envelopeModel);
        }
        return result;
    }

    @Override
    public boolean hasEnvelopeDefinitions() {
        return !this._envelopes.isEmpty();
    }
}

