/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.ponton.xmlpipe.rest.cpa.AgreementTemplateListItemDto;
import de.pontonconsulting.xmlpipe.config.AddOn;
import de.pontonconsulting.xmlpipe.config.AddOnInfoReader;
import de.pontonconsulting.xmlpipe.config.AgreementTemplateBundle;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.EbXml20ServiceConfig;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.listener.ebxml2.BaseEbXml2Service;
import de.pontonconsulting.xmlpipe.listener.ebxml2.MessengerService;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.filter.CompressionFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.ContentRuleFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.CustomValidationFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.DecompressionFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.DecryptionFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.EncryptionFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageMulticastInboundFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageMulticastOutboundFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.SignatureCreationFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.SignatureVerificationFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.ValidationFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.XmlModificationFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.XMLSecInboundFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.XMLSecOutboundFilter;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DistributionConfigFinder {
    public static final String CUSTOM_PARTY_ID_TYPES_PROPERTIES_FILE = "partyIDTypes.properties";
    public static final String MANIFEST_ATTRIBUTE_PARTY_ID_TYPES_PROPERTIES_FILE = "Party-Id-Types-Properties-File";
    public static final String PARTY_ID_TYPE_URI = "URI";
    public static final String PARTY_ID_TYPE_AS2 = "AS2-Name";
    public static final String PARTY_ID_TYPE_AS3 = "AS3-Name";
    public static final String PARTY_ID_TYPE_EMAIL = "E-Mail";
    public static final String CUSTOM_PIPELINES_PROPERTIES_FILE = "messengerPipelines.properties";
    public static final String DEFAULT_PIPELINE_ID = "Messenger 2.1";
    public static final String[] DEFAULT_INBOUND_PIPE = new String[]{DecryptionFilter.class.getCanonicalName(), DecompressionFilter.class.getCanonicalName(), SignatureVerificationFilter.class.getCanonicalName(), XMLSecInboundFilter.class.getCanonicalName(), ValidationFilter.class.getCanonicalName(), CustomValidationFilter.class.getCanonicalName(), ContentRuleFilter.class.getCanonicalName(), XmlModificationFilter.class.getCanonicalName(), MessageMulticastInboundFilter.class.getCanonicalName()};
    public static final String[] DEFAULT_OUTBOUND_PIPE = new String[]{XmlModificationFilter.class.getCanonicalName(), ValidationFilter.class.getCanonicalName(), CustomValidationFilter.class.getCanonicalName(), MessageMulticastOutboundFilter.class.getCanonicalName(), ContentRuleFilter.class.getCanonicalName(), XMLSecOutboundFilter.class.getCanonicalName(), SignatureCreationFilter.class.getCanonicalName(), CompressionFilter.class.getCanonicalName(), EncryptionFilter.class.getCanonicalName()};
    public static final String CUSTOM_EBXML20_SERVICES_PROPERTIES_FILE = "messengerServices.properties";
    public static final String MANIFEST_ATTRIBUTE_EBXML20_SERVICES_PROPERTIES_FILE = "EbXml20-Services-Properties-File";
    EbXml20ServiceConfig DEFAULT_MESSAGE_SERVICE = new EbXml20ServiceConfig("*", "*", "*", MessengerService.class.getCanonicalName());
    EbXml20ServiceConfig DEFAULT_SIGNAL_SERVICE = new EbXml20ServiceConfig("urn:oasis:names:tc:ebxml-msg:service", "*", "*", BaseEbXml2Service.class.getCanonicalName());
    public static final String MANIFEST_ATTRIBUTE_DEFAULT_AGREEMENT_TEMPLATE_ID = "Default-Agreement-Template-ID";
    public static final String PROPERTY_DEFAULT_AGREEMENT_TEMPLATE_ID = "ponton.messenger.agreement.default_template_id";
    private static final Log LOG = LogFactory.getFactory().getInstance("Messenger.DistributionConfigFinder");
    public static final Pattern AGREEMENT_TEMPLATE_PATTERN = Pattern.compile("(.*)agreementTemplates/(.*)_public\\.vm");
    private static final String AGREEMENT_TEMPLATES = "agreementTemplates";
    private List<String> partyIdTypes;
    private List<String> defaultPartyIdTypes;
    private Map<String, String[]> inboundPipes;
    private Map<String, String[]> outboundPipes;
    private List<EbXml20ServiceConfig> ebXml20ServiceConfigs;
    private Map<String, AgreementTemplateBundle> agreementTemplateBundles;
    private String defaultAgreementTemplateId;
    private List<AgreementTemplateListItemDto> agreementTemplateList;
    private final IServerConfigBean serverConfigBean;
    private final AddOnInfoReader addOnInfoReader;
    private final List<AddOn> configNames;
    private final ConfigResourceService configResourceService;
    private final IMessengerProperties messengerProperties;
    private final MessengerConfigDAO messengerConfigDAO;

    public DistributionConfigFinder(IServerConfigBean serverConfigBean, AddOnInfoReader addOnInfoReader, ConfigResourceService configResourceService, IMessengerProperties messengerProperties, MessengerConfigDAO messengerConfigDAO) {
        this.messengerProperties = messengerProperties;
        this.configNames = new ArrayList<AddOn>();
        this.serverConfigBean = serverConfigBean;
        this.configResourceService = configResourceService;
        this.addOnInfoReader = addOnInfoReader;
        this.messengerConfigDAO = messengerConfigDAO;
        this.agreementTemplateList = new ArrayList<AgreementTemplateListItemDto>();
    }

    @PostConstruct
    public void init() {
        LOG.trace((Object)"init");
        this.initConfigVersions();
        this.initPartyIdTypes();
        this.initPipes();
        this.initEbXml20ServiceConfigs();
        this.initAgreementTemplateIds();
    }

    private void initConfigVersions() {
        this.configNames.addAll(this.addOnInfoReader.getAddOnInfos());
    }

    public Map<String, String[]> getInboundPipes() {
        return Collections.unmodifiableMap(this.inboundPipes);
    }

    public Map<String, String[]> getOutboundPipes() {
        return Collections.unmodifiableMap(this.outboundPipes);
    }

    public List<String> getPartyIdTypes() {
        return Collections.unmodifiableList(this.partyIdTypes);
    }

    public List<String> getDefaultPartyIdTypes() {
        return Collections.unmodifiableList(this.defaultPartyIdTypes);
    }

    public List<EbXml20ServiceConfig> getEbXml20ServiceConfigs() {
        return Collections.unmodifiableList(this.ebXml20ServiceConfigs);
    }

    private void initPipes() {
        HashMap<String, String[]> inboundPipes = new HashMap<String, String[]>();
        HashMap<String, String[]> outboundPipes = new HashMap<String, String[]>();
        try {
            this.readPipelines(inboundPipes, outboundPipes, CUSTOM_PIPELINES_PROPERTIES_FILE);
            LOG.info((Object)"Found custom pipeline configuration 'messengerPipelines.properties'.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inboundPipes.isEmpty() || outboundPipes.isEmpty()) {
            LOG.info((Object)"Using the default pipeline 'Messenger 2.1'.");
            inboundPipes.put(DEFAULT_PIPELINE_ID, DEFAULT_INBOUND_PIPE);
            outboundPipes.put(DEFAULT_PIPELINE_ID, DEFAULT_OUTBOUND_PIPE);
        }
        this.inboundPipes = inboundPipes;
        this.outboundPipes = outboundPipes;
    }

    private void initPartyIdTypes() {
        TreeSet<String> partyIdTypes = new TreeSet<String>();
        TreeSet<String> defaultPartyIdTypes = new TreeSet<String>();
        try {
            this.readPartyIdTypes(partyIdTypes, defaultPartyIdTypes, CUSTOM_PARTY_ID_TYPES_PROPERTIES_FILE);
        }
        catch (IOException e) {
            LOG.debug((Object)"using default party_id_types");
            partyIdTypes.add(PARTY_ID_TYPE_URI);
            partyIdTypes.add(PARTY_ID_TYPE_EMAIL);
            partyIdTypes.add(PARTY_ID_TYPE_AS2);
            partyIdTypes.add(PARTY_ID_TYPE_AS3);
            List<String> propertiesFileNames = this.getManifestAttributeValue(MANIFEST_ATTRIBUTE_PARTY_ID_TYPES_PROPERTIES_FILE);
            for (String propertiesFileName : propertiesFileNames) {
                try {
                    this.readPartyIdTypes(partyIdTypes, defaultPartyIdTypes, propertiesFileName);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Could not read the properties file '" + propertiesFileName + "'."));
                }
            }
        }
        defaultPartyIdTypes.retainAll(partyIdTypes);
        if (defaultPartyIdTypes.isEmpty()) {
            defaultPartyIdTypes.add(PARTY_ID_TYPE_URI);
            defaultPartyIdTypes.add(PARTY_ID_TYPE_AS2);
            defaultPartyIdTypes.add(PARTY_ID_TYPE_AS3);
            defaultPartyIdTypes.retainAll(partyIdTypes);
        }
        this.partyIdTypes = new ArrayList<String>(partyIdTypes);
        this.defaultPartyIdTypes = new ArrayList<String>(defaultPartyIdTypes);
    }

    private void initEbXml20ServiceConfigs() {
        TreeSet<EbXml20ServiceConfig> ebXml20ServiceConfigs = new TreeSet<EbXml20ServiceConfig>();
        try {
            this.readEbXml20ServiceConfigs(ebXml20ServiceConfigs, CUSTOM_EBXML20_SERVICES_PROPERTIES_FILE);
        }
        catch (IOException e) {
            LOG.debug((Object)"using default ebXML2 service configuration.");
            ebXml20ServiceConfigs.add(this.DEFAULT_SIGNAL_SERVICE);
            ebXml20ServiceConfigs.add(this.DEFAULT_MESSAGE_SERVICE);
            List<String> propertiesFileNames = this.getManifestAttributeValue(MANIFEST_ATTRIBUTE_EBXML20_SERVICES_PROPERTIES_FILE);
            for (String propertiesFileName : propertiesFileNames) {
                try {
                    this.readEbXml20ServiceConfigs(ebXml20ServiceConfigs, propertiesFileName);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Could not read the properties file '" + propertiesFileName + "'."));
                }
            }
        }
        this.ebXml20ServiceConfigs = new ArrayList<EbXml20ServiceConfig>(ebXml20ServiceConfigs);
    }

    private void readEbXml20ServiceConfigs(SortedSet<EbXml20ServiceConfig> ebXml20ServiceConfigs, String propertiesFileName) throws IOException {
        Map.Entry<URI, InputStream> resourceAsStream = this.configResourceService.getResource(propertiesFileName);
        try (InputStream inputStream = resourceAsStream.getValue();){
            LOG.info((Object)("Found EbXML 2.0 services configuration file '" + propertiesFileName + "': " + String.valueOf(resourceAsStream.getKey())));
            Properties properties = new Properties();
            properties.load(inputStream);
            int i = 1;
            while (true) {
                String handler = properties.getProperty("ponton.ebxml2." + i + ".handler");
                String service = properties.getProperty("ponton.ebxml2." + i + ".service", "*");
                String type = properties.getProperty("ponton.ebxml2." + i + ".type", "*");
                String action = properties.getProperty("ponton.ebxml2." + i + ".action", "*");
                if (handler == null) {
                    break;
                }
                EbXml20ServiceConfig ebXml20ServiceConfig = new EbXml20ServiceConfig(service, type, action, handler);
                if (ebXml20ServiceConfigs.add(ebXml20ServiceConfig)) {
                    LOG.info((Object)("Added EbXML 2.0 service configuration: " + String.valueOf(ebXml20ServiceConfig)));
                } else {
                    LOG.warn((Object)("Ignored duplicate EbXML 2.0 service configuration: " + String.valueOf(ebXml20ServiceConfig) + ". Action, service and type is unique."));
                }
                ++i;
            }
        }
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private void readPipelines(Map<String, String[]> inboundPipes, Map<String, String[]> outboundPipes, String propertiesFileName) throws IOException {
        Map.Entry<URI, InputStream> resourceAsStream = this.configResourceService.getResource(propertiesFileName);
        try (InputStream inputStream = resourceAsStream.getValue();){
            LOG.info((Object)("Found pipeline configuration file '" + propertiesFileName + "': " + String.valueOf(resourceAsStream.getKey())));
            Properties properties = new Properties();
            properties.load(inputStream);
            int i = 1;
            while (true) {
                String pipelineId = properties.getProperty("messenger.pipeline." + i + ".id");
                String pipelineInbound = properties.getProperty("messenger.pipeline." + i + ".inbound");
                String pipelineOutbound = properties.getProperty("messenger.pipeline." + i + ".outbound");
                if (pipelineId == null) {
                    break;
                }
                if (!(this.isBlank(pipelineId) || this.isBlank(pipelineInbound) || this.isBlank(pipelineOutbound))) {
                    if (inboundPipes.containsKey(pipelineId) || outboundPipes.containsKey(pipelineId)) {
                        LOG.warn((Object)("Ignored duplicate definition of the pipeline '" + pipelineId + "'."));
                    } else {
                        inboundPipes.put(pipelineId, pipelineInbound.split(";"));
                        outboundPipes.put(pipelineId, pipelineOutbound.split(";"));
                    }
                }
                ++i;
            }
        }
    }

    private void readPartyIdTypes(SortedSet<String> partyIdTypes, SortedSet<String> defaultPartyIdTypes, String propertiesFileName) throws IOException {
        Map.Entry<URI, InputStream> resourceAsStream = this.configResourceService.getResource(propertiesFileName);
        try (InputStream inputStream = resourceAsStream.getValue();){
            LOG.info((Object)("Found partyid configuration file '" + propertiesFileName + "': " + String.valueOf(resourceAsStream.getKey())));
            Properties properties = new Properties();
            properties.load(inputStream);
            for (String key : properties.stringPropertyNames()) {
                if (key.startsWith("partyid.type.")) {
                    partyIdTypes.add(properties.getProperty(key));
                    continue;
                }
                if (!key.startsWith("partyid.default")) continue;
                defaultPartyIdTypes.add(properties.getProperty(key));
            }
        }
    }

    private List<String> getManifestAttributeValue(String attributeName) {
        ArrayList<String> values = new ArrayList<String>();
        File addonConfigFolder = this.serverConfigBean.getAddonsConfigsFolder();
        if (addonConfigFolder.exists()) {
            File[] jarFiles;
            for (File configJar : jarFiles = addonConfigFolder.listFiles((dir, name) -> addonConfigFolder.equals(dir) && name.toLowerCase().endsWith(".jar"))) {
                try (JarFile jarFile = new JarFile(configJar);){
                    Attributes attributes;
                    String attributeValue;
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null || (attributeValue = (attributes = manifest.getMainAttributes()).getValue(attributeName)) == null) continue;
                    values.add(attributeValue);
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not read manifest of the file '" + String.valueOf(configJar) + "'."), (Throwable)e);
                }
            }
        }
        return values;
    }

    public List<AddOn> getAddOns() {
        return Collections.unmodifiableList(this.configNames);
    }

    public String getDefaultAgreementTemplateId() {
        return this.defaultAgreementTemplateId;
    }

    public AgreementTemplateBundle getAgreementTemplateBundle(String agreementTemplateId) {
        AgreementTemplateBundle agreementTemplateBundle = this.agreementTemplateBundles.get(agreementTemplateId);
        if (Objects.isNull(agreementTemplateBundle)) {
            throw new IllegalArgumentException("No agreement template found for id '" + agreementTemplateId + "'");
        }
        return agreementTemplateBundle;
    }

    public SortedSet<String> getAgreementTemplateIds() {
        return new TreeSet<String>(this.agreementTemplateBundles.keySet());
    }

    public List<AgreementTemplateListItemDto> getAgreementTemplateList() {
        this.checkForAgreementTemplatesRefresh();
        return this.agreementTemplateList;
    }

    public synchronized void checkForAgreementTemplatesRefresh() {
        Long timestampByConfigType = this.messengerConfigDAO.getTimestampAsLongByConfigType("agreement_templates");
        boolean isNewer = this.agreementTemplateList.stream().filter(AgreementTemplateListItemDto::getIsCustom).anyMatch(item -> item.getLastModified().toInstant().toEpochMilli() < timestampByConfigType);
        if (isNewer) {
            this.refreshAgreementTemplates();
        }
    }

    public void refreshAgreementTemplates() {
        LOG.info((Object)"Agreement templates have been updated. Refreshing the list.");
        this.agreementTemplateBundles.clear();
        this.agreementTemplateList.clear();
        this.initAgreementTemplateIds();
    }

    public void addTemplateToList(String agreementTemplateId, boolean isPublic) {
        AgreementTemplateListItemDto newTemplate = new AgreementTemplateListItemDto().setAgreementTemplateId(agreementTemplateId).setIsPublic(isPublic).setIsCustom(true).setLastModified(System.currentTimeMillis());
        for (int i = 0; i < this.agreementTemplateList.size(); ++i) {
            AgreementTemplateListItemDto existingTemplate = this.agreementTemplateList.get(i);
            if (!existingTemplate.getAgreementTemplateId().equals(agreementTemplateId) || existingTemplate.getIsPublic() != isPublic) continue;
            this.agreementTemplateList.set(i, newTemplate);
            return;
        }
        this.agreementTemplateList.add(newTemplate);
    }

    public void addDefaultTemplateToList(String agreementTemplateId, Boolean isPublic, FileTime lastModified) {
        AgreementTemplateListItemDto defaultTemplateDto = new AgreementTemplateListItemDto().setAgreementTemplateId(agreementTemplateId).setIsPublic(isPublic).setIsCustom(false).setLastModified(lastModified.toMillis());
        this.agreementTemplateList.add(defaultTemplateDto);
    }

    public AgreementTemplateListItemDto getAgreementTemplateListItem(String agreementTemplateId, Boolean isPublic) {
        return this.agreementTemplateList.stream().filter(dto -> dto.getAgreementTemplateId().equals(agreementTemplateId)).filter(dto -> dto.getIsPublic().equals(isPublic)).findFirst().orElse(null);
    }

    private void initAgreementTemplateIds() {
        this.agreementTemplateBundles = this.findAllTemplates();
        this.defaultAgreementTemplateId = this.determineDefaultTemplateId();
        try {
            this.createAgreementTemplateSamples();
        }
        catch (IOException e) {
            LOG.error((Object)"Could not create samples for default agreement templates.", (Throwable)e);
        }
    }

    public void removeAgreementTemplateListItem(String agreementTemplateId, Boolean isPublic) {
        this.agreementTemplateList.removeIf(dto -> dto.getAgreementTemplateId().equals(agreementTemplateId) && dto.getIsPublic().equals(isPublic));
    }

    public void removeAgreementTemplateBundle(String agreementTemplateId) {
        this.agreementTemplateBundles.remove(agreementTemplateId);
    }

    private void createAgreementTemplateSamples() throws IOException {
        Path agreementTemplatesFolder = Path.of(this.serverConfigBean.getConfigFolder().getAbsolutePath(), AGREEMENT_TEMPLATES);
        if (Files.notExists(agreementTemplatesFolder, new LinkOption[0])) {
            Files.createDirectory(agreementTemplatesFolder, new FileAttribute[0]);
        }
        this.agreementTemplateBundles.forEach((agreementTemplateId, agreementTemplateBundle) -> {
            this.configResourceService.getResources(agreementTemplateBundle.getAgreementTemplate()).entrySet().forEach(url -> this.createSampleFor((String)agreementTemplateId, (Map.Entry<URI, InputStream>)url, this.getSamplePath(agreementTemplateBundle.getAgreementTemplate())));
            this.configResourceService.getResources(agreementTemplateBundle.getAgreementPrivateTemplate()).entrySet().forEach(url -> this.createSampleFor((String)agreementTemplateId, (Map.Entry<URI, InputStream>)url, this.getSamplePath(agreementTemplateBundle.getAgreementPrivateTemplate())));
        });
    }

    private void createSampleFor(String agreementTemplateId, Map.Entry<URI, InputStream> entry, Path samplePath) {
        block9: {
            try {
                if (!"jar".equalsIgnoreCase(entry.getKey().toURL().getProtocol())) break block9;
                URLConnection urlConnection = entry.getKey().toURL().openConnection();
                FileTime originLasModified = FileTime.fromMillis(urlConnection.getLastModified());
                if (Files.exists(samplePath, new LinkOption[0]) && Files.getLastModifiedTime(samplePath, new LinkOption[0]).compareTo(originLasModified) == 0) {
                    return;
                }
                try (InputStream inputStream = entry.getValue();){
                    Files.write(samplePath, inputStream.readAllBytes(), new OpenOption[0]);
                }
                Files.setLastModifiedTime(samplePath, originLasModified);
            }
            catch (IOException e) {
                LOG.error((Object)("Could not store sample for agreement template '" + agreementTemplateId + "'."), (Throwable)e);
            }
        }
    }

    private Path getSamplePath(String relativePath) {
        return Paths.get(this.serverConfigBean.getConfigFolder().getAbsolutePath(), relativePath.substring(0, relativePath.length() - ".vm".length()) + "_sample.vm");
    }

    private String determineDefaultTemplateId() {
        String customTemplateId = this.messengerProperties.getProperty(PROPERTY_DEFAULT_AGREEMENT_TEMPLATE_ID);
        if (StringUtils.isNotBlank((CharSequence)customTemplateId)) {
            return customTemplateId;
        }
        List<String> defaultAgreementTemplateIds = this.getManifestAttributeValue(MANIFEST_ATTRIBUTE_DEFAULT_AGREEMENT_TEMPLATE_ID);
        switch (defaultAgreementTemplateIds.size()) {
            case 0: {
                break;
            }
            case 1: {
                return defaultAgreementTemplateIds.getFirst();
            }
            default: {
                LOG.info((Object)"Multiple definition of default agreement template id found in AddOns. Using the last one.");
                return defaultAgreementTemplateIds.get(defaultAgreementTemplateIds.size() - 1);
            }
        }
        return "EbXml20";
    }

    private Map<String, AgreementTemplateBundle> findAllTemplates() {
        HashMap<String, AgreementTemplateBundle> result = new HashMap<String, AgreementTemplateBundle>();
        Map<URI, InputStream> agreementTemplates = this.configResourceService.getResources("agreementTemplates/*_public.vm");
        agreementTemplates.entrySet().forEach(templateUrl -> {
            LOG.debug((Object)("Found the following agreement template file: " + String.valueOf(templateUrl)));
            String id = null;
            try {
                String filePath = ((URI)templateUrl.getKey()).toURL().getFile();
                Matcher matcher = AGREEMENT_TEMPLATE_PATTERN.matcher(filePath);
                if (matcher.find()) {
                    id = matcher.group(2);
                    String agreementTemplate = String.format("agreementTemplates/%s_public.vm", id);
                    String agreementPrivateTemplate = String.format("agreementTemplates/%s_private.vm", id);
                    this.configResourceService.getResource(agreementPrivateTemplate);
                    result.put(id, new AgreementTemplateBundle(id, agreementTemplate, agreementPrivateTemplate));
                    LOG.info((Object)("Found agreement template '" + id + "'."));
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("No agreement private template found for id '" + id + "': " + String.valueOf(e)));
            }
        });
        this.buildAgreementTemplateListItems(result);
        return result;
    }

    private void buildAgreementTemplateListItems(Map<String, AgreementTemplateBundle> agreementTemplateBundles) {
        String configPath = this.serverConfigBean.getConfigFolder().getAbsolutePath();
        agreementTemplateBundles.forEach((id, agreementTemplateBundle) -> {
            try {
                Map.Entry<URI, InputStream> publicUrl = this.configResourceService.getResource(agreementTemplateBundle.getAgreementTemplate());
                Map.Entry<URI, InputStream> privateUrl = this.configResourceService.getResource(agreementTemplateBundle.getAgreementPrivateTemplate());
                Path publicFilePath = Paths.get(configPath, agreementTemplateBundle.getAgreementTemplate());
                Path privateFilePath = Paths.get(configPath, agreementTemplateBundle.getAgreementPrivateTemplate());
                Boolean publicIsCustom = Files.exists(publicFilePath, new LinkOption[0]);
                Boolean privateIsCustom = Files.exists(privateFilePath, new LinkOption[0]);
                FileTime publicFileLastModified = this.getFileLastModified(publicUrl.getKey().toURL(), publicIsCustom);
                FileTime privateFileLastModified = this.getFileLastModified(privateUrl.getKey().toURL(), privateIsCustom);
                this.agreementTemplateList.add(this.createAgreementTemplateListItemDto((String)id, true, publicIsCustom, publicFileLastModified));
                this.agreementTemplateList.add(this.createAgreementTemplateListItemDto((String)id, false, privateIsCustom, privateFileLastModified));
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not build agreement template list item for id '" + id + "': " + String.valueOf(e)));
            }
        });
    }

    public FileTime getFileLastModified(URL url, Boolean isCustom) throws IOException {
        if (isCustom.booleanValue()) {
            return FileTime.fromMillis(this.messengerConfigDAO.getTimestampAsLongByConfigType("agreement_templates"));
        }
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            URLConnection urlConnection = url.openConnection();
            return FileTime.fromMillis(urlConnection.getLastModified());
        }
        try {
            return Files.getLastModifiedTime(Paths.get(url.toURI()), new LinkOption[0]);
        }
        catch (URISyntaxException e) {
            LOG.info((Object)"Could not convert url to URI", (Throwable)e);
            return null;
        }
    }

    private AgreementTemplateListItemDto createAgreementTemplateListItemDto(String id, Boolean isPublic, Boolean isCustom, FileTime lastModified) {
        AgreementTemplateListItemDto dto = new AgreementTemplateListItemDto();
        dto.setAgreementTemplateId(id);
        dto.setIsPublic(isPublic);
        dto.setIsCustom(isCustom);
        dto.setLastModified(lastModified != null ? lastModified.toMillis() : 0L);
        return dto;
    }
}

