/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

public enum DatabaseType {
    ORACLE("Oracle"),
    MYSQL("MySQL"),
    POSTGRESQL("PostgreSQL"),
    MSSQL("Microsoft SQL Server"),
    HSQL("HSQL Database Engine");

    private final String databaseName;

    private DatabaseType(String databaseName) {
        this.databaseName = databaseName;
    }

    public static DatabaseType create(String databaseProductName) {
        for (DatabaseType db : DatabaseType.values()) {
            if (!db.databaseName.equals(databaseProductName)) continue;
            return db;
        }
        throw new IllegalArgumentException("database type not supported: " + databaseProductName);
    }
}

