/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.config;

import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.CertificateReader;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;

public class ActivationKeystoreBean {
    private final PontonKeystore pontonKeystore;

    public ActivationKeystoreBean(IServerConfigBean serverConfig, CertificateReader certificate, ReferenceDateTask referenceDateTask) throws Exception {
        File activationKeystoreFile = new File(serverConfig.getConfigFolder(), "keystore-activation");
        if (activationKeystoreFile.exists()) {
            Files.delete(activationKeystoreFile.toPath());
        }
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("keystore-activation");){
            if (resourceAsStream == null) {
                throw new IOException("keystore-activation not found");
            }
            byte[] bytes = resourceAsStream.readAllBytes();
            this.pontonKeystore = new PontonKeystore(bytes, "24@z!!n9mh5@3_i$25gh9_e$e9sw5@@@g@r41!!$v_yg@8x7qi@um35612$@$6", "UBER", certificate, referenceDateTask::getReferenceDate, keystoreData -> {});
        }
    }

    public PontonKeystore getKeystore() {
        return this.pontonKeystore;
    }
}

