/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.cluster;

import de.ponton.xmlpipe.queue.InboundQueueTimeoutCheckTask;
import de.ponton.xmlpipe.queue.OutboundQueueExpiredMessagesTask;
import de.pontonconsulting.xmlpipe.adapter.pingall.PingAllThread;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.listener.ListenerCertificateRevocationTask;
import de.pontonconsulting.xmlpipe.listener.MailListener;
import de.pontonconsulting.xmlpipe.messenger.ArchiveCleanupTask;
import de.pontonconsulting.xmlpipe.messenger.IMaintenanceChangeListener;
import de.pontonconsulting.xmlpipe.messenger.IReferenceDateListener;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.adapter.IPartnerUpdateListener;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveQueueTimeoutCheckTask;
import de.pontonconsulting.xmlpipe.messenger.database.DBCleanupTask;
import de.pontonconsulting.xmlpipe.messenger.database.GlobalTaskType;
import de.pontonconsulting.xmlpipe.messenger.database.tables.GlobalTaskDAO;
import de.pontonconsulting.xmlpipe.registry.RegistryException;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileCleanUp;
import de.pontonconsulting.xmlpipe.registry.RegistryProfileUpdater;
import de.pontonconsulting.xmlpipe.security.CertificateExpireCheckTask;
import de.pontonconsulting.xmlpipe.security.RemotePartnerCertificateTrustManager;
import de.pontonconsulting.xmlpipe.security.ServerCertificateRevocationService;
import de.pontonconsulting.xmlpipe.security.certificate.SubCAUpdateTask;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBException;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationListener;

public class GlobalTaskManager
implements IReferenceDateListener,
IPartnerUpdateListener,
IMaintenanceChangeListener,
ApplicationListener<ReloadConfiguration> {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.GlobalTaskManager");
    private static final long INITIAL_DELAY_10_SECONDS = 10L;
    public static final long INTERVAL_60_SECONDS = 60L;
    static final int INTERVAL_DAILY_SECONDS = 86400;
    static final int TASK_DISABLED = -1;
    static final int INTERVAL_30_SECONDS = 30;
    private final GlobalTaskDAO globalTaskDAO;
    private final ReferenceDateTask referenceDateTask;
    private final MessengerConfig messengerConfig;
    private final ScheduledThreadPoolExecutor scheduler;
    private final Profiles profiles;
    private final PingAllThread pingAllThread;
    private final ServerCertificateRevocationService serverCertificateRevocationService;
    private final SubCAUpdateTask subCAUpdateTask;
    private final RegistryProfileCleanUp registryProfileCleanUp;
    private final RegistryProfileUpdater registryProfileUpdater;
    private final MailListener mailListener;
    private final ArchiveCleanupTask archiveCleanupTask;
    private final DBCleanupTask databaseCleanupTask;
    private final RemotePartnerCertificateTrustManager remotePartnerCertificateTrustManager;
    private final CertificateExpireCheckTask certificateExpireCheckTask;
    private final OutboundQueueExpiredMessagesTask outboundQueueExpiredMessagesTask;
    private final InboundQueueTimeoutCheckTask inboundQueueTimeoutCheckTask;
    private final ArchiveQueueTimeoutCheckTask archiveQueueTimeoutCheckTask;
    private final ListenerCertificateRevocationTask listenerCertificateRevocationTask;
    private final MaintenanceManager maintenanceManager;
    private ScheduledFuture<?> mainRunTask;
    private final Map<GlobalTaskType, ScheduledTask> scheduledTasks = new ConcurrentHashMap<GlobalTaskType, ScheduledTask>();
    private final Map<GlobalTaskType, ReentrantLock> lockObjects = new ConcurrentHashMap<GlobalTaskType, ReentrantLock>();
    private final AtomicLong referenceDateOffset = new AtomicLong();
    private Integer currentResponsibleMessengerId = null;
    private final AtomicBoolean referenceDateOffsetChanged = new AtomicBoolean(false);

    public GlobalTaskManager(GlobalTaskDAO globalTaskDAO, ReferenceDateTask referenceDateTask, MessengerConfig messengerConfig, ScheduledThreadPoolExecutor scheduler, Profiles profiles, PingAllThread pingAllThread, ServerCertificateRevocationService serverCertificateRevocationService, SubCAUpdateTask subCAUpdateTask, RegistryProfileCleanUp registryProfileCleanUp, RegistryProfileUpdater registryProfileUpdater, MailListener mailListener, ArchiveCleanupTask archiveCleanupTask, DBCleanupTask databaseCleanupTask, RemotePartnerCertificateTrustManager remotePartnerCertificateTrustManager, CertificateExpireCheckTask certificateExpireCheckTask, InboundQueueTimeoutCheckTask inboundQueueTimeoutCheckTask, OutboundQueueExpiredMessagesTask outboundQueueExpiredMessagesTask, ArchiveQueueTimeoutCheckTask archiveQueueTimeoutCheckTask, ListenerCertificateRevocationTask listenerCertificateRevocationTask, MaintenanceManager maintenanceManager) {
        this.globalTaskDAO = globalTaskDAO;
        this.referenceDateTask = referenceDateTask;
        this.archiveQueueTimeoutCheckTask = archiveQueueTimeoutCheckTask;
        this.referenceDateOffset.set(referenceDateTask.getOffset());
        this.messengerConfig = messengerConfig;
        this.profiles = profiles;
        this.pingAllThread = pingAllThread;
        this.scheduler = scheduler;
        this.serverCertificateRevocationService = serverCertificateRevocationService;
        this.subCAUpdateTask = subCAUpdateTask;
        this.registryProfileCleanUp = registryProfileCleanUp;
        this.registryProfileUpdater = registryProfileUpdater;
        this.mailListener = mailListener;
        this.archiveCleanupTask = archiveCleanupTask;
        this.databaseCleanupTask = databaseCleanupTask;
        this.remotePartnerCertificateTrustManager = remotePartnerCertificateTrustManager;
        this.certificateExpireCheckTask = certificateExpireCheckTask;
        this.inboundQueueTimeoutCheckTask = inboundQueueTimeoutCheckTask;
        this.outboundQueueExpiredMessagesTask = outboundQueueExpiredMessagesTask;
        this.listenerCertificateRevocationTask = listenerCertificateRevocationTask;
        this.maintenanceManager = maintenanceManager;
        for (GlobalTaskType globalTaskType : GlobalTaskType.values()) {
            this.lockObjects.put(globalTaskType, new ReentrantLock());
        }
    }

    public void init() {
        LOG.debug("Initialize");
        this.mainRunTask = this.scheduler.scheduleAtFixedRate(this::run, 10L, 60L, TimeUnit.SECONDS);
        this.referenceDateTask.addReferenceDateListener(this);
        this.profiles.addPartnerEventListener(this);
        this.maintenanceManager.addMaintenanceChangeListener(this);
    }

    public synchronized void run() {
        long start = System.currentTimeMillis();
        LOG.debug("Starting MainTask run");
        try {
            Optional<GlobalTaskDAO.MessengerInfo> globalTasksMessengerInfo = this.globalTaskDAO.getGlobalTasksMessengerId();
            if (globalTasksMessengerInfo.isEmpty()) {
                this.currentResponsibleMessengerId = null;
                this.scheduleTasksIfThisMessengerIsAssigned(null);
            } else if (this.isResponsibleMessengerDown(globalTasksMessengerInfo.get())) {
                this.scheduleTasksIfThisMessengerIsAssigned(globalTasksMessengerInfo.get().messengerId());
            } else {
                this.checkIfThisMessengerIsGlobalTasksMessenger(globalTasksMessengerInfo.get());
            }
            this.referenceDateOffsetChanged.set(false);
            LOG.debug("finished MainTask run (after {}s)", (Object)((System.currentTimeMillis() - start) / 1000L));
        }
        catch (RuntimeException e) {
            LOG.error("MainTask run failed, due to {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void scheduleTasksIfThisMessengerIsAssigned(Integer oldMessengerId) {
        if (this.globalTaskDAO.assignGlobalTasksToThisMessenger(oldMessengerId, this.messengerConfig.getMessengerId())) {
            this.syncScheduledTasks();
        } else {
            this.currentResponsibleMessengerId = null;
        }
    }

    private boolean isResponsibleMessengerDown(GlobalTaskDAO.MessengerInfo messengerInfo) {
        if (messengerInfo.lastHeartBeat().isBefore(this.referenceDateTask.getReferenceOffsetDateTime().minusMinutes(3L))) {
            LOG.warn("Messenger assigned to run global tasks is not active anymore ({})", (Object)messengerInfo);
            return true;
        }
        return false;
    }

    private void checkIfThisMessengerIsGlobalTasksMessenger(GlobalTaskDAO.MessengerInfo messengerInfo) {
        if (messengerInfo.messengerId().equals(this.messengerConfig.getMessengerId())) {
            this.syncScheduledTasks();
        } else {
            this.currentResponsibleMessengerId = messengerInfo.messengerId();
            LOG.debug("This messenger (messengerId={}) is NOT assigned to run global tasks. Responsible Messenger {}", (Object)this.messengerConfig.getMessengerId(), (Object)messengerInfo);
            for (ScheduledTask scheduledTask : this.scheduledTasks.values()) {
                scheduledTask.task.cancel(true);
                this.scheduledTasks.remove((Object)scheduledTask.type);
                LOG.debug("Canceled scheduled global task '{}'", (Object)scheduledTask.type);
            }
            this.scheduler.purge();
        }
    }

    void syncScheduledTasks() {
        this.currentResponsibleMessengerId = this.messengerConfig.getMessengerId();
        LOG.debug("This messenger (messengerId={}) is assigned to run global tasks", (Object)this.messengerConfig.getMessengerId());
        for (GlobalTaskType type : GlobalTaskType.values()) {
            this.syncScheduledTask(type);
        }
    }

    void syncScheduledTask(GlobalTaskType type) {
        ScheduledTask scheduledTask = this.scheduledTasks.get((Object)type);
        if (Objects.isNull(scheduledTask)) {
            this.scheduleTask(type);
        } else {
            this.rescheduleTaskIfChanged(type, scheduledTask);
        }
    }

    private void rescheduleTaskIfChanged(GlobalTaskType type, ScheduledTask scheduledTask) {
        int intervalNew = this.getInterval(type);
        LocalTime executionTimeNew = this.getNextExecutionTime(type);
        if (scheduledTask.interval != intervalNew || executionTimeNew != null && !executionTimeNew.equals(scheduledTask.executionTime) || this.referenceDateOffsetChanged.get()) {
            LOG.debug("Interval or executionTime of global task '{}' changed ({}=>{} / {}=>{})", (Object)type, (Object)scheduledTask.interval, (Object)intervalNew, (Object)scheduledTask.executionTime, (Object)executionTimeNew);
            scheduledTask.task.cancel(true);
            this.scheduledTasks.remove((Object)type);
            this.scheduleTask(type);
        } else {
            LOG.trace("Interval and executionTime of scheduled global task '{}' didn't change", (Object)type);
        }
    }

    private void scheduleTask(GlobalTaskType type) {
        int interval = this.getInterval(type);
        if (interval == -1) {
            LOG.debug("Global task '{}' is disabled", (Object)type);
            return;
        }
        LocalTime executionTime = this.getNextExecutionTime(type);
        long delay = this.getDelay(executionTime);
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(this.executeGlobalTask(type), delay, interval, TimeUnit.SECONDS);
        this.scheduledTasks.put(type, new ScheduledTask(type, executionTime, interval, future));
        LOG.debug("Scheduled global task '{}' (nextExecution={} / delay={} / interval={})", (Object)type, (Object)executionTime, (Object)delay, (Object)interval);
    }

    int getInterval(GlobalTaskType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case GlobalTaskType.PING_ALL -> {
                int var2_3;
                try {
                    if (this.messengerConfig.isPingAllEnabled() && this.messengerConfig.getPingAllInterval() > 0) {
                        int var2_2;
                        yield var2_2 = this.messengerConfig.getPingAllInterval() * 60;
                    }
                }
                catch (JAXBException e) {
                    LOG.error("Failed to parse ping all interval: {}", (Object)e.getMessage());
                }
                yield var2_3 = -1;
            }
            case GlobalTaskType.PARTNER_REGISTRY_SYNC -> {
                int var2_5;
                try {
                    if (this.messengerConfig.isRegistryDownloadEnabled()) {
                        int var2_4;
                        yield var2_4 = this.messengerConfig.getRegistryDownloadInterval() * 60 * 60;
                    }
                }
                catch (JAXBException e) {
                    LOG.error("Failed to get PartnerRegistrySyncInterval from messenger config: {}", (Object)e.getMessage());
                }
                yield var2_5 = -1;
            }
            case GlobalTaskType.MAIL_LISTENER_POLLING -> {
                int var2_7;
                try {
                    if (this.messengerConfig.getMailPollInterval() > 0) {
                        int var2_6;
                        yield var2_6 = this.messengerConfig.getMailPollInterval();
                    }
                }
                catch (JAXBException e) {
                    LOG.error("Failed to check MailPollInterval from messenger config: {}", (Object)e.getMessage());
                }
                yield var2_7 = -1;
            }
            case GlobalTaskType.REMOTE_PARTNER_CERT_CHECK -> {
                int var2_9;
                if (this.messengerConfig.isPartnerCertificateRevocationCheckEnabled()) {
                    int var2_8;
                    yield var2_8 = 86400;
                }
                yield var2_9 = -1;
            }
            case GlobalTaskType.LISTENER_CERT_REVOCATION_CHECK -> {
                int var2_11;
                try {
                    if (this.messengerConfig.isListenerEnabled() && this.messengerConfig.isPartnerCertificateRevocationCheckEnabled()) {
                        int var2_10;
                        yield var2_10 = 86400;
                    }
                }
                catch (JAXBException e) {
                    LOG.error("Failed to get listenerEnabled flag from messenger config: {}", (Object)e.getMessage());
                }
                yield var2_11 = -1;
            }
            case GlobalTaskType.TLS_CERTIFICATE_REVOCATION_CHECK -> {
                int var2_13;
                try {
                    if (this.messengerConfig.isSSLCertificateCheck()) {
                        int var2_12;
                        yield var2_12 = 86400;
                    }
                }
                catch (JAXBException e) {
                    LOG.error("Failed to get sslCertificateCheck flag from messenger config: {}", (Object)e.getMessage());
                }
                yield var2_13 = -1;
            }
            case GlobalTaskType.ARCHIVE_CLEANUP -> {
                int var2_15;
                try {
                    if (this.messengerConfig.isDeleteArchive()) {
                        int var2_14;
                        yield var2_14 = 86400;
                    }
                }
                catch (JAXBException e) {
                    LOG.error("Failed to get ArchiveCleanup flag from messenger config: {}", (Object)e.getMessage());
                }
                yield var2_15 = -1;
            }
            case GlobalTaskType.DATABASE_CLEANUP -> {
                int var2_17;
                try {
                    if (this.messengerConfig.isDeleteDatabase()) {
                        int var2_16;
                        yield var2_16 = 86400;
                    }
                }
                catch (JAXBException e) {
                    LOG.error("Failed to get DatabaseCleanup flag from messenger config: {}", (Object)e.getMessage());
                }
                yield var2_17 = -1;
            }
            case GlobalTaskType.SUB_CA_UPDATE -> {
                int var2_19;
                if (this.subCAUpdateTask.isEnabled()) {
                    int var2_18;
                    yield var2_18 = 86400;
                }
                yield var2_19 = -1;
            }
            case GlobalTaskType.INBOUND_QUEUE_TIMEOUT_CHECK, GlobalTaskType.OUTBOUND_QUEUE_EXPIRY_CHECK, GlobalTaskType.ARCHIVE_QUEUE_EXPIRY_CHECK -> {
                int var2_20;
                yield var2_20 = 30;
            }
            case GlobalTaskType.CERTIFICATE_EXPIRY_CHECK -> {
                int var2_21;
                yield var2_21 = 86400;
            }
        };
    }

    LocalTime getNextExecutionTime(GlobalTaskType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case GlobalTaskType.ARCHIVE_CLEANUP -> {
                try {
                    LocalTime var2_2;
                    yield var2_2 = this.getNextExecutionTime(this.messengerConfig.getArchiveCleanupTime()).toLocalTime();
                }
                catch (JAXBException e) {
                    LOG.warn("Failed to get ArchiveCleanupTime from messenger config, fallback to NOW: {}", (Object)e.getMessage());
                    Object var2_3 = null;
                    yield var2_3;
                }
            }
            case GlobalTaskType.DATABASE_CLEANUP -> {
                try {
                    LocalTime var2_4;
                    yield var2_4 = this.getNextExecutionTime(this.messengerConfig.getDatabaseCleanupTime()).toLocalTime();
                }
                catch (JAXBException e) {
                    LOG.warn("Failed to get DatabaseCleanupTime from messenger config, fallback to NOW: {}", (Object)e.getMessage());
                    Object var2_5 = null;
                    yield var2_5;
                }
            }
            case GlobalTaskType.PING_ALL, GlobalTaskType.PARTNER_REGISTRY_SYNC, GlobalTaskType.MAIL_LISTENER_POLLING, GlobalTaskType.REMOTE_PARTNER_CERT_CHECK, GlobalTaskType.LISTENER_CERT_REVOCATION_CHECK, GlobalTaskType.TLS_CERTIFICATE_REVOCATION_CHECK, GlobalTaskType.SUB_CA_UPDATE, GlobalTaskType.INBOUND_QUEUE_TIMEOUT_CHECK, GlobalTaskType.OUTBOUND_QUEUE_EXPIRY_CHECK, GlobalTaskType.ARCHIVE_QUEUE_EXPIRY_CHECK, GlobalTaskType.CERTIFICATE_EXPIRY_CHECK -> {
                LocalTime var2_6;
                yield var2_6 = null;
            }
        };
    }

    OffsetDateTime getNextExecutionTime(XMLGregorianCalendar time) {
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        OffsetDateTime nextExecutionTime = now.withHour(time.getHour()).withMinute(time.getMinute()).withSecond(time.getSecond());
        if (nextExecutionTime.isBefore(now)) {
            nextExecutionTime = nextExecutionTime.plusDays(1L);
        }
        return nextExecutionTime.truncatedTo(ChronoUnit.SECONDS).withNano(0);
    }

    private long getDelay(LocalTime time) {
        if (Objects.isNull(time)) {
            return 0L;
        }
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        OffsetDateTime nextExecutionTime = now.withHour(time.getHour()).withMinute(time.getMinute()).withSecond(time.getSecond());
        if (nextExecutionTime.isBefore(now)) {
            nextExecutionTime = nextExecutionTime.plusDays(1L);
        }
        return ChronoUnit.SECONDS.between(now, nextExecutionTime);
    }

    Runnable executeGlobalTask(GlobalTaskType type) {
        return () -> {
            long startTime = System.currentTimeMillis();
            ReentrantLock lock = this.lockObjects.get((Object)type);
            if (lock.isLocked()) {
                LOG.warn("Global task '{}' is still running. skipping execution.", (Object)type);
                return;
            }
            lock.lock();
            LOG.debug("Starting global task '{}'", (Object)type);
            try {
                try {
                    switch (type) {
                        case PING_ALL: {
                            this.pingAllThread.pingAllPartners();
                            break;
                        }
                        case TLS_CERTIFICATE_REVOCATION_CHECK: {
                            this.serverCertificateRevocationService.validateCertificates();
                            break;
                        }
                        case SUB_CA_UPDATE: {
                            this.subCAUpdateTask.updateCertificates();
                            break;
                        }
                        case PARTNER_REGISTRY_SYNC: {
                            this.runPartnerRegistrySync();
                            break;
                        }
                        case MAIL_LISTENER_POLLING: {
                            this.mailListener.run();
                            break;
                        }
                        case ARCHIVE_CLEANUP: {
                            this.archiveCleanupTask.call();
                            break;
                        }
                        case DATABASE_CLEANUP: {
                            this.databaseCleanupTask.call();
                            break;
                        }
                        case REMOTE_PARTNER_CERT_CHECK: {
                            this.remotePartnerCertificateTrustManager.validateCertificates();
                            break;
                        }
                        case CERTIFICATE_EXPIRY_CHECK: {
                            this.certificateExpireCheckTask.checkForExpiredPartnerCertificates();
                            break;
                        }
                        case OUTBOUND_QUEUE_EXPIRY_CHECK: {
                            this.outboundQueueExpiredMessagesTask.run();
                            break;
                        }
                        case INBOUND_QUEUE_TIMEOUT_CHECK: {
                            this.inboundQueueTimeoutCheckTask.run();
                            break;
                        }
                        case ARCHIVE_QUEUE_EXPIRY_CHECK: {
                            this.archiveQueueTimeoutCheckTask.run();
                            break;
                        }
                        case LISTENER_CERT_REVOCATION_CHECK: {
                            this.listenerCertificateRevocationTask.checkCertificates();
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Execute of global task '{}' failed due to {}: {}", (Object)type, (Object)e.getClass().getName(), (Object)e.getMessage());
                }
            }
            finally {
                lock.unlock();
            }
            int duration = Long.valueOf((System.currentTimeMillis() - startTime) / 1000L).intValue();
            LOG.debug("Finished global task '{}' (after {}s)", (Object)type, (Object)duration);
        };
    }

    private void runPartnerRegistrySync() throws JAXBException, RegistryException {
        if (this.messengerConfig.isRegistryConfigured()) {
            if (this.messengerConfig.isRegistryCleanUpEnabled()) {
                this.registryProfileCleanUp.cleanUpDeletedProfiles();
            }
            if (this.messengerConfig.isRegistryDownloadEnabled()) {
                RegistryProfileUpdater.SynchronizeResult synchronizeResult = this.registryProfileUpdater.updateProfiles(true);
                LOG.debug("Updated {} from {} remote partners and uploaded {} from {} local partners.", (Object)synchronizeResult.getUpdatedRemoteRegistryPartnerCount(), (Object)synchronizeResult.getRegistryRemotePartnerCount(), (Object)synchronizeResult.getUpdatedLocalRegistryPartnerCount(), (Object)synchronizeResult.getRegistryLocalPartnerCount());
            }
        }
    }

    public void scheduleManualExecution(GlobalTaskType type) {
        LOG.debug("Schedule manual execution of task '{}'", (Object)type);
        this.scheduler.execute(this.executeGlobalTask(type));
    }

    private void scheduleMainTaskRun() {
        this.scheduler.execute(this::run);
    }

    @Nullable
    public Integer getCurrentResponsibleMessengerId() {
        return this.currentResponsibleMessengerId;
    }

    @Override
    public void onChange() {
        long newOffset = this.referenceDateTask.getOffset();
        long oldOffset = this.referenceDateOffset.getAndSet(newOffset);
        LOG.debug("Received ReferenceDateChanged-Event (now={} / newOffset={} / oldOffset={})", (Object)this.referenceDateTask.getReferenceOffsetDateTime(), (Object)newOffset, (Object)oldOffset);
        if (Math.abs(newOffset - oldOffset) > 1000L) {
            this.referenceDateOffsetChanged.set(true);
            this.scheduleMainTaskRun();
        }
    }

    public void onApplicationEvent(ReloadConfiguration reloadConfig) {
        if (reloadConfig.isMessengerConfigChanged()) {
            LOG.debug("Received MessengerConfigChanged event, triggering global task reschedule");
            this.scheduleMainTaskRun();
        }
    }

    @Override
    public void partnerCertificateUpdated(String partnerId, String displayName, boolean isLocalPartner) {
        if (isLocalPartner) {
            LOG.debug("Received PartnerCertificateUpdated-Event, triggering global task reschedule");
            this.scheduleMainTaskRun();
        }
    }

    public void partnerAdded(String partnerId, String displayName, boolean isLocalPartner) {
    }

    public void partnerDeleted(String partnerId, String displayName, boolean isLocalPartner) {
    }

    public void partnerModified(String partnerId, String oldPartnerId, String displayName, boolean isLocalPartner) {
    }

    @Override
    public void onMaintenanceChange(MaintenanceManager maintenanceManager) {
        if (maintenanceManager.isStarted()) {
            LOG.debug("Received maintenanceGlobalTaskManager rescheduled due to Maintenance change");
            this.scheduleMainTaskRun();
        }
    }

    public void shutdown() {
        this.lockObjects.values().forEach(ReentrantLock::lock);
        LOG.debug("shutdown");
        if (Objects.nonNull(this.mainRunTask)) {
            this.mainRunTask.cancel(true);
        }
        this.scheduler.shutdownNow();
    }

    Map<GlobalTaskType, ScheduledTask> getScheduledTasks() {
        return this.scheduledTasks;
    }

    record ScheduledTask(GlobalTaskType type, LocalTime executionTime, int interval, ScheduledFuture<?> task) {
    }
}

