/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.as;

import de.pontonconsulting.xmlpipe.as.ASObject;
import de.pontonconsulting.xmlpipe.as.ASReportException;
import de.pontonconsulting.xmlpipe.as.MDNParameters;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.mail.DispositionNotification;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.ASPackager;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MailDateFormat;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public abstract class ASReport
extends ASObject {
    protected static final String LINE_FEED = "\r\n";
    private boolean _loadedFromMimePart = false;
    private DispositionNotification _mdn;
    private MDNParameters _mdnParams;
    private String _statusDescription;
    private String _reportText;
    private XpMessage _xpMessage;
    protected MessengerLog _messengerLog;
    protected final ReferenceDateTask referenceDateTask;
    private final CertificateUtility _certificateUtility;
    private final SMIMESigner _smimeSigner;

    protected ASReport(CertificateUtility certificateUtility, SMIMESigner smimeSigner, ReferenceDateTask referenceDateTask) {
        this._certificateUtility = certificateUtility;
        this._smimeSigner = smimeSigner;
        this.referenceDateTask = referenceDateTask;
    }

    protected void init() throws ASReportException {
        this._loadedFromMimePart = true;
        try {
            Object contentObject = this._mimePart.getContent();
            if (contentObject instanceof MimeMultipart) {
                MimeMultipart mp = (MimeMultipart)contentObject;
                if (mp.getContentType() != null && mp.getContentType().toLowerCase().startsWith("multipart/signed")) {
                    mp = (MimeMultipart)mp.getBodyPart(0).getContent();
                }
                for (int i = 0; i < mp.getCount(); ++i) {
                    BodyPart bp = mp.getBodyPart(i);
                    Object partContentObject = bp.getContent();
                    if (partContentObject instanceof DispositionNotification) {
                        this._mdn = (DispositionNotification)partContentObject;
                        continue;
                    }
                    if (!(partContentObject instanceof String)) continue;
                    this._reportText = (String)partContentObject;
                }
            }
        }
        catch (Exception e) {
            throw new ASReportException(44001, (Throwable)e);
        }
        if (this._mdn == null) {
            throw new ASReportException(44001, "No MDN found in MimePart");
        }
    }

    public abstract MimeBodyPart getReportMimePart() throws ASReportException;

    @Override
    public abstract String getTransferEncoding();

    protected MimeBodyPart prepareMimePart() throws ASReportException {
        MimeBodyPart mimePart = null;
        MailDateFormat dateFormatter = new MailDateFormat();
        try {
            Object mid;
            mimePart = new MimeBodyPart();
            MimeBodyPart reportPart = new MimeBodyPart();
            reportPart.setContent((Object)this.getReportText(), "text/plain");
            reportPart.addHeader("Content-Type", "text/plain");
            MimeBodyPart dispositionPart = new MimeBodyPart();
            dispositionPart.setContent((Object)this._mdn, "message/disposition-notification");
            dispositionPart.addHeader("Content-Type", "message/disposition-notification");
            MimeMultipart mp = new MimeMultipart("report; report-type=disposition-notification");
            mp.addBodyPart((BodyPart)reportPart);
            mp.addBodyPart((BodyPart)dispositionPart);
            mimePart.setContent((Multipart)mp);
            mimePart.addHeader("Content-Type", mp.getContentType());
            if (this._mdnParams.isSignedReceiptProtocolRequired() || this._mdnParams.getSignedReceiptProtocolValues() != null && this._mdnParams.getSignedReceiptProtocolValues().length > 0 && "pkcs7-signature".equalsIgnoreCase(this._mdnParams.getSignedReceiptProtocolValues()[0])) {
                Communication communication = this._xpMessage.getCommunication();
                SignCertInfo signCertInfo = communication.getPackagingSignKey();
                Certificate[] certificateChain = signCertInfo.getCertificateChain();
                PrivateKey privateKey = signCertInfo.getPrivateKey();
                String signAlg = this.getMDNSignAlgorithm();
                MimeMultipart signedMultiPart = this._smimeSigner.createSignedMimeMessage(mimePart, null, privateKey, certificateChain, signAlg);
                String usingInfoText = this._certificateUtility.toUsingInfoText((X509Certificate)certificateChain[0], "Response signed using " + signAlg + " and certificate ");
                this._messengerLog.log2db(84, this.getXpMessage().getDatabaseId(), usingInfoText);
                mimePart = new MimeBodyPart();
                mimePart.setContent((Multipart)signedMultiPart);
                mimePart.addHeader("Content-Type", signedMultiPart.getContentType());
            }
            if (!((String)(mid = this._messageId)).startsWith("<")) {
                mid = "<" + (String)mid;
            }
            if (!((String)mid).endsWith(">")) {
                mid = (String)mid + ">";
            }
            mimePart.addHeader("Message-Id", (String)mid);
            mimePart.addHeader("Subject", "Reception report");
            mimePart.addHeader("Date", dateFormatter.format(this.referenceDateTask.getReferenceDate()));
        }
        catch (Exception e) {
            throw new ASReportException(44002, (Throwable)e);
        }
        return mimePart;
    }

    private String getSignAlgorithm() {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue("/SignMessage");
            if (!"unsigned".equals(option)) {
                return ASPackager.getSignAlgorithm(option);
            }
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        return "SHA1withRSA";
    }

    private String getMDNSignAlgorithm() {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue("/SmimeMdnSignature");
            if ("Same as business signature".equals(option)) {
                return this.getSignAlgorithm();
            }
            return ASPackager.getSignAlgorithm(option);
        }
        catch (OptionNotFoundException onfe) {
            return this.getSignAlgorithm();
        }
    }

    protected void setStatusDescription(String statusDescription) {
        this._statusDescription = statusDescription;
    }

    protected String getStatusDescription() {
        return this._statusDescription;
    }

    protected String getReportText() {
        return this._reportText;
    }

    protected void setReportText(String reportText) {
        this._reportText = reportText;
    }

    public MDNParameters getMDNParameters() {
        return this._mdnParams;
    }

    protected void setMDNParameters(MDNParameters mdnParameters) {
        this._mdnParams = mdnParameters;
    }

    public DispositionNotification getMDN() {
        return this._mdn;
    }

    protected void setMDN(DispositionNotification mdn) {
        this._mdn = mdn;
    }

    public XpMessage getXpMessage() {
        return this._xpMessage;
    }

    public void setXpMessage(XpMessage xpMessage) {
        this._xpMessage = xpMessage;
    }

    protected boolean isLoadedFromMimePart() {
        return this._loadedFromMimePart;
    }

    public void setMessengerLog(MessengerLog messengerLog) {
        this._messengerLog = messengerLog;
    }

    public static enum DispositionModifierExtension {
        ERROR_AUTH_FAILED("authentication-failed"),
        ERROR_DECOMPRESSION_FAILED("decompression-failed"),
        ERROR_DECRYPTION_FAILED("decryption-failed"),
        ERROR_INTEGRITY_CHECK_FAILED("integrity-check-failed"),
        ERROR_UNEXPECTED_PROCESSING_ERROR("unexpected-processing-error"),
        ERROR_INSUFFICIENT_MESSAGE_SECURITY("insufficient-message-security");

        private final String enumValue;

        private DispositionModifierExtension(String enumValue) {
            this.enumValue = enumValue;
        }

        public String getEnumValue() {
            return this.enumValue;
        }
    }

    public static enum DispositionModifier {
        WARNING("warning"),
        ERROR("error"),
        FAILURE("failure");

        private final String enumValue;

        private DispositionModifier(String enumValue) {
            this.enumValue = enumValue;
        }

        public String getEnumValue() {
            return this.enumValue;
        }
    }

    public static enum DispositionType {
        PROCESSED("processed"),
        FAILED("failed");

        private final String enumValue;

        private DispositionType(String enumValue) {
            this.enumValue = enumValue;
        }

        public String getEnumValue() {
            return this.enumValue;
        }
    }
}

