/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.messagemulticast;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.ExtendedGenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.ExtendedMessageResult;
import de.pontonconsulting.xmlpipe.adapter.GenericAdapterFactory;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageMulticastAdapter
implements ISpecificAdapter {
    private static final List<Character> ALLOWED_CHARACTERS;
    private static final String MESSENGER_ADDRESS = "localhost";
    private static final int MESSENGER_PORT = 0;
    private static final String MESSENGER_PATH = "/pontonxp/AdapterService";
    private static final Logger log;
    private final Path workFolder;
    private final ExtendedGenericAdapter genericAdapter;
    private final ExecutorService executorService;

    public MessageMulticastAdapter(ExecutorService executorService, GenericAdapterFactory genericAdapterFactory) throws AdapterException, IOException {
        log.debug("Starting {}", (Object)this.getID());
        this.executorService = executorService;
        this.workFolder = this.createWorkFolder();
        this.genericAdapter = this.createGenericAdapter(genericAdapterFactory);
        log.debug("Started {}", (Object)this.getID());
    }

    private Path createWorkFolder() throws IOException {
        Path workFolder = Files.createTempDirectory(Path.of(System.getProperty("java.io.tmpdir"), new String[0]), this.getID(), new FileAttribute[0]).toAbsolutePath();
        log.info("Using WorkFolder: {}", (Object)workFolder);
        return workFolder;
    }

    private ExtendedGenericAdapter createGenericAdapter(GenericAdapterFactory genericAdapterFactory) throws AdapterException, IOException {
        ExtendedGenericAdapter genericAdapter = genericAdapterFactory.createExtendedGenericAdapter(this.getID());
        genericAdapter.setEndAdapter((ISpecificAdapter)this);
        genericAdapter.addMessengerConnection(MESSENGER_ADDRESS, 0, MESSENGER_PATH);
        return genericAdapter;
    }

    public void sendCopies(XpMessage originalXpMessage, List<String> copyReceiverBackendIds) {
        log.debug("Sending message copies.");
        Path payloadFile = null;
        try {
            payloadFile = Files.createTempFile(this.workFolder, "payload", ".dat", new FileAttribute[0]);
        }
        catch (IOException ioException) {
            log.error("Could not create temp file: {}", (Object)ioException.getMessage());
            MessageMulticastAdapter.removeTempFile(payloadFile);
            throw new RuntimeException(ioException);
        }
        try {
            Files.copy(originalXpMessage.getCurrentContentReference().toPath(), payloadFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioException) {
            log.error("Could not copy payload for message copies: {}", (Object)ioException.getMessage());
            MessageMulticastAdapter.removeTempFile(payloadFile);
            throw new RuntimeException(ioException);
        }
        String messageId = originalXpMessage.getMessageId();
        String senderInternalId = originalXpMessage.getSenderInternalId();
        String receiverInternalId = originalXpMessage.getReceiverInternalId();
        String conversationId = originalXpMessage.getConversationId();
        String schemaSet = originalXpMessage.getSchemaSet();
        String messageType = originalXpMessage.getMessageType();
        String messageVersion = originalXpMessage.getMessageVersion();
        String originalFileName = originalXpMessage.getProcessingDirective("OriginalFilename");
        Path copiedPayloadFile = payloadFile;
        this.executorService.submit(() -> {
            try {
                copyReceiverBackendIds.forEach(receiverBackendId -> {
                    if (senderInternalId.equals(receiverBackendId)) {
                        log.warn("Multicast receiver and the original sender is the same. Skipping...");
                    } else if (receiverInternalId.equals(receiverBackendId)) {
                        log.warn("Multicast receiver and the original receiver is the same. Skipping...");
                    } else {
                        String generatedMessageId = this.generateMessageId(messageId, (String)receiverBackendId);
                        log.debug("Sending message copy with the MessageId '{}' to '{}'.", (Object)generatedMessageId, receiverBackendId);
                        try {
                            BackEndMessage backEndMessage = new BackEndMessage(copiedPayloadFile.toFile());
                            backEndMessage.setTransferID(generatedMessageId);
                            backEndMessage.setConversationID(conversationId);
                            backEndMessage.setDTDSet(schemaSet);
                            backEndMessage.setMessageName(messageType);
                            backEndMessage.setDTDVersionNumber(messageVersion);
                            backEndMessage.setSenderOrganisation(senderInternalId);
                            backEndMessage.setReceiverOrganisation(receiverBackendId);
                            backEndMessage.addProcessingDirective("X-CopyOf", messageId);
                            backEndMessage.addProcessingDirective("X-OriginalReceiver", receiverInternalId);
                            if (originalFileName != null) {
                                backEndMessage.addProcessingDirective("OriginalFilename", originalFileName);
                            }
                            backEndMessage.setLogInfoText("Original MessageId: " + messageId);
                            ExtendedMessageResult messageResult = this.genericAdapter.sendMessageExtended(backEndMessage);
                            if (messageResult.equals((Object)MessageResult.MSG_SUCCESSFULLY_SEND)) {
                                log.info("Successfully sent message copy with the MessageId '{}' to '{}'.", (Object)generatedMessageId, receiverBackendId);
                            } else {
                                log.error("Could not send message copy with the MessageId '{}' to '{}'': {}.", (Object)generatedMessageId, receiverBackendId, (Object)messageResult.getDescription());
                            }
                        }
                        catch (Exception e) {
                            log.error("Could not send message copy to '{}': {}", receiverBackendId, (Object)e.getMessage());
                        }
                    }
                });
            }
            finally {
                MessageMulticastAdapter.removeTempFile(copiedPayloadFile);
            }
        });
    }

    private static void removeTempFile(Path payloadFile) {
        if (payloadFile != null) {
            try {
                Files.deleteIfExists(payloadFile);
            }
            catch (IOException e) {
                log.error("Could not delete temp file for copy message: {}", (Object)e.getMessage());
            }
        }
    }

    private String generateMessageId(String originalMessageId, String receiverBackendId) {
        StringBuilder prefix = new StringBuilder();
        for (char c : receiverBackendId.toCharArray()) {
            prefix.append(ALLOWED_CHARACTERS.contains(Character.valueOf(c)) ? Character.valueOf(c) : Integer.toHexString(c).toUpperCase());
        }
        return String.valueOf(prefix) + "-" + originalMessageId;
    }

    public String getID() {
        return "MessageMulticastAdapter";
    }

    public String getStatus() {
        return "OK";
    }

    public boolean supportsAcknowledgements() {
        return false;
    }

    public boolean supportsAttachments() {
        return false;
    }

    public int getNumberOfParallelThreads() {
        return 1;
    }

    public MessageResult receiveMessage(BackEndMessage message) {
        MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
        messageResult.appendToDescription("Adapter does not support inbound messages.");
        return messageResult;
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        return this.receiveMessage(message);
    }

    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        return this.receiveMessage(message);
    }

    public File getWorkFolder() {
        return this.workFolder.toFile();
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String shutdown() {
        return "Shutdown completed";
    }

    static {
        log = LogManager.getLogger((String)("Messenger." + MessageMulticastAdapter.class.getName()));
        ALLOWED_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toList());
    }
}

