/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.GenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapterIntegration;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderMessageType;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.HotFolderOriginalFileNameStrategy;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class HotFolderAdapterService {
    private static final String ERROR = "Error";
    private HotFolderAdapterIntegration hotFolderAdapterIntegration;
    private final Object objectHelper = new Object();

    public boolean sendMessage(HotFolderAdapter HotFolderAdapter2, HotFolderMessageType type, HotFolderCfg configuration, String receiverId, File msg, Collection<File> attachments) {
        Assert.notNull((Object)msg, (String)"File should not be null");
        BackEndMessage message = null;
        try {
            String senderId = this.getSender(configuration);
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)senderId), (String)"SenderId should not be null");
            GenericAdapter adapter = this.getAdapter(HotFolderAdapter2, configuration);
            message = this.getHotFolderAdapterIntegration().createMessage(type, msg, attachments);
            if (message == null) {
                return false;
            }
            message.setSenderOrganisation(senderId);
            message.setReceiverOrganisation(receiverId);
            return this.sendMessage(adapter, configuration, message);
        }
        catch (Exception ex) {
            HotFolderAdapter.LOG.error(ex.getMessage());
            return false;
        }
    }

    public boolean sendMessage(HotFolderAdapter HotFolderAdapter2, HotFolderMessageType type, HotFolderCfg configuration, File msg, Collection<File> attachments) {
        Assert.notNull((Object)msg, (String)"File should not be null");
        BackEndMessage message = null;
        try {
            GenericAdapter adapter = this.getAdapter(HotFolderAdapter2, configuration);
            message = this.getHotFolderAdapterIntegration().createMessage(type, msg, attachments);
            if (message == null) {
                return false;
            }
            return this.sendMessage(adapter, configuration, message);
        }
        catch (Exception ex) {
            HotFolderAdapter.LOG.error(ex.getMessage());
            return false;
        }
    }

    private String getSender(HotFolderCfg configuration) throws Exception {
        if (configuration.getUsePartnerSubfolders()) {
            return configuration.getSenderLocalID();
        }
        return null;
    }

    private GenericAdapter getAdapter(HotFolderAdapter HotFolderAdapter2, HotFolderCfg configuration) throws Exception {
        Assert.notNull((Object)configuration, (String)"Configuration should not be null");
        String adapterId = configuration.getAdapterID();
        GenericAdapter adapter = HotFolderAdapter2.provideAdapter(adapterId);
        Assert.notNull((Object)adapter, (String)"Adapter should not be null");
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessage(GenericAdapter adapter, HotFolderCfg hotFolderCfg, BackEndMessage msg) {
        MessageResult messageResult = null;
        try {
            messageResult = adapter.sendMessage(msg);
            String originalFileName = msg.getProcessingDirectiveAsString("OriginalFilename");
            Date time = new Date(Long.parseLong(messageResult.getMessageTime()));
            msg.setTransferID(messageResult.getMessageId());
            if (messageResult.equals((Object)MessageResult.MSG_SUCCESSFULLY_SEND)) {
                HotFolderAdapter.LOG.info("Message successfully sent. Payload file name: {}", (Object)msg.getSourceFile().getAbsolutePath());
                return true;
            }
            HotFolderAdapter.LOG.error("Message could not be sent. Payload file name: {}, Reason: {}", (Object)msg.getSourceFile().getAbsolutePath(), (Object)messageResult.getDescription());
            if (hotFolderCfg.isERPAcknowledgementEnabled()) {
                String messageReference = messageResult.getMessageId();
                if (StringUtils.isBlank((CharSequence)messageReference)) {
                    messageReference = String.format("%s-%s", originalFileName, time.getTime());
                }
                String ackMessageId = String.format("%s-%s-%s", "ACK", originalFileName, time.getTime());
                XpAcknowledgment ack = new XpAcknowledgment(ackMessageId, time, messageReference);
                ack.setOverallResult(ERROR);
                ack.setMessageTime(time);
                ack.addError(String.valueOf(messageResult.getXpCode()), messageResult.getDescription());
                Object object = this.objectHelper;
                synchronized (object) {
                    File tmpAckFile = null;
                    try {
                        String ackFolderPattern = hotFolderCfg.getRealPath(hotFolderCfg.getERPInbox());
                        HotFolderOriginalFileNameStrategy strategy = new HotFolderOriginalFileNameStrategy(ackFolderPattern, "ACK", ".xml");
                        String senderId = msg.getSenderOrganisationText();
                        msg.setSenderOrganisation(msg.getReceiverOrganisationText());
                        msg.setReceiverOrganisation(senderId);
                        File ackFile = strategy.getFile(msg);
                        tmpAckFile = new File(ackFile.getAbsolutePath() + ".hfa");
                        File ackFolder = tmpAckFile.getParentFile();
                        if (!ackFolder.exists() && !ackFolder.mkdirs()) {
                            HotFolderAdapter.LOG.error("ackFolder {} could not be created.", (Object)ackFolder.getAbsolutePath());
                        } else if ((tmpAckFile = ack.saveToDisk(tmpAckFile.getParentFile(), tmpAckFile.getName())).renameTo(ackFile)) {
                            HotFolderAdapter.LOG.info(String.format("Generated ACK saved to: [%s].", ackFile.getAbsolutePath()));
                        } else {
                            String errorText = "Could not rename file of generated ACK to '" + ackFile.getAbsolutePath() + "'.";
                            HotFolderAdapter.LOG.info(errorText);
                        }
                    }
                    finally {
                        if (tmpAckFile != null && tmpAckFile.exists()) {
                            try {
                                if (tmpAckFile.delete()) {
                                    HotFolderAdapter.LOG.warn("Could not delete temp file of generated ACK '{}'.", (Object)tmpAckFile.getAbsolutePath());
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            return false;
        }
        catch (Exception ex) {
            HotFolderAdapter.LOG.error(ex.getMessage());
            return false;
        }
    }

    public HotFolderAdapterIntegration getHotFolderAdapterIntegration() {
        return this.hotFolderAdapterIntegration;
    }

    public void setHotFolderAdapterIntegration(HotFolderAdapterIntegration hotFolderAdapterIntegration) {
        this.hotFolderAdapterIntegration = hotFolderAdapterIntegration;
    }
}

