/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.AgreementPartners;
import de.pontonconsulting.xmlpipe.adapter.GenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.IInternalAdapter;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderContextHolder;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderDelegate;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderInboundHandler;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderUtil;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderConfiguration;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.IHotFolderConfigurationListener;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HotFolderAdapter
implements IInternalAdapter,
IHotFolderConfigurationListener {
    private static final String MESSENGER_ADDRESS = "localhost";
    private static final String MESSENGER_PATH = "/pontonxp/AdapterService";
    public static final String BEAN_NAME = "HotFolderAdapter";
    public static final String CATEGORY = "HotFolder";
    public static final Logger LOG = LogManager.getLogger((String)"HotFolder");
    public static final String DEFAULT_HOTFOLDER_BEAN_NAME = "hotfolderAdapter";
    private HotFolderInboundHandler hotfolderInboundHandler;
    private HotFolderContextHolder hotfolderContextHolder;
    private HotFolderConfiguration hotfolderConfiguration;
    private final Map<String, GenericAdapter> genericAdapters = new ConcurrentHashMap<String, GenericAdapter>();
    private Map<String, HotFolderDelegate> hotfolderDelegates = new ConcurrentHashMap<String, HotFolderDelegate>();
    private ClassPathXmlApplicationContext hotfolderContext;
    private ApplicationContext parentApplicationContext;

    public void setParentApplicationContext(ApplicationContext parentApplicationContext) {
        this.parentApplicationContext = parentApplicationContext;
    }

    public void init(URL configResource) throws Exception {
        this.initSpringContext();
        this.startAdapter();
    }

    private void startAdapter() throws Exception {
        try {
            this.initGenericAdapters();
            this.initFolders();
            this.hotfolderContextHolder.startContext();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            this.stopHotFolders();
            throw ex;
        }
    }

    private void initSpringContext() {
        if (this.parentApplicationContext == null) {
            throw new IllegalStateException("Missing parent spring context.");
        }
        this.hotfolderContext = new ClassPathXmlApplicationContext();
        this.hotfolderContext.setBeanName("hotfolderContext");
        this.hotfolderContext.setParent(this.parentApplicationContext);
        this.hotfolderContext.setConfigLocation("classpath*:/de/pontonconsulting/xmlpipe/adapter/hotfolder/hotfolder-context.xml");
        this.hotfolderContext.setAllowCircularReferences(false);
        this.hotfolderContext.refresh();
        this.hotfolderContext.getBeanFactory().registerSingleton(BEAN_NAME, (Object)this);
        this.initBeans();
        this.hotfolderContext.start();
    }

    public void stop() throws Exception {
        this.stopAdapter();
        this.stopSpringContext();
    }

    private void stopAdapter() {
        this.hotfolderContextHolder.stopContext();
        this.stopHotFolders();
    }

    private void stopSpringContext() {
        this.hotfolderContext.stop();
    }

    @Override
    public synchronized void onHotFolderConfigurationChange() {
        try {
            this.stopAdapter();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            this.startAdapter();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void initBeans() {
        try {
            this.hotfolderConfiguration = (HotFolderConfiguration)this.hotfolderContext.getBean("hotFolderConfiguration", HotFolderConfiguration.class);
            this.hotfolderConfiguration.addListener(this);
            this.hotfolderInboundHandler = (HotFolderInboundHandler)this.hotfolderContext.getBean("HotFolderInboundHandler", HotFolderInboundHandler.class);
            this.hotfolderContextHolder = (HotFolderContextHolder)this.hotfolderContext.getBean("HotFolderContextHolder", HotFolderContextHolder.class);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }

    private void stopHotFolders() {
        try {
            if (!this.genericAdapters.isEmpty()) {
                for (GenericAdapter adapter : this.genericAdapters.values()) {
                    adapter.shutdown();
                }
                this.genericAdapters.clear();
                this.hotfolderDelegates.clear();
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public GenericAdapter provideAdapter(String adapterId) {
        if (StringUtils.isBlank((CharSequence)adapterId)) {
            return null;
        }
        return this.genericAdapters.get(adapterId);
    }

    public HotFolderInboundHandler getHotfolderInboundHandler() {
        return this.hotfolderInboundHandler;
    }

    public void setHotfolderInboundHandler(HotFolderInboundHandler hotfolderInboundHandler) {
        this.hotfolderInboundHandler = hotfolderInboundHandler;
    }

    public HotFolderContextHolder getHotfolderContextHolder() {
        return this.hotfolderContextHolder;
    }

    public void setHotfolderContextHolder(HotFolderContextHolder hotfolderContextHolder) {
        this.hotfolderContextHolder = hotfolderContextHolder;
    }

    private synchronized void initFolders() {
        try {
            for (String adapterId : this.hotfolderConfiguration.getHotFolderIDs()) {
                HotFolderCfg hotfolder = this.hotfolderConfiguration.getHotFolder(adapterId);
                this.initHotfolder(hotfolder);
                if (!hotfolder.getUsePartnerSubfolders()) continue;
                this.initSubfolders(hotfolder);
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private synchronized void initHotfolder(HotFolderCfg hotfolder) {
        try {
            HotFolderUtil.createDirectoryIfNotExsists(hotfolder.getOutboxFolder());
            HotFolderUtil.createDirectoryIfNotExsists(hotfolder.getWorkFolder());
            HotFolderUtil.createDirectoryIfNotExsists(hotfolder.getFailedFolder());
        }
        catch (JAXBException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private synchronized void initSubfolders(HotFolderCfg hotfolder) {
        try {
            File outboundDir = hotfolder.getOutboxFolder();
            File failedDir = hotfolder.getFailedFolder();
            String senderId = hotfolder.getSenderLocalID();
            List<Agreement> senderAgreements = this.getAgreements(hotfolder, senderId);
            if (!senderAgreements.isEmpty()) {
                for (Agreement agreement : senderAgreements) {
                    String receiver = agreement.getRemoteId();
                    File outboundPartnerDir = new File(outboundDir, receiver);
                    HotFolderUtil.createDirectoryIfNotExsists(outboundPartnerDir);
                    File failedPartnerDir = new File(failedDir, receiver);
                    HotFolderUtil.createDirectoryIfNotExsists(failedPartnerDir);
                }
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private List<Agreement> getAgreements(HotFolderCfg hotfolder, String senderId) {
        ArrayList<Agreement> result = new ArrayList<Agreement>();
        try {
            GenericAdapter gen = this.genericAdapters.get(hotfolder.getAdapterID());
            AgreementPartners[] agreementPartner = gen.getAgreementPartnersList();
            if (agreementPartner != null && agreementPartner.length > 0) {
                this.fillAgreementListFromAgreementPartnerList(senderId, result, agreementPartner);
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private void fillAgreementListFromAgreementPartnerList(String senderId, List<Agreement> result, AgreementPartners[] agreementPartner) {
        for (AgreementPartners aPartner : agreementPartner) {
            if (StringUtils.equalsIgnoreCase((CharSequence)senderId, (CharSequence)aPartner.getLocalPartnerId())) {
                result.add(new Agreement(this, aPartner.getLocalPartnerId(), aPartner.getRemotePartnerId()));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)senderId, (CharSequence)aPartner.getRemotePartnerId())) continue;
            result.add(new Agreement(this, aPartner.getRemotePartnerId(), aPartner.getLocalPartnerId()));
        }
    }

    private synchronized void initGenericAdapters() throws JAXBException {
        for (String adapterId : this.hotfolderConfiguration.getHotFolderIDs()) {
            HotFolderCfg hotfolder = this.hotfolderConfiguration.getHotFolder(adapterId);
            GenericAdapter adapter = this.initAdapter(hotfolder);
            if (adapter == null) continue;
            this.genericAdapters.put(adapterId, adapter);
        }
        ConcurrentHashMap<String, HotFolderDelegate> newDelegates = new ConcurrentHashMap<String, HotFolderDelegate>();
        for (String adapterId : this.hotfolderConfiguration.getHotFolderIDs()) {
            HotFolderDelegate delegate = this.hotfolderDelegates.get(adapterId);
            if (delegate == null) continue;
            newDelegates.put(adapterId, delegate);
        }
        this.hotfolderDelegates = newDelegates;
    }

    private GenericAdapter initAdapter(HotFolderCfg hotfolder) {
        try {
            HotFolderDelegate delegate;
            if (this.hotfolderDelegates.get(hotfolder.getAdapterID()) == null) {
                delegate = new HotFolderDelegate(this.hotfolderInboundHandler, hotfolder);
                this.hotfolderDelegates.put(hotfolder.getAdapterID(), delegate);
            } else {
                delegate = this.hotfolderDelegates.get(hotfolder.getAdapterID());
            }
            GenericAdapter genericAdapter = new GenericAdapter(CATEGORY);
            genericAdapter.setServerPort(hotfolder.getAdapterPort());
            genericAdapter.setProcessingTimeout(this.hotfolderConfiguration.getProcessingTimeout());
            genericAdapter.setEndAdapter((ISpecificAdapter)delegate);
            genericAdapter.addMessengerConnection(MESSENGER_ADDRESS, 0, MESSENGER_PATH);
            return genericAdapter;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private class Agreement {
        private final String senderId;
        private final String remoteId;

        public Agreement(HotFolderAdapter hotFolderAdapter, String senderId, String remoteId) {
            this.senderId = senderId;
            this.remoteId = remoteId;
        }

        public String getSenderId() {
            return this.senderId;
        }

        public String getRemoteId() {
            return this.remoteId;
        }
    }
}

