/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.as4certificateupdate;

import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertUpdateException;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertUpdateExceptionTuple;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertificateUpdateValidator;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4CertificateUpdateUtility;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AS4CertificateUpdateBackendMessageHandler {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + AS4CertificateUpdateBackendMessageHandler.class.getName()));
    private static final String UPDATED_AGREEMENT_IDENTIFIER = "UpdatedAgreementIdentifier";
    private final AS4CertificateUpdateUtility as4CertificateUpdateUtility;
    private final CertificateUtility certificateUtility;
    private final AS4CertificateUpdateValidator as4CertificateUpdateValidator;
    private final IdGenerator idGenerator;
    private final Profiles profiles;

    public AS4CertificateUpdateBackendMessageHandler(AS4CertificateUpdateUtility as4CertificateUpdateUtility, CertificateUtility certificateUtility, AS4CertificateUpdateValidator as4CertificateUpdateValidator, IdGenerator idGenerator, Profiles profiles) {
        this.as4CertificateUpdateUtility = as4CertificateUpdateUtility;
        this.certificateUtility = certificateUtility;
        this.as4CertificateUpdateValidator = as4CertificateUpdateValidator;
        this.idGenerator = idGenerator;
        this.profiles = profiles;
    }

    BackEndMessage handleCertUpdateRequestMessage(BackEndMessage message, CppPartner sender, CppPartner receiver, Agreement agreement, Communication communication, File workFolder) throws BackEndMessageException, TransformerException, SAXException, IOException, AgreementException, ParserConfigurationException {
        Document certUpdateRequestDocument;
        String updatedAgreementIdentifier = null;
        String referenceId = null;
        String currentAgreementRef = this.as4CertificateUpdateUtility.getCurrentAgreementRef(communication);
        Optional<String> currentAgreementRefType = Optional.ofNullable(this.as4CertificateUpdateUtility.getCurrentAgreementRefType(communication));
        try (InputStream messageDocumentInputStream = message.getMessageDocumentInputStream();){
            certUpdateRequestDocument = this.as4CertificateUpdateUtility.parseDocumentFromBackendMessage(messageDocumentInputStream);
        }
        try {
            Optional<AS4CertUpdateExceptionTuple> as4ExceptionTuple = this.as4CertificateUpdateValidator.validateCertUpdateRequestMessage(communication, currentAgreementRef, certUpdateRequestDocument);
            Optional<String> updatedAgreementIdentifierOptional = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", UPDATED_AGREEMENT_IDENTIFIER);
            Optional<String> updatedAgreementIdentifierTypeOptional = this.as4CertificateUpdateUtility.receiveAttributeFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", UPDATED_AGREEMENT_IDENTIFIER, "type");
            updatedAgreementIdentifier = updatedAgreementIdentifierOptional.orElseThrow();
            Optional<String> activateByOptional = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "ActivateBy");
            String activateBy = activateByOptional.orElseThrow();
            Optional<String> referenceIdOptional = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", "ID");
            referenceId = referenceIdOptional.orElseThrow();
            if (as4ExceptionTuple.isPresent()) {
                return this.createUpdateException(referenceId, currentAgreementRef, currentAgreementRefType, updatedAgreementIdentifier, as4ExceptionTuple.get(), sender, receiver, workFolder);
            }
            Optional<String> x509CertificateBase64Optional = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateRequestDocument, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
            String x509CertificateBase64 = x509CertificateBase64Optional.orElseThrow();
            X509Certificate x509CertificateUpdate = this.certificateUtility.getX509Certificate(x509CertificateBase64);
            agreement.setAS4UpdatedAgreementRef(updatedAgreementIdentifier);
            agreement.setAS4UpdatedAgreementRefType(updatedAgreementIdentifierTypeOptional.orElse(null));
            agreement.setAS4UpdatedAgreementOutboundTestSuccessful(false);
            agreement.setAS4UpdatedAgreementInboundTestSuccessful(false);
            agreement.setAS4CertUpdateInitiator(sender.getInternalId());
            agreement.setAS4CertUpdateActivateBy(activateBy);
            if (!this.certificateUtility.isCertAlreadyInstalled(x509CertificateUpdate, sender)) {
                sender.addPartnerCertificate(x509CertificateUpdate);
                sender.save();
            }
            String certificateId = sender.getCertificateId(x509CertificateUpdate);
            agreement.setAS4CertUpdateID(certificateId);
            agreement.setAS4CertificateUpdateTestServiceEnabled(true);
            agreement.save();
            return this.createUpdateResponse(referenceId, currentAgreementRef, currentAgreementRefType, updatedAgreementIdentifier, sender, receiver, workFolder);
        }
        catch (InstallCertException | ProfileException | NoSuchProviderException | CertificateException e) {
            AS4CertUpdateExceptionTuple as4ExceptionTuple = new AS4CertUpdateExceptionTuple(AS4CertUpdateException.ProcessingError, "Problem while processing message: " + e.getMessage());
            LOG.error("[{}] Error while processing cert update request", (Object)message.getDatabaseId());
            return this.createUpdateException(referenceId, currentAgreementRef, currentAgreementRefType, updatedAgreementIdentifier, as4ExceptionTuple, sender, receiver, workFolder);
        }
    }

    boolean handleCertUpdateResponseMessage(BackEndMessage message, Agreement agreement) throws BackEndMessageException, IOException, SAXException, AgreementException, ParserConfigurationException {
        try (InputStream messageDocumentInputStream = message.getMessageDocumentInputStream();){
            boolean agreementIdentifiersMatch;
            Document certUpdateResponseDocument = this.as4CertificateUpdateUtility.parseDocumentFromBackendMessage(messageDocumentInputStream);
            Optional<String> updatedAgreementIdentifier = this.as4CertificateUpdateUtility.receiveTextContentFromBackendMessage(certUpdateResponseDocument, "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0", UPDATED_AGREEMENT_IDENTIFIER);
            boolean bl = agreementIdentifiersMatch = updatedAgreementIdentifier.isPresent() && updatedAgreementIdentifier.get().equals(agreement.getAS4UpdatedAgreementRef());
            if (agreementIdentifiersMatch) {
                agreement.setAS4CertificateUpdateTestServiceEnabled(true);
                agreement.save();
            } else {
                LOG.error("[{}] Error while processing cert update response, agreement identifier does not match. received {} expected {}", (Object)message.getDatabaseId(), (Object)updatedAgreementIdentifier.orElse("null"), (Object)agreement.getAS4UpdatedAgreementRef());
            }
            boolean bl2 = agreementIdentifiersMatch;
            return bl2;
        }
    }

    boolean handleCertTestMessageRequest(CppPartner sender, CppPartner receiver, Agreement agreement) throws AgreementException, ProfileException {
        String as4UpdatedAgreementRef = agreement.getAS4UpdatedAgreementRef();
        agreement.setAS4UpdatedAgreementInboundTestSuccessful(true);
        agreement.save();
        boolean isAgreementSwitched = this.verifyTestResultsAndSwitchAgreement(agreement, sender, receiver, as4UpdatedAgreementRef);
        return !isAgreementSwitched && !sender.isLocal();
    }

    void handleCertTestMessageResponse(CppPartner sender, CppPartner receiver, Agreement agreement) {
        try {
            agreement.setAS4UpdatedAgreementOutboundTestSuccessful(true);
            agreement.save();
            String as4UpdatedAgreementRef = agreement.getAS4UpdatedAgreementRef();
            this.verifyTestResultsAndSwitchAgreement(agreement, sender, receiver, as4UpdatedAgreementRef);
        }
        catch (AgreementException | ProfileException e) {
            LOG.error("Cannot find profile or agreement.", (Throwable)e);
        }
    }

    private BackEndMessage createUpdateException(String referenceId, String currentAgreementRef, Optional<String> currentAgreementRefType, String updatedAgreementRef, AS4CertUpdateExceptionTuple as4ExceptionTuple, CppPartner sender, CppPartner receiver, File workFolder) throws BackEndMessageException, TransformerException, ParserConfigurationException {
        File certUpdateExceptionPayload = this.as4CertificateUpdateUtility.createCertificateUpdateException(this.idGenerator.generateMessageId(), referenceId, currentAgreementRef, currentAgreementRefType, updatedAgreementRef, workFolder, as4ExceptionTuple);
        BackEndMessage backendMessage = new BackEndMessage(certUpdateExceptionPayload, true);
        backendMessage.setReceiverOrganisation(sender.getInternalId());
        backendMessage.setSenderOrganisation(receiver.getInternalId());
        backendMessage.setMessageName("CertUpdateException");
        backendMessage.setDTDSet("AgreementUpdate");
        backendMessage.setDTDVersionNumber("2.1");
        return backendMessage;
    }

    private BackEndMessage createUpdateResponse(String referenceId, String currentAgreementRef, Optional<String> currentAgreementRefType, String updatedAgreementRef, CppPartner sender, CppPartner receiver, File workFolder) throws BackEndMessageException, TransformerException, ParserConfigurationException {
        File certUpdateResponsePayload = this.as4CertificateUpdateUtility.createCertificateUpdateResponse(this.idGenerator.generateMessageId(), referenceId, currentAgreementRef, currentAgreementRefType, updatedAgreementRef, workFolder);
        BackEndMessage backendMessage = new BackEndMessage(certUpdateResponsePayload, true);
        backendMessage.setReceiverOrganisation(sender.getInternalId());
        backendMessage.setSenderOrganisation(receiver.getInternalId());
        backendMessage.setMessageName("CertUpdateResponse");
        backendMessage.setDTDSet("AgreementUpdate");
        backendMessage.setDTDVersionNumber("2.1");
        return backendMessage;
    }

    boolean verifyTestResultsAndSwitchAgreement(Agreement agreement, CppPartner sender, CppPartner receiver, String as4UpdatedAgreementRef) throws AgreementException, ProfileException {
        boolean as4UpdatedAgreementOutboundTestSuccessful = agreement.isAS4UpdatedAgreementOutboundTestSuccessful();
        boolean as4UpdatedAgreementInboundTestSuccessful = agreement.isAS4UpdatedAgreementInboundTestSuccessful();
        if (as4UpdatedAgreementOutboundTestSuccessful && as4UpdatedAgreementInboundTestSuccessful) {
            this.switchAgreementAndUpdateCertificate(agreement, sender, receiver, as4UpdatedAgreementRef);
            return true;
        }
        return false;
    }

    private void switchAgreementAndUpdateCertificate(Agreement agreement, CppPartner sender, CppPartner receiver, String as4UpdatedAgreementRef) throws AgreementException, ProfileException {
        String as4CertUpdateInitiator = agreement.getAS4CertUpdateInitiator();
        String as4CertUpdateID = agreement.getAS4CertUpdateID();
        try {
            if (sender.getLocalId().equals(as4CertUpdateInitiator)) {
                sender.setDefaultCertRefId(as4CertUpdateID);
            } else {
                receiver.setDefaultCertRefId(as4CertUpdateID);
            }
            Communication communicationInbound = agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
            Communication communicationOutbound = agreement.getCommunication(receiver.getLocalId(), sender.getLocalId());
            String as4UpdatedAgreementRefType = agreement.getAS4UpdatedAgreementRefType();
            communicationInbound.setPackagingOptionValue("/AgreementRef", as4UpdatedAgreementRef, "string");
            communicationOutbound.setPackagingOptionValue("/AgreementRef", as4UpdatedAgreementRef, "string");
            communicationInbound.setPackagingOptionValue("/AgreementRef/Type", as4UpdatedAgreementRefType, "string");
            communicationOutbound.setPackagingOptionValue("/AgreementRef/Type", as4UpdatedAgreementRefType, "string");
            LOG.debug("Switched agreement for {} and {} with new agreement ref {}", (Object)sender.getLocalId(), (Object)receiver.getLocalId(), (Object)as4UpdatedAgreementRef);
        }
        catch (ProfileException e) {
            LOG.error("Cannot set packaging value for communication", (Throwable)e);
        }
        this.cleanUpAgreement(agreement);
    }

    void cleanUpAgreement(Agreement agreement) throws AgreementException, ProfileException {
        agreement.setAS4UpdatedAgreementRef(null);
        agreement.setAS4UpdatedAgreementRefType(null);
        agreement.setAS4CertUpdateID(null);
        agreement.setAS4UpdatedAgreementOutboundTestSuccessful(false);
        agreement.setAS4UpdatedAgreementInboundTestSuccessful(false);
        agreement.setAS4CertUpdateInitiator(null);
        agreement.setAS4CertUpdateActivateBy(null);
        agreement.setAS4CertificateUpdateTestServiceEnabled(false);
        agreement.save();
        LOG.debug("Cleaning up agreement for {} and {}", (Object)agreement.getOwnPartner().getId(), (Object)agreement.getCommunicationPartner().getId());
    }
}

