/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter;

import de.ponton.xp.adapter.api.IInternalAdapter2;
import de.pontonconsulting.xmlpipe.adapter.AdapterURLClassLoader;
import de.pontonconsulting.xmlpipe.adapter.IInternalAdapter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import de.pontonconsulting.xmlpipe.adapter.pingall.PingAllThread;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class AdapterLauncher {
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.AdapterLauncher");
    private static final String PROPERTIES_FILE = "embedded-adapters.properties";
    private static final String KEY_ADAPTER_PREFIX = "adapter.";
    private static final String KEY_CONFIG_PREFIX = "config.";
    private static final String MANIFEST_ATTRIBUTE_CONFIG_FILEEXTENSION = "Adapter-Config-File-Extension";
    private final List<IInternalAdapter> _internalAdapters = new ArrayList<IInternalAdapter>();
    private final List<IInternalAdapter2> _internalAdapters2 = new ArrayList<IInternalAdapter2>();
    private final PingAllThread _pingAllThread;
    private final IServerConfigBean serverConfig;
    private final ApplicationContext _parentApplicationContext;

    public AdapterLauncher(PingAllThread pingAllThread, IServerConfigBean serverConfig, ApplicationContext parentApplicationContext) {
        this._pingAllThread = pingAllThread;
        this.serverConfig = serverConfig;
        this._parentApplicationContext = parentApplicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEmbeddedAdapters() {
        _log.info((Object)"Starting embedded adapters.");
        Properties properties = new Properties();
        try {
            URL propertiesFileUrl = IOUtil.getResourceURL(PROPERTIES_FILE, _log);
            InputStream inputStream = null;
            try {
                inputStream = propertiesFileUrl.openStream();
                properties.load(inputStream);
            }
            finally {
                IOUtil.closeStreamQuietly(inputStream);
            }
        }
        catch (IOException e) {
            _log.error((Object)"Could not read configuration file for embedded adapters.", (Throwable)e);
            return;
        }
        int index = 0;
        String adapterClass = properties.getProperty(KEY_ADAPTER_PREFIX + ++index);
        String configResource = properties.getProperty(KEY_CONFIG_PREFIX + index);
        while (adapterClass != null) {
            _log.info((Object)("Found embedded adapter with main class '" + adapterClass + "' and config resource '" + configResource + "'."));
            try {
                URL configUrl = null;
                if (configResource != null && !configResource.equals("hotfolder.xml")) {
                    configUrl = IOUtil.getResourceURL(configResource, _log);
                }
                this.loadEmbeddedAdapter(adapterClass, configUrl);
            }
            catch (IOException e) {
                _log.error((Object)("The given config resource '" + configResource + "' does not exit."));
            }
            adapterClass = properties.getProperty(KEY_ADAPTER_PREFIX + ++index);
            configResource = properties.getProperty(KEY_CONFIG_PREFIX + index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startPluggableAdapters() {
        File[] adapterJars;
        _log.info((Object)"Starting pluggable adapters.");
        ClassLoader parentClassLoader = IInternalAdapter.class.getClassLoader();
        File adaptersFolder = this.serverConfig.getAdaptersFolder();
        if (!adaptersFolder.exists()) {
            _log.warn((Object)("The folder '" + adaptersFolder.getAbsolutePath() + "' does not exist."));
            return;
        }
        for (File adapterJar : adapterJars = adaptersFolder.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".jar");
            }
        })) {
            JarFile jarFile;
            block11: {
                _log.info((Object)("Found pluggable adapter jar: " + String.valueOf(adapterJar)));
                jarFile = null;
                try {
                    jarFile = new JarFile(adapterJar);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest == null) break block11;
                    Attributes attributes = manifest.getMainAttributes();
                    String adapterMainClassName = attributes.getValue(Attributes.Name.MAIN_CLASS);
                    if (adapterMainClassName != null) {
                        URL configUrl;
                        adapterMainClassName = adapterMainClassName.replace('/', '.');
                        String configFileExtension = attributes.getValue(MANIFEST_ATTRIBUTE_CONFIG_FILEEXTENSION);
                        if (configFileExtension == null) {
                            throw new IllegalArgumentException("No configuration file extension set in the jar: " + String.valueOf(adapterJar));
                        }
                        String configResource = IOUtil.getFileNameWithoutExtension(adapterJar.getName()) + "." + configFileExtension;
                        try {
                            configUrl = IOUtil.getResourceURL("plugableAdapterConfigs/" + configResource, _log);
                        }
                        catch (IOException ioe) {
                            _log.error((Object)("Could not start a pluggable adapter from " + String.valueOf(adapterJar) + ": " + ioe.getMessage()));
                            IOUtil.closeZipFileQuietly(jarFile);
                            continue;
                        }
                        this.loadPluggableAdapter(parentClassLoader, adapterMainClassName, configUrl, adapterJar.toURI().toURL());
                        break block11;
                    }
                    _log.error((Object)("No main class found in the jar '" + String.valueOf(adapterJar) + "'."));
                }
                catch (Exception e) {
                    try {
                        _log.error((Object)("Could not read manifest of the file '" + String.valueOf(adapterJar) + "'."), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeZipFileQuietly(jarFile);
                        throw throwable;
                    }
                    IOUtil.closeZipFileQuietly(jarFile);
                    continue;
                }
            }
            IOUtil.closeZipFileQuietly(jarFile);
        }
    }

    private void loadPluggableAdapter(ClassLoader parentClassLoader, String className, URL configUrl, URL adapterJar) {
        if (this.isStartingWithAdapterAPI2failed(className, configUrl, adapterJar)) {
            this.tryStartingWithAdapterAPI1(parentClassLoader, className, configUrl, adapterJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStartingWithAdapterAPI1(ClassLoader parentClassLoader, String className, URL configUrl, URL adapterJar) {
        ClassLoader threadContext2 = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoaderApi1 = this.buildClassLoader(adapterJar, parentClassLoader);
            Class<?> clazz1 = classLoaderApi1.loadClass(className);
            IInternalAdapter internalAdapter = (IInternalAdapter)clazz1.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            _log.debug((Object)("Starting adapter: " + className));
            Thread.currentThread().setContextClassLoader(classLoaderApi1);
            internalAdapter.init(configUrl);
            this._internalAdapters.add(internalAdapter);
            _log.info((Object)("Started adapter(API1): " + className));
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            _log.error((Object)("could not load adapter: " + className), e);
        }
        catch (Exception e) {
            _log.error((Object)("could not start adapter: " + className), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStartingWithAdapterAPI2failed(String className, URL configUrl, URL adapterJar) {
        ClassLoader threadContext = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoaderApi2 = this.buildClassLoader(adapterJar, null);
            Class<?> clazz2 = classLoaderApi2.loadClass(className);
            IInternalAdapter2 internalAdapter = (IInternalAdapter2)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            _log.debug((Object)("Starting adapter: " + className));
            Thread.currentThread().setContextClassLoader(classLoaderApi2);
            internalAdapter.init(configUrl, this.serverConfig.getAdapterInterfacePort());
            this._internalAdapters2.add(internalAdapter);
            _log.info((Object)("Started adapter(API2): " + className));
            boolean bl = false;
            return bl;
        }
        catch (ClassCastException classLoaderApi2) {
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            _log.error((Object)("could not load adapter: " + className), e);
        }
        catch (Exception e) {
            _log.error((Object)("could not start adapter: " + className), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContext);
        }
        return true;
    }

    private void loadEmbeddedAdapter(String className, URL configUrl) {
        try {
            _log.info((Object)("Starting embedded adapter: " + className));
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            IInternalAdapter internalAdapter = (IInternalAdapter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (internalAdapter instanceof HotFolderAdapter) {
                ((HotFolderAdapter)internalAdapter).setParentApplicationContext(this._parentApplicationContext);
            }
            internalAdapter.init(configUrl);
            this._internalAdapters.add(internalAdapter);
            _log.info((Object)("Started embedded adapter: " + className));
        }
        catch (Throwable e) {
            _log.error((Object)("could not start adapter: " + className), e);
        }
    }

    private ClassLoader buildClassLoader(URL adapterJar, ClassLoader parentClassLoader) throws MalformedURLException {
        if (parentClassLoader == null) {
            return new URLClassLoader(new URL[]{this.serverConfig.getConfigFolder().toURI().toURL(), new File(this.serverConfig.getConfigFolder(), "plugableAdapterConfigs").toURI().toURL(), adapterJar});
        }
        return new AdapterURLClassLoader(new URL[]{this.serverConfig.getConfigFolder().toURI().toURL(), new File(this.serverConfig.getConfigFolder(), "plugableAdapterConfigs").toURI().toURL(), adapterJar}, parentClassLoader);
    }

    public synchronized void stopAdapters() {
        _log.info((Object)"Stopping PingAllThread.");
        String result = this._pingAllThread.shutdown();
        _log.info((Object)("Stopped PingAllThread: " + result));
        for (IInternalAdapter iInternalAdapter : this._internalAdapters) {
            try {
                _log.info((Object)("Stopping adapter: " + iInternalAdapter.getClass().getName()));
                iInternalAdapter.stop();
                _log.info((Object)("Stopped adapter: " + iInternalAdapter.getClass().getName()));
            }
            catch (Exception e) {
                _log.error((Object)("could not stop adapter: " + iInternalAdapter.getClass().getName()), (Throwable)e);
            }
        }
        this._internalAdapters.clear();
        for (IInternalAdapter2 iInternalAdapter2 : this._internalAdapters2) {
            try {
                _log.info((Object)("Stopping adapter: " + iInternalAdapter2.getClass().getName()));
                iInternalAdapter2.stop();
                _log.info((Object)("Stopped adapter: " + iInternalAdapter2.getClass().getName()));
            }
            catch (Exception e) {
                _log.error((Object)("could not stop adapter: " + iInternalAdapter2.getClass().getName()), (Throwable)e);
            }
        }
        this._internalAdapters2.clear();
    }

    public synchronized void startAdapters() {
        if (!this._internalAdapters.isEmpty()) {
            throw new IllegalStateException("Internal adapters were already started.");
        }
        _log.info((Object)"Starting PingAllThread.");
        this._pingAllThread.startAdapter();
        _log.info((Object)"Started PingAllThread.");
        this.startPluggableAdapters();
        this.startEmbeddedAdapters();
    }
}

