/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation.capability;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.activation.capability.AbstractCapability;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ASxCapability
extends AbstractCapability {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.ASxCapability");
    private static final List<String> supportedPackageNames = List.of("AS1", "AS2", "AS3");
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public ASxCapability(MessengerActivation activationProvider) {
        super(activationProvider);
    }

    @Override
    public void doCapabilityCheck() {
        try {
            this.enabled.set(this.activationProvider.isASxMessagingEnabled());
        }
        catch (ActivationException e) {
            LOGGER.error(e.getMessage());
            this.enabled.set(false);
        }
    }

    @Override
    protected boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public boolean isSupported(String packageName) {
        return packageName != null && supportedPackageNames.contains(packageName);
    }
}

