/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.xml;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class DtdFilterStream
extends FilterInputStream {
    protected boolean _docStarted = false;
    protected boolean _inComment = false;
    private byte[] _myBuffer = new byte[64];
    private int _bufferLength = 0;
    private int _positionPointer = 0;
    private boolean _endOfStream = false;
    private String _dtdName;

    public DtdFilterStream(InputStream in) {
        super(in);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        int c = 32;
        if (this._bufferLength - this._positionPointer != 0) return this.feedFromInternalBuffer();
        this._positionPointer = 0;
        this._bufferLength = 0;
        c = this.in.read();
        if (!this._docStarted && !this._inComment && c == 60) {
            int d = this.in.read();
            switch (d) {
                case 63: {
                    this._myBuffer[this._bufferLength++] = (byte)d;
                    return c;
                }
                case 33: {
                    int e = this.in.read();
                    if (e == 68) {
                        StringBuilder sb = new StringBuilder();
                        boolean filenameStart = false;
                        while ((e = this.in.read()) != -1 && e != 62) {
                            if (e == 34) {
                                filenameStart = !filenameStart;
                                continue;
                            }
                            if (!filenameStart) continue;
                            sb.append((char)e);
                        }
                        this._dtdName = sb.toString();
                        c = this.in.read();
                        this._docStarted = true;
                        return c;
                    }
                    if (e == 45) {
                        int f = this.in.read();
                        if (f != 45) return c;
                        this._inComment = true;
                        this._myBuffer[this._bufferLength++] = (byte)d;
                        this._myBuffer[this._bufferLength++] = (byte)e;
                        this._myBuffer[this._bufferLength++] = (byte)f;
                        return c;
                    }
                    this._myBuffer[this._bufferLength++] = (byte)d;
                    this._myBuffer[this._bufferLength++] = (byte)e;
                    return c;
                }
                default: {
                    this._myBuffer[this._bufferLength++] = (byte)d;
                    this._docStarted = true;
                }
            }
            return c;
        } else {
            if (!this._inComment) return c;
            if (c != 45) return c;
            int d = this.in.read();
            if (d == 45) {
                int e = this.in.read();
                if (e == 62) {
                    this._inComment = false;
                }
                this._myBuffer[this._bufferLength++] = (byte)d;
                this._myBuffer[this._bufferLength++] = (byte)e;
                return c;
            } else {
                this._myBuffer[this._bufferLength++] = (byte)d;
            }
        }
        return c;
    }

    @Override
    public int read(byte[] text) throws IOException {
        return this.read(text, 0, text.length);
    }

    @Override
    public int read(byte[] text, int offset, int length) throws IOException {
        if (this._endOfStream) {
            return -1;
        }
        int numRead = 0;
        for (int i = offset; i < offset + length; ++i) {
            int temp = this.read();
            if (temp == -1) {
                this._endOfStream = true;
                break;
            }
            text[i] = (byte)temp;
            ++numRead;
        }
        if (numRead == 0) {
            numRead = -1;
        }
        return numRead;
    }

    protected int feedFromInternalBuffer() {
        int retChar = this._myBuffer[this._positionPointer++] & 0xFF;
        return retChar;
    }

    public String getDtdName() {
        return this._dtdName;
    }
}

