/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.net.ntp;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class TimeStamp {
    private long integerPart;
    private long fractionalPart;
    private byte[] data;
    private Date date;
    private static TimeZone UTC = new SimpleTimeZone(0, "UTC");
    private static Calendar c = new GregorianCalendar(1900, 0, 1, 0, 0, 0);
    private static Date startOfCentury;
    private static final byte[] emptyArray;
    public static final TimeStamp zero;

    private int mp(byte b) {
        int bb = b;
        return bb < 0 ? 256 + bb : bb;
    }

    public TimeStamp() {
        this(new Date());
    }

    public TimeStamp(Date date) {
        int i;
        this.data = new byte[8];
        this.date = date;
        long msSinceStartOfCentury = date.getTime() - startOfCentury.getTime();
        this.integerPart = msSinceStartOfCentury / 1000L;
        this.fractionalPart = msSinceStartOfCentury % 1000L * 0x100000000L / 1000L;
        long temp = this.integerPart;
        for (i = 3; i >= 0; --i) {
            this.data[i] = (byte)(temp % 256L);
            temp /= 256L;
        }
        temp = this.fractionalPart;
        for (i = 7; i >= 4; --i) {
            this.data[i] = (byte)(temp % 256L);
            temp /= 256L;
        }
    }

    public TimeStamp(byte[] data) {
        int i;
        this.data = data;
        this.integerPart = 0L;
        for (i = 0; i <= 3; ++i) {
            this.integerPart = 256L * this.integerPart + (long)this.mp(data[i]);
        }
        this.fractionalPart = 0L;
        for (i = 4; i <= 7; ++i) {
            this.fractionalPart = 256L * this.fractionalPart + (long)this.mp(data[i]);
        }
        long msSinceStartOfCentury = this.integerPart * 1000L + this.fractionalPart * 1000L / 0x100000000L;
        this.date = new Date(msSinceStartOfCentury + startOfCentury.getTime());
    }

    public boolean equals(TimeStamp ts) {
        boolean value = true;
        byte[] tsData = ts.getData();
        for (int i = 0; i <= 7; ++i) {
            if (this.data[i] == tsData[i]) continue;
            value = false;
        }
        return value;
    }

    public String toString() {
        return String.valueOf(this.date) + " + " + this.fractionalPart + "/4294967296";
    }

    public byte[] getData() {
        return this.data;
    }

    public Date getTime() {
        return this.date;
    }

    static {
        c.setTimeZone(UTC);
        startOfCentury = c.getTime();
        emptyArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        zero = new TimeStamp(emptyArray);
    }
}

