/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UTF8BOMSkippingInputStream
extends InputStream {
    private static final byte[] UTF_8 = new byte[]{-17, -69, -65};
    private PushbackInputStream _in;
    private String _encoding;

    public UTF8BOMSkippingInputStream(InputStream in) throws IOException {
        this._in = new PushbackInputStream(in, 4);
        byte[] buffer = new byte[4];
        this._in.read(buffer);
        if (this.checkBOM(buffer, UTF_8)) {
            this._in.unread(buffer, 3, 1);
            this._encoding = "UTF-8";
        } else {
            this._in.unread(buffer);
        }
    }

    private boolean checkBOM(byte[] buffer, byte[] bom) {
        boolean found = false;
        for (int i = 0; i < bom.length && buffer[i] == bom[i]; ++i) {
            if (i + 1 != bom.length) continue;
            found = true;
        }
        return found;
    }

    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public int available() throws IOException {
        return this._in.available();
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this._in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this._in.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this._in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this._in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this._in.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this._in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this._in.skip(n);
    }
}

