/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.file;

import java.io.File;
import java.io.FileFilter;

public class GenericFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private String[] _extensions;
    private boolean _acceptDirectories = false;
    private boolean _acceptFiles = true;

    private GenericFileFilter() {
    }

    public GenericFileFilter(String[] extensions) {
        this(extensions, true, true);
    }

    public GenericFileFilter(String[] extensions, boolean acceptDirectories) {
        this(extensions, acceptDirectories, true);
    }

    public GenericFileFilter(String[] extensions, boolean acceptDirectories, boolean acceptFiles) {
        this();
        this._extensions = extensions;
        this._acceptDirectories = acceptDirectories;
        this._acceptFiles = acceptFiles;
    }

    @Override
    public boolean accept(File file) {
        if (this._acceptDirectories && file.isDirectory()) {
            return true;
        }
        if (!this._acceptDirectories && file.isDirectory()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        if (this._acceptFiles) {
            for (int i = 0; i < this._extensions.length; ++i) {
                if (!file.getAbsolutePath().toLowerCase().endsWith(this._extensions[i].toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        Object description = "Unknown";
        if (this._extensions != null) {
            description = "";
            for (int i = 0; i < this._extensions.length; ++i) {
                description = (String)description + "*." + this._extensions[i];
                if (i + 1 >= this._extensions.length) continue;
                description = (String)description + " & ";
            }
        }
        return description;
    }
}

