/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

public abstract class FileUtils {
    private static final int SIXTYFOUR_KB = 65536;
    private static final int ONE_MB = 0x100000;

    public static boolean copy(String source, String destination) throws IOException {
        File src = new File(source);
        File dest = new File(destination);
        return FileUtils.copy(src, dest);
    }

    public static boolean copy(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            File[] subFile = source.listFiles();
            if (subFile.length == 0) {
                new File(destination, source.getName()).mkdir();
            } else {
                for (int i = 0; i < subFile.length; ++i) {
                    File newDestination = new File(destination, source.getName());
                    newDestination.mkdir();
                    FileUtils.copy(subFile[i], newDestination);
                }
            }
        } else {
            if (destination.isDirectory()) {
                destination = new File(destination, source.getName());
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(source.toPath(), new OpenOption[0]));
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(destination.toPath(), new OpenOption[0]));){
                ((InputStream)in).transferTo(out);
            }
        }
        return true;
    }

    public static void copy(File source, File destination, FilenameFilter exclusionFilter) throws IOException {
        if (exclusionFilter.accept(source.getParentFile(), source.getName())) {
            return;
        }
        if (source.isDirectory()) {
            File[] subFile = source.listFiles();
            if (subFile.length == 0) {
                new File(destination, source.getName()).mkdir();
            } else {
                for (int i = 0; i < subFile.length; ++i) {
                    File newDestination = new File(destination, source.getName());
                    newDestination.mkdir();
                    FileUtils.copy(subFile[i], newDestination, exclusionFilter);
                }
            }
        } else {
            if (destination.isDirectory()) {
                destination = new File(destination, source.getName());
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(source.toPath(), new OpenOption[0]));
                 BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(destination.toPath(), new OpenOption[0]));){
                ((InputStream)in).transferTo(out);
            }
        }
    }

    public static boolean move(File source, File destination) throws IOException {
        boolean resultOk = false;
        if (destination.equals(source)) {
            resultOk = true;
        } else if (source.isDirectory()) {
            File destFolder = new File(destination, source.getName());
            resultOk = source.renameTo(destFolder);
            if (!resultOk) {
                destFolder.mkdirs();
                File[] files = source.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    resultOk = FileUtils.copy(files[i], destFolder);
                    files[i].delete();
                }
                source.delete();
            }
        } else {
            resultOk = !destination.isDirectory() ? source.renameTo(destination) : source.renameTo(new File(destination, source.getName()));
            if (!resultOk) {
                boolean copyOk = FileUtils.copy(source, destination);
                boolean deleteOk = source.delete();
                resultOk = copyOk && deleteOk;
            }
        }
        return resultOk;
    }

    public static boolean move(String source, String destination) throws IOException {
        File src = new File(source);
        File dest = new File(destination);
        return FileUtils.move(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File file) throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[16384];
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            int length = 0;
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                crc32.update(buffer, 0, length);
            }
        }
        return crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDigest(File file) throws IOException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] buffer = new byte[16384];
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                int length = 0;
                while ((length = ((InputStream)in).read(buffer)) != -1) {
                    md.update(buffer, 0, length);
                }
                digest = md.digest();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return digest;
    }

    public static boolean compareDigests(byte[] d1, byte[] d2) {
        try {
            MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return MessageDigest.isEqual(d1, d2);
    }

    public static boolean deleteDirectory(File folder) {
        if (!folder.exists() || !folder.isDirectory()) {
            return false;
        }
        boolean allOk = true;
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (FileUtils.deleteDirectory(file)) continue;
                allOk = false;
                continue;
            }
            if (file.delete()) continue;
            allOk = false;
        }
        if (!folder.delete()) {
            allOk = false;
        }
        return allOk;
    }
}

