/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.file;

import de.pontonconsulting.common.file.IFileChangeListener;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBConfigChangeWatcher {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.DBConfigChangeWatcher");
    private final String configType;
    private final ArrayList<IFileChangeListener> _listeners;
    private long _timestamp;
    private final long _checkInterval;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> configSyncTask;
    private final MessengerConfigDAO messengerConfigDAO;

    public DBConfigChangeWatcher(MessengerConfigDAO messengerConfigDAO, String configType, long checkInterval, ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        this._listeners = new ArrayList();
        this._timestamp = messengerConfigDAO.getTimestampAsLongByConfigType(configType);
        this._checkInterval = checkInterval;
        this.messengerConfigDAO = messengerConfigDAO;
        this.configType = configType;
    }

    public DBConfigChangeWatcher(MessengerConfigDAO messengerConfigDAO, String configType, long checkInterval, IFileChangeListener fileChangeListener, ScheduledExecutorService scheduledExecutorService) {
        this(messengerConfigDAO, configType, checkInterval, scheduledExecutorService);
        this.addFileChangeListener(fileChangeListener);
    }

    private synchronized void notifyListeners() {
        for (IFileChangeListener listener : this._listeners) {
            listener.fileChangedEvent();
        }
    }

    public synchronized void startWatcher() {
        if (this.configSyncTask == null) {
            this.checkConfigTimestampChanged();
            this.configSyncTask = this.scheduledExecutorService.scheduleWithFixedDelay(this::checkConfigTimestampChanged, this._checkInterval, this._checkInterval, TimeUnit.MILLISECONDS);
        }
    }

    public void stopWatcher() {
        if (this.configSyncTask != null) {
            this.configSyncTask.cancel(true);
        }
    }

    public synchronized void checkConfigTimestampChanged() {
        long currentTimestamp = this.messengerConfigDAO.getTimestampAsLongByConfigType(this.configType);
        if (this._timestamp != currentTimestamp) {
            LOG.debug("Timestamp changed for configType '{}' from {} to {} (checkInterval={})", (Object)this.configType, (Object)this._timestamp, (Object)currentTimestamp, (Object)this._checkInterval);
            this._timestamp = currentTimestamp;
            this.notifyListeners();
        }
    }

    public void addFileChangeListener(IFileChangeListener fileChangeListener) {
        this._listeners.add(fileChangeListener);
    }

    public boolean removeFileChangeListener(IFileChangeListener fileChangeListener) {
        return this._listeners.remove(fileChangeListener);
    }
}

