/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.websocket;

import de.ponton.xmlpipe.websocket.AbstractEndpoint;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.listener.IMessageReceiver;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.listener.MessageRequest;
import de.pontonconsulting.xmlpipe.listener.MessageResponse;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ClientEndpoint
public class DataEndpoint
extends AbstractEndpoint
implements MessageHandler.Whole<String>,
MessageHandler.Partial<byte[]> {
    static final Logger LOG = LogManager.getLogger((String)"Listener.DataEndpoint");
    private static AtomicLong _callNumber = new AtomicLong(0L);
    private final IFolders folders;
    private final ListenerManager listenerManager;
    private File incommingDataFile;
    private final Map<String, String> controlHeaders;
    private OutputStream incomingData;
    private long receivedBytes;

    public DataEndpoint(IFolders folders, ListenerManager listenerManager, WebSocketContainer container, String url, int reconnectDelay, PrivateKey key, X509Certificate cert, String authenticationid) {
        super(container, url, reconnectDelay, key, cert, authenticationid);
        this.folders = folders;
        this.listenerManager = listenerManager;
        this.controlHeaders = new HashMap<String, String>();
    }

    private long getCallNumber() {
        return _callNumber.incrementAndGet();
    }

    @Override
    void handleIncomingData(byte[] partialMessage, boolean last) throws IOException {
        if (last) {
            this.handleLastPacket(partialMessage);
        } else {
            this.handleDataPacket(partialMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLastPacket(byte[] partialMessage) throws IOException {
        try {
            this.incomingData.flush();
            this.incomingData.close();
            MessageResponse messageResponse = switch (partialMessage[0]) {
                case 0 -> this.transmissionOk();
                case 1 -> this.transmissionAbort();
                default -> {
                    LOG.warn("unknown completion value: {}. ignoring transmission.", (Object)partialMessage[0]);
                    yield this.transmissionAbort();
                }
            };
            int code = messageResponse.getResultCode();
            String msg = messageResponse.getResultText();
            LOG.info("response: {} {}", (Object)code, (Object)msg);
            StringBuilder builder = new StringBuilder();
            builder.append(code);
            builder.append("\r\n");
            builder.append(msg);
            builder.append("\r\n");
            LOG.trace("sending Response Header");
            Map<String, String> headers = messageResponse.getHeaders();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.append(entry.getKey());
                builder.append(": ");
                builder.append(entry.getValue());
                builder.append("\r\n");
            }
            this.session.getBasicRemote().sendText(builder.toString());
            this.sendData(messageResponse.getData(), this.session.getBasicRemote());
        }
        finally {
            this.cleanupDataCache();
        }
    }

    private MessageResponse transmissionAbort() {
        MessageResponse messageResponse = new MessageResponse();
        messageResponse.setResult(500, "transmission abort");
        return messageResponse;
    }

    private MessageResponse transmissionOk() throws IOException {
        MessageResponse messageResponse;
        IMessageReceiver messageReceiver;
        MessageRequest messageRequest = new MessageRequest(this.incommingDataFile, this.controlHeaders);
        String[] pathParts = messageRequest.getRequestServletPath().split("/");
        String listenerName = "";
        for (int i = 1; i < pathParts.length; ++i) {
            String part = pathParts[pathParts.length - i];
            if (part.isEmpty()) continue;
            listenerName = part;
            break;
        }
        if ((messageReceiver = this.listenerManager.getListener(listenerName)) == null) {
            messageResponse = new MessageResponse();
            messageResponse.setResult(404, "no message handler found for " + listenerName);
        } else if ("GET".equals(messageRequest.getMethod())) {
            messageResponse = messageReceiver.receiveGetRequest(messageRequest);
        } else if ("POST".equals(messageRequest.getMethod())) {
            messageResponse = messageReceiver.receivePostRequest(messageRequest);
        } else {
            messageResponse = new MessageResponse();
            messageResponse.setResult(404, "HTTP method " + messageRequest.getMethod() + " is not supported");
        }
        return messageResponse;
    }

    private void handleDataPacket(byte[] partialMessage) throws IOException {
        try {
            this.incomingData.write(partialMessage);
            this.receivedBytes += (long)partialMessage.length;
            LOG.trace("received Request Data ({}bytes)", (Object)partialMessage.length);
        }
        catch (IOException e) {
            LOG.error("could not store incoming data: " + e.getMessage());
            this.cleanupDataCache();
            throw e;
        }
    }

    public void onMessage(String message) {
        LOG.info("receiving Request Header");
        BufferedReader reader = new BufferedReader(new StringReader(message));
        try {
            this.initDataCache();
            String method = reader.readLine();
            this.controlHeaders.put("X-Request-Method", method);
            String servletPath = reader.readLine();
            this.controlHeaders.put("X-Request-Servlet-Path", servletPath);
            String url = reader.readLine();
            this.controlHeaders.put("X-Request-URL", url);
            Stream<String> lines = reader.lines();
            lines.forEach(s -> {
                String[] data = s.split(": ");
                if (data.length > 1) {
                    this.controlHeaders.put(data[0], data[1]);
                }
            });
        }
        catch (IOException e) {
            LOG.error("error while receiving request headers {}", (Object)e.toString());
            this.closeSession(CloseReason.CloseCodes.VIOLATED_POLICY, "error while receiving request headers: " + e.toString());
        }
    }

    private void initDataCache() throws IOException {
        this.controlHeaders.clear();
        this.incommingDataFile = new File(this.folders.getWorkInboundFolder(), "data-" + this.getCallNumber());
        this.incomingData = new BufferedOutputStream(Files.newOutputStream(this.incommingDataFile.toPath(), new OpenOption[0]));
    }

    private void cleanupDataCache() {
        IOUtil.closeStreamQuietly(this.incomingData);
        if (this.incommingDataFile != null && this.incommingDataFile.exists()) {
            this.incommingDataFile.delete();
        }
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        this.cleanupDataCache();
    }

    public String toString() {
        return "DataEndpoint{folders=" + String.valueOf(this.folders) + ", listenerManager=" + String.valueOf(this.listenerManager) + ", incommingDataFile=" + String.valueOf(this.incommingDataFile) + ", controlHeaders=" + String.valueOf(this.controlHeaders) + ", incomingData=" + String.valueOf(this.incomingData) + ", receivedBytes=" + this.receivedBytes + "}";
    }

    @Override
    Logger getLogger() {
        return LOG;
    }
}

