/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.validation;

import de.ponton.xmlpipe.rest.validation.EndDate;
import de.ponton.xmlpipe.rest.validation.StartDate;
import de.ponton.xmlpipe.rest.validation.ValidPeriodConstraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeriodValidator
implements ConstraintValidator<ValidPeriodConstraint, Object> {
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));

    public boolean isValid(Object object, ConstraintValidatorContext constraintValidatorContext) {
        ArrayList annotatedStartDates = new ArrayList();
        ArrayList annotatedEndDates = new ArrayList();
        Arrays.stream(object.getClass().getDeclaredFields()).forEach(field -> {
            if (field.getAnnotation(StartDate.class) != null) {
                annotatedStartDates.add(field);
            }
            if (field.getAnnotation(EndDate.class) != null) {
                annotatedEndDates.add(field);
            }
        });
        if (annotatedStartDates.size() != 1 || annotatedEndDates.size() != 1) {
            throw new IllegalStateException("Not enough or too many StartDate/EndDate annotations for " + object.getClass().getName());
        }
        if (annotatedStartDates.get(0) == annotatedEndDates.get(0)) {
            throw new IllegalStateException("StartDate and EndDate are on the same field for " + object.getClass().getName());
        }
        if (!OffsetDateTime.class.isAssignableFrom(((Field)annotatedStartDates.get(0)).getType()) || !OffsetDateTime.class.isAssignableFrom(((Field)annotatedEndDates.get(0)).getType())) {
            throw new IllegalStateException("StartDate or EndDate field is not of OffsetDateTime for " + object.getClass().getName());
        }
        ((Field)annotatedStartDates.get(0)).setAccessible(true);
        ((Field)annotatedEndDates.get(0)).setAccessible(true);
        try {
            OffsetDateTime startDate = (OffsetDateTime)((Field)annotatedStartDates.get(0)).get(object);
            OffsetDateTime endDate = (OffsetDateTime)((Field)annotatedEndDates.get(0)).get(object);
            return startDate != null && endDate != null && startDate.isBefore(endDate);
        }
        catch (IllegalAccessException e) {
            this.log.error("There was an error accessing the StartDate/EndDate fields for " + object.getClass().getName());
            return false;
        }
    }
}

