/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.validation;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
public class CrossParameterValidator {
    public <T extends Annotation> boolean validate(Object[] params, ConstraintValidatorContext context, String validationMessage, BiFunction<Field, Object[], Boolean> function, Class<T> annotationClass) {
        if (params == null || params.length == 0 || params[0] == null || params[1] == null) {
            return true;
        }
        AtomicBoolean valid = new AtomicBoolean(true);
        Arrays.stream(params[1].getClass().getDeclaredFields()).filter(field -> field.getType().getDeclaredAnnotation(Validated.class) != null).peek(field -> field.setAccessible(true)).forEach(field -> {
            try {
                valid.set(valid.get() && this.validate(new Object[]{params[0], field.get(params[1])}, context, validationMessage, function, annotationClass));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
        return Arrays.stream(params[1].getClass().getDeclaredFields()).filter(field -> field.getAnnotationsByType(annotationClass).length > 0).peek(field -> field.setAccessible(true)).filter(field -> (Boolean)function.apply((Field)field, params) == false).peek(field -> context.buildConstraintViolationWithTemplate(validationMessage).addPropertyNode(this.getFieldName((Field)field)).addConstraintViolation().disableDefaultConstraintViolation()).count() == 0L && valid.get();
    }

    private String getFieldName(Field field) {
        JsonProperty annotation = field.getAnnotation(JsonProperty.class);
        return annotation == null ? field.getName() : annotation.value();
    }
}

