/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.user;

import de.ponton.xmlpipe.rest.RequestUtils;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.user.UserDto;
import de.ponton.xmlpipe.rest.user.UserDtoFactory;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.UserRole;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerUserDAO;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/users"})
@Validated
public class UserAdminController {
    public static final String DOCUMENTATION_TAG = "User Administration";
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + UserAdminController.class.getName()));
    private final Logger log = LogManager.getLogger((String)("Messenger." + String.valueOf(this.getClass())));
    private final PontonUserDetailsServiceImpl userDetailsService;
    private final MessengerUserDAO messengerUserDAO;
    private final UserDtoFactory userDtoFactory;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public UserAdminController(PontonUserDetailsServiceImpl userDetailsService, MessengerUserDAO messengerUserDAO, UserDtoFactory userDtoFactory, ExceptionDtoFactory exceptionDtoFactory) {
        this.userDetailsService = userDetailsService;
        this.messengerUserDAO = messengerUserDAO;
        this.userDtoFactory = userDtoFactory;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @GetMapping
    @Operation(summary="Get Users", description="permission:ADMIN_USERS_GET<br><br>Return all users", tags={"User Administration"})
    @Secured(value={"ADMIN_USERS_GET"})
    public ResponseEntity<List<UserDto>> getUsers() {
        return ResponseEntity.ok(this.messengerUserDAO.getAll().stream().map(this.userDtoFactory::create).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{username}"})
    @Secured(value={"ADMIN_USERS_GET"})
    @Operation(summary="Get an User", description="permission:ADMIN_USERS_GET<br><br>Return a single user", tags={"User Administration"})
    public ResponseEntity<UserDto> getUser(@PathVariable String username) {
        try {
            MessengerUser messengerUser = this.userDetailsService.loadUserByUsername(username);
            return ResponseEntity.ok((Object)this.userDtoFactory.create(messengerUser));
        }
        catch (UsernameNotFoundException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @PostMapping
    @Secured(value={"ADMIN_USERS_POST"})
    @Validated(value={ValidationGroup.Create.class})
    @Operation(summary="Create an User", description="permission:ADMIN_USERS_POST<br><br>Create an user", tags={"User Administration"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<UserDto> postUser(@Valid @RequestBody UserDto userDto, Principal principal) throws Exception {
        this.userDetailsService.addUser(userDto.getUsername(), userDto.getPassword());
        this.userDetailsService.setLanguageForUser(userDto.getUsername(), userDto.getLanguage());
        this.userDetailsService.setCertificateForUser(userDto.getUsername(), userDto.getCertificate());
        this.userDetailsService.setRolesForUser(userDto.getUsername(), userDto.getRoles().stream().toList().toArray(new String[0]));
        AUDIT.info("{'{}', '{}' -> '{}'} User '{}' created.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)userDto.getUsername());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)userDto.setPassword(null));
    }

    @PutMapping(value={"/{username}"})
    @Secured(value={"ADMIN_USERS_PUT"})
    @Operation(summary="Update an User", description="permission:ADMIN_USERS_PUT<br><br>Update an user", tags={"User Administration"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> updateUser(Principal principal, @PathVariable String username, @Valid @RequestBody UserDto userDto) throws Exception {
        MessengerUser user = this.messengerUserDAO.getUser(username);
        if (user == null) {
            return ResponseEntity.notFound().build();
        }
        if (userDto.getPassword() != null && !"***".equals(userDto.getPassword())) {
            boolean shouldPasswordExpire = !username.equals(principal.getName());
            this.userDetailsService.setPasswordForUser(username, userDto.getPassword(), shouldPasswordExpire);
            this.userDetailsService.updateTotpSecret(username, null);
            this.userDetailsService.updateTotpEnabled(username, false);
            AUDIT.info("{'{}', '{}' -> '{}'} Password for user '{}' changed.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)username);
        }
        this.userDetailsService.setCertificateForUser(username, this.stripCertificate(userDto.getCertificate()));
        List<String> storedUserRoles = user.getRoles().stream().map(UserRole::getId).toList();
        List newUserRoles = userDto.getRoles().stream().toList();
        if (!storedUserRoles.containsAll(newUserRoles) || !newUserRoles.containsAll(storedUserRoles)) {
            ArrayList addedRoles = new ArrayList(newUserRoles);
            addedRoles.removeAll(storedUserRoles);
            ArrayList<String> removedRoles = new ArrayList<String>(storedUserRoles);
            removedRoles.removeAll(newUserRoles);
            AUDIT.info("{'{}', '{}' -> '{}'} Roles for user '{}' changed. Roles Added:'{}', Roles Removed:'{}', Current Roles:'{}'.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)username, addedRoles, removedRoles, userDto.getRoles().stream().toList());
            this.userDetailsService.setRolesForUser(username, newUserRoles.toArray(new String[0]));
        }
        return ResponseEntity.noContent().build();
    }

    private String stripCertificate(String certificate) {
        if (certificate == null) {
            return null;
        }
        return certificate.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\\s+", "");
    }

    @DeleteMapping(value={"/{username}"})
    @Secured(value={"ADMIN_USERS_DELETE"})
    @Operation(summary="Delete an User", description="permission:ADMIN_USERS_DELETE<br><br>Delete an user", tags={"User Administration"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteUser(@PathVariable String username, Principal principal) {
        if (this.messengerUserDAO.getUser(username) == null) {
            return ResponseEntity.notFound().build();
        }
        this.userDetailsService.deleteUser(username);
        AUDIT.info("{'{}', '{}' -> '{}'} User '{}' deleted.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)username);
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={InstallCertException.class, CertificateException.class, NoSuchProviderException.class, KeyStoreException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    ResponseEntity<ExceptionDto> onConstraintValidationException(ConstraintViolationException e) {
        this.log.error("Constraint violation detected. Error: {}", (Object)e.getMessage());
        ExceptionDto error = this.exceptionDtoFactory.create((Throwable)e);
        e.getConstraintViolations().forEach(error::addViolation);
        return ResponseEntity.badRequest().body((Object)error);
    }
}

