/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.testadapter;

import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.validation.PartnerAccessConstraint;
import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.test.TestAdapter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotBlank;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/testadapter"})
public class TestAdapterController {
    public static final String DOCUMENTATION_TAG = "Test Adapter";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final TestAdapter testAdapter;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public TestAdapterController(TestAdapter testAdapter, ExceptionDtoFactory exceptionDtoFactory) {
        this.testAdapter = testAdapter;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @PostConstruct
    public void postConstruct() throws AdapterException, JAXBException, IOException {
        this.testAdapter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Send a test message", description="permission:TEST_ADAPTER_POST<br><br>Send a test message with content defined in passed parameter from a sender to a receiver, both specified by the passed id's. Returns the message-result from messenger", tags={"Test Adapter"})
    @PostMapping(consumes={"multipart/form-data"})
    @Secured(value={"TEST_ADAPTER_POST"})
    public ResponseEntity<MessageResult> sendMessage(@RequestParam @Parameter(description="The local id of the sender") @NotBlank @PartnerAccessConstraint String senderLocalID, @RequestParam @Parameter(description="The local id of the receiver") @NotBlank String receiverLocalID, @RequestPart @Parameter(description="The content of the message") MultipartFile file, @RequestParam(defaultValue="false") @Parameter(description="The test flag") boolean test) throws AdapterException, IOException {
        Path path = Files.createTempFile(file.getOriginalFilename(), null, new FileAttribute[0]);
        try {
            file.transferTo(path);
            MessageResult messageResult = this.testAdapter.sendMessage(path.toUri().toURL(), file.getOriginalFilename(), senderLocalID, receiverLocalID, test);
            ResponseEntity responseEntity = ResponseEntity.status((int)messageResult.getHttpCode()).body((Object)messageResult);
            return responseEntity;
        }
        finally {
            Files.deleteIfExists(path);
        }
    }

    @Operation(summary="Send a ping message", description="permission:TEST_ADAPTER_PING_GET<br><br>Send a ping message from a sender to a receiver, both specified by the passed id's. Returns the message-result from messenger", tags={"Test Adapter"})
    @GetMapping(value={"/ping"})
    @Secured(value={"TEST_ADAPTER_PING_GET"})
    public ResponseEntity<MessageResult> ping(@RequestParam @Parameter(description="The local id of the sender") @NotBlank @PartnerAccessConstraint String senderLocalID, @RequestParam @Parameter(description="The local id of receiver") @NotBlank String receiverLocalID) throws AdapterException {
        MessageResult messageResult = this.testAdapter.sendPing(senderLocalID, receiverLocalID);
        return ResponseEntity.status((int)messageResult.getHttpCode()).body((Object)messageResult);
    }

    @ExceptionHandler(value={IOException.class, IllegalStateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleInternalServerError(Exception e) {
        this.log.error(String.format("Unexpected error when accessing test adapter. Error: %s", e.getMessage()), (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={AdapterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleAdapterException(AdapterException e) {
        this.log.error(String.format("Error when accessing test adapter. Error: %s", e.getMessage()), (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create((Throwable)e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

