/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.status.ListenerStatusDto;
import de.ponton.xmlpipe.rest.status.ListenerStatusService;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/status/listener"})
@Validated
public class ListenerStatusController {
    public static final String DOCUMENTATION_TAG = "Status";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final ListenerStatusService listenerStatusService;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public ListenerStatusController(ListenerStatusService listenerStatusService, ExceptionDtoFactory exceptionDtoFactory) {
        this.listenerStatusService = listenerStatusService;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @GetMapping
    @Operation(summary="Get the status of the listener or respond with HTTP error NOT_FOUND when the listener could be be reached", description="permission:STATUS_LISTENER_GET", tags={"Status"})
    @Secured(value={"STATUS_LISTENER_GET"})
    public ResponseEntity<List<ListenerStatusDto>> getListenerStatus() throws ListenerConfigException {
        List<ListenerStatusDto> listenerStatus = this.listenerStatusService.getListenerStatus();
        if (listenerStatus.stream().noneMatch(e -> e.getUptime() > 0L)) {
            this.log.trace("No listener is connected, returning HTTP NOT_FOUND");
            throw new ListenerConfigException(47001, "No Listener is connected");
        }
        this.log.trace("Current Listener status returned successfully");
        return ResponseEntity.ok(listenerStatus);
    }

    @ExceptionHandler(value={ListenerConfigException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleInternalServerError(Exception e) {
        this.log.trace(String.format("Listener is not connected. Error: %s", e.getMessage()));
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

