/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ponton.xmlpipe.rest.status.MessengerInfoDto;
import de.ponton.xmlpipe.rest.status.PartnerProfileExchangeFormat;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.HttpAdapterInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.ListenerFTPUser;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerActivation;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerLicense;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerAgreement;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PlugableAdapterConfig;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.RemoteMaintenanceInterval;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.UserRole;
import de.pontonconsulting.xmlpipe.messenger.database.tables.HttpAdapterInfoDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.ListenerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerActivationDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerAddOnDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerUserDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerAgreementDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.RemoteMaintenanceIntervalDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.UserRoleDAO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ConfigurationImporter {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + ConfigurationImporter.class.getName()));
    private final ObjectMapper objectMapper;
    private final IServerConfigBean serverConfigBean;
    private final MessengerConfigDAO messengerConfigDAO;
    private final PartnerAgreementDAO partnerAgreementDAO;
    private final PartnerProfileDAO partnerProfileDAO;
    private final Profiles profiles;
    private final MessengerActivationDAO messengerActivationDAO;
    private final ListenerConfigDAO listenerConfigDAO;
    private final HttpAdapterInfoDAO httpAdapterInfoDAO;
    private final RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO;
    private final MessengerAddOnDAO messengerAddOnDAO;
    private final MessengerUserDAO messengerUserDAO;
    private final UserRoleDAO userRoleDAO;
    private String messengerVersion;
    private static final String MESSENGER_INFO_FILE = "export/metadata/messengerInfo.json";
    private static final String DATABASE_PREFIX = "export/database/";
    private static final String CONFIG_FOLDER_PREFIX = "export/configfolder/";
    private static final String DB_FILE_PROFILES = "export/database/profiles.json";
    private static final String DB_FILE_AGREEMENTS = "export/database/agreements.json";
    private static final String DB_FILE_MESSENGER_CONFIGS = "export/database/messengerConfigs.json";
    private static final String DB_FILE_ACTIVATIONS = "export/database/messengerActivations.json";
    private static final String DB_FILE_LICENSES = "export/database/messengerLicenses.json";
    private static final String DB_FILE_LISTENER_FTP_USERS = "export/database/listenerFtpUsers.json";
    private static final String DB_FILE_LISTENER_CERTIFICATES = "export/database/listenerCertificates.json";
    private static final String DB_FILE_MESSENGER_USERS = "export/database/messengerUsers.json";
    private static final String DB_FILE_USER_ROLES = "export/database/userRoles.json";
    private static final String DB_FILE_HTTP_ADAPTER_INFOS = "export/database/httpAdapterInfos.json";
    private static final String DB_FILE_REMOTE_MAINTENANCE_INTERVALS = "export/database/remoteMaintenanceIntervals.json";

    public ConfigurationImporter(ObjectMapper objectMapper, IServerConfigBean serverConfigBean, MessengerConfigDAO messengerConfigDAO, PartnerAgreementDAO partnerAgreementDAO, PartnerProfileDAO partnerProfileDAO, Profiles profiles, MessengerActivationDAO messengerActivationDAO, ListenerConfigDAO listenerConfigDAO, HttpAdapterInfoDAO httpAdapterInfoDAO, RemoteMaintenanceIntervalDAO remoteMaintenanceIntervalDAO, MessengerAddOnDAO messengerAddOnDAO, MessengerUserDAO messengerUserDAO, UserRoleDAO userRoleDAO) {
        this.objectMapper = objectMapper;
        this.serverConfigBean = serverConfigBean;
        this.messengerConfigDAO = messengerConfigDAO;
        this.partnerAgreementDAO = partnerAgreementDAO;
        this.partnerProfileDAO = partnerProfileDAO;
        this.profiles = profiles;
        this.messengerAddOnDAO = messengerAddOnDAO;
        this.messengerUserDAO = messengerUserDAO;
        this.messengerVersion = this.getMajorMinorVersion(Constants.getXP_VERSION());
        this.messengerActivationDAO = messengerActivationDAO;
        this.listenerConfigDAO = listenerConfigDAO;
        this.httpAdapterInfoDAO = httpAdapterInfoDAO;
        this.remoteMaintenanceIntervalDAO = remoteMaintenanceIntervalDAO;
        this.userRoleDAO = userRoleDAO;
    }

    public void importConfigFile(MultipartFile configFileZip) throws IOException {
        LOG.info("Start import of config file zip {}", (Object)configFileZip.getOriginalFilename());
        Path configImportDir = this.extractZipToTempDirectory(configFileZip);
        this.checkFileVersion(configImportDir);
        this.importToConfigFolder(configImportDir);
        this.importToDatabase(configImportDir);
        this.deleteTempDirectory(configImportDir);
        LOG.info("Finished import of config file zip");
    }

    private Path extractZipToTempDirectory(MultipartFile configFileZip) throws IOException {
        Path tempDir = Files.createTempDirectory("configFileZip", new FileAttribute[0]);
        try (ZipInputStream zis = new ZipInputStream(configFileZip.getInputStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                Path newFile = tempDir.resolve(entry.getName()).normalize();
                if (!newFile.startsWith(tempDir.normalize())) {
                    LOG.error("tmpDir {} / newFile {}", (Object)tempDir, (Object)newFile);
                    throw new IOException("Path out of target dir: " + String.valueOf(newFile));
                }
                Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
                Files.copy(zis, newFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return tempDir;
    }

    private void deleteTempDirectory(Path configTempDir) {
        try {
            FileUtils.deleteDirectory((File)configTempDir.toFile());
        }
        catch (IOException e) {
            LOG.warn("Could not delete directory {}", (Object)configTempDir, (Object)e);
        }
    }

    private void importToConfigFolder(Path configTempDir) throws IOException {
        File configFolderImportDir = configTempDir.resolve(CONFIG_FOLDER_PREFIX).toFile();
        if (!configFolderImportDir.exists() || Objects.requireNonNull(configFolderImportDir.list()).length == 0) {
            return;
        }
        File targetConfigFolder = this.serverConfigBean.getConfigFolder();
        FileUtils.copyDirectory((File)configFolderImportDir, (File)targetConfigFolder);
        File plugableAdapterConfigFolder = new File(this.serverConfigBean.getConfigFolder(), "plugableAdapterConfigs");
        if (Files.notExists(plugableAdapterConfigFolder.toPath(), new LinkOption[0])) {
            Files.createDirectory(plugableAdapterConfigFolder.toPath(), new FileAttribute[0]);
        }
        for (File file : Objects.requireNonNull(plugableAdapterConfigFolder.listFiles(e -> !e.isDirectory()))) {
            PlugableAdapterConfig plugableAdapterConfig = new PlugableAdapterConfig().setData(Files.readAllBytes(file.toPath()));
            plugableAdapterConfig.setFilename(file.getName());
            plugableAdapterConfig.setTimestamp(OffsetDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), ZoneOffset.UTC));
            this.messengerAddOnDAO.storePlugableAdapterConfig(plugableAdapterConfig);
        }
    }

    private void importToDatabase(Path configImportDir) throws IOException {
        this.importProfiles(configImportDir.resolve(DB_FILE_PROFILES).toFile());
        this.importAgreements(configImportDir.resolve(DB_FILE_AGREEMENTS).toFile());
        this.importActivations(configImportDir.resolve(DB_FILE_ACTIVATIONS).toFile());
        this.importLicenses(configImportDir.resolve(DB_FILE_LICENSES).toFile());
        this.importMessengerConfigs(configImportDir.resolve(DB_FILE_MESSENGER_CONFIGS).toFile());
        this.importListenerFtpUsers(configImportDir.resolve(DB_FILE_LISTENER_FTP_USERS).toFile());
        this.importListenerCertificates(configImportDir.resolve(DB_FILE_LISTENER_CERTIFICATES).toFile());
        this.importHttpAdapterInfos(configImportDir.resolve(DB_FILE_HTTP_ADAPTER_INFOS).toFile());
        this.importRemoteMaintenanceIntervals(configImportDir.resolve(DB_FILE_REMOTE_MAINTENANCE_INTERVALS).toFile());
        this.importUserRoles(configImportDir.resolve(DB_FILE_USER_ROLES).toFile());
        this.importMessengerUsers(configImportDir.resolve(DB_FILE_MESSENGER_USERS).toFile());
    }

    private void importProfiles(File profilesFile) throws IOException {
        if (!profilesFile.exists()) {
            return;
        }
        List partnerProfiles = (List)this.objectMapper.readValue(profilesFile, (TypeReference)new TypeReference<List<PartnerProfileExchangeFormat>>(this){});
        partnerProfiles.forEach(partnerProfileExchangeFormat -> {
            try {
                CppPartner cppPartner = this.profiles.parseCppPartner(partnerProfileExchangeFormat.getPartnerId(), new ByteArrayInputStream(partnerProfileExchangeFormat.getPublicProfile()), new ByteArrayInputStream(partnerProfileExchangeFormat.getPrivateProfile()));
                this.partnerProfileDAO.storePartnerProfile(cppPartner, partnerProfileExchangeFormat.getLastChange().toInstant().toEpochMilli(), partnerProfileExchangeFormat.getUsername());
                LOG.info("Imported PartnerProfile {}", (Object)partnerProfileExchangeFormat.getPartnerId());
            }
            catch (ProfileException e) {
                LOG.error("Error importing PartnerProfile {}", (Object)partnerProfileExchangeFormat.getPartnerId(), (Object)e);
            }
        });
    }

    private void importAgreements(File agreementsFile) throws IOException {
        if (!agreementsFile.exists()) {
            return;
        }
        List agreements = (List)this.objectMapper.readValue(agreementsFile, (TypeReference)new TypeReference<List<PartnerAgreement>>(this){});
        for (PartnerAgreement agreement : agreements) {
            this.partnerAgreementDAO.importPartnerAgreement(agreement);
            LOG.info("Imported Agreement {} ({} => {})", (Object)agreement.getId(), (Object)agreement.getOwnPartnerId(), (Object)agreement.getCommunicationPartnerId());
        }
    }

    private void importActivations(File activationsFile) throws IOException {
        if (!activationsFile.exists()) {
            return;
        }
        List activations = (List)this.objectMapper.readValue(activationsFile, (TypeReference)new TypeReference<List<MessengerActivation>>(this){});
        for (MessengerActivation activation : activations) {
            this.messengerActivationDAO.importMessengerActivation(activation);
            LOG.info("Imported Activation {} ({})", (Object)activation.getInstanceId(), (Object)new String(activation.getProductKey()));
        }
    }

    private void importMessengerUsers(File usersFile) throws IOException {
        if (!usersFile.exists()) {
            return;
        }
        List messengerUsers = (List)this.objectMapper.readValue(usersFile, (TypeReference)new TypeReference<List<MessengerUser>>(this){});
        for (MessengerUser messengerUser : messengerUsers) {
            this.messengerUserDAO.save(messengerUser);
            LOG.info("Imported Messenger User {}", (Object)messengerUser.getUsername());
        }
    }

    private void importUserRoles(File usersFile) throws IOException {
        if (!usersFile.exists()) {
            return;
        }
        List userRoles = (List)this.objectMapper.readValue(usersFile, (TypeReference)new TypeReference<List<UserRole>>(this){});
        for (UserRole userRole : userRoles) {
            this.userRoleDAO.save(userRole);
            LOG.info("Imported User Role {}", (Object)userRole.getId());
        }
    }

    private void importLicenses(File licensesFile) throws IOException {
        if (!licensesFile.exists()) {
            return;
        }
        List licenses = (List)this.objectMapper.readValue(licensesFile, (TypeReference)new TypeReference<List<MessengerLicense>>(this){});
        for (MessengerLicense license : licenses) {
            this.messengerActivationDAO.importMessengerLicense(license);
            LOG.info("Imported License {}", (Object)license.getId());
        }
    }

    private void importListenerFtpUsers(File ftpUsersFile) throws IOException {
        if (!ftpUsersFile.exists()) {
            return;
        }
        List listenerFTPUsers = (List)this.objectMapper.readValue(ftpUsersFile, (TypeReference)new TypeReference<List<ListenerFTPUser>>(this){});
        for (ListenerFTPUser listenerFTPUser : listenerFTPUsers) {
            this.listenerConfigDAO.importFtpUser(listenerFTPUser);
            LOG.info("Imported ListenerFTPUser {}", (Object)listenerFTPUser);
        }
    }

    private void importListenerCertificates(File certificatesFiles) throws IOException {
        if (!certificatesFiles.exists()) {
            return;
        }
        List listenerCertificates = (List)this.objectMapper.readValue(certificatesFiles, (TypeReference)new TypeReference<List<ListenerCertificate>>(this){});
        for (ListenerCertificate listenerCertificate : listenerCertificates) {
            this.listenerConfigDAO.saveListenerCertificate(listenerCertificate);
            LOG.info("Imported ListenerCertificate {}", (Object)listenerCertificate);
        }
    }

    private void importHttpAdapterInfos(File adapterInfoFile) throws IOException {
        if (!adapterInfoFile.exists()) {
            return;
        }
        List httpAdapterInfos = (List)this.objectMapper.readValue(adapterInfoFile, (TypeReference)new TypeReference<List<HttpAdapterInfo>>(this){});
        for (HttpAdapterInfo httpAdapterInfo : httpAdapterInfos) {
            this.httpAdapterInfoDAO.importHttpAdapter(httpAdapterInfo);
            LOG.info("Imported HttpAdapterInfo {}", (Object)httpAdapterInfo);
        }
    }

    private void importMessengerConfigs(File configsFile) throws IOException {
        if (!configsFile.exists()) {
            return;
        }
        List configs = (List)this.objectMapper.readValue(configsFile, (TypeReference)new TypeReference<List<MessengerConfig>>(this){});
        for (MessengerConfig config : configs) {
            this.messengerConfigDAO.importMessengerConfig(config);
            LOG.info("Imported MessengerConfig {}", (Object)config.getType());
        }
    }

    private void importRemoteMaintenanceIntervals(File remoteMaintenacneIntervalFile) throws IOException {
        if (!remoteMaintenacneIntervalFile.exists()) {
            return;
        }
        List remoteMaintenanceIntervals = (List)this.objectMapper.readValue(remoteMaintenacneIntervalFile, (TypeReference)new TypeReference<List<RemoteMaintenanceInterval>>(this){});
        this.remoteMaintenanceIntervalDAO.replaceAll(remoteMaintenanceIntervals);
    }

    private void checkFileVersion(Path configTempDir) throws IOException {
        File messengerInfoFile = configTempDir.resolve(MESSENGER_INFO_FILE).toFile();
        if (!messengerInfoFile.exists()) {
            LOG.error("{} not found in ConfigFileZip", (Object)MESSENGER_INFO_FILE);
            throw new FileNotFoundException("export/metadata/messengerInfo.json not found in ConfigFileZip");
        }
        MessengerInfoDto messengerInfoDto = (MessengerInfoDto)this.objectMapper.readValue(messengerInfoFile, MessengerInfoDto.class);
        String fileVersion = this.getMajorMinorVersion(messengerInfoDto.getVersion());
        if (!this.messengerVersion.equals(fileVersion)) {
            LOG.error("Found {} in config file zip with MessengerVersion {}. Supported MessengerVersion is {}", (Object)MESSENGER_INFO_FILE, (Object)fileVersion, (Object)this.messengerVersion);
            throw new IllegalStateException("Invalid MessengerVersion of ConfigFileZip. Required MessengerVersion is: " + this.messengerVersion);
        }
        LOG.info("Found {} in config file zip with MessengerVersion {}", (Object)MESSENGER_INFO_FILE, (Object)fileVersion);
    }

    private String getMajorMinorVersion(String version) {
        return version.substring(0, version.indexOf(46, version.indexOf(46) + 1) + 1) + "x";
    }

    void setMessengerVersion(String messengerVersion) {
        this.messengerVersion = messengerVersion;
    }
}

