/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.server;

import de.ponton.xmlpipe.rest.settings.server.ServerProtocol;
import de.ponton.xmlpipe.rest.settings.server.Service;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import java.util.Set;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about a connector for the server configuration of the messenger.")
public class ConnectorDto {
    @NotNull
    @Schema(description="The protocol to reach the connector.")
    private ServerProtocol protocol;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The port on which the connector should run.")
    private @NotNull @Min(value=1L) @Max(value=65535L) Integer port;
    @NotNull
    @Size(min=1)
    @Schema(description="A list of services to be served by the connector.")
    private @NotNull @Size(min=1) Set<Service> services;

    public ServerProtocol getProtocol() {
        return this.protocol;
    }

    public ConnectorDto setProtocol(ServerProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public ConnectorDto setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Set<Service> getServices() {
        return this.services;
    }

    public ConnectorDto setServices(Set<Service> services) {
        this.services = services;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorDto)) {
            return false;
        }
        ConnectorDto that = (ConnectorDto)o;
        return this.protocol == that.protocol && Objects.equals(this.port, that.port) && Objects.equals(this.services, that.services);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.protocol, this.port, this.services});
    }

    public String toString() {
        return "ConnectorDto{protocol=" + String.valueOf((Object)this.protocol) + ", port=" + this.port + ", services=" + String.valueOf(this.services) + "}";
    }
}

