/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.listener;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="To connect the Messenger to the Listener, the hostname or IP address and the Listener communication port has to be entered. The connection is established from the Messenger to the Listener. If there is a firewall between Messenger and Listener, it has to allow creating a TCP connection from the Messenger to the Listener communication port. The default portnumber is '9000'. The Listener will only accept connections from known Messenger instances which are listed in the ListenerConfiguration\\config\\authorization.txt File in the Listener Installation. The Messenger Instance ID is logged in the ListenerInstallation\\logs\\listener.log when the Messenger is trying to connect to the Listener.")
public class ListenerConnectionDto {
    @Schema(description="Set to true to connect the messenger to the specified listener, set to false to disable using the listener.")
    private boolean enabled;
    @NotNull
    @NotBlank
    @Schema(description="The host name or IP of the listener.")
    @TrimmedField
    private String host;
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The port of the listener.")
    private @Min(value=1L) @Max(value=65535L) int port;
    @Schema(description="Set to true if the listener uses SSL for the messenger connection, otherwise set it to false.")
    private boolean useSsl;
    @Min(value=1L)
    @Max(value=100L)
    @Schema(description="The number of data connections for incoming messages, which can be received at the same time.")
    private @Min(value=1L) @Max(value=100L) int numberOfDataConnections;

    public boolean isEnabled() {
        return this.enabled;
    }

    public ListenerConnectionDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ListenerConnectionDto setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ListenerConnectionDto setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public ListenerConnectionDto setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
        return this;
    }

    public int getNumberOfDataConnections() {
        return this.numberOfDataConnections;
    }

    public ListenerConnectionDto setNumberOfDataConnections(int numberOfDataConnections) {
        this.numberOfDataConnections = numberOfDataConnections;
        return this;
    }
}

