/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.common.authentication.AuthenticationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.XpEmailOutboundProtocol;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the email outbound configuration of the messenger for sending emails.")
public class EmailOutboundDto {
    @NotNull
    @Email
    @Schema(description="This is your sender setting for outgoing emails. An outgoing email could be an XML message, an email notification, or a certificate request.")
    @TrimmedField
    private String from;
    @NotNull
    @Schema(description="These settings configure your email server for outgoing XML messages (via SMTP). SMTP and SMTPS servers are both supported. It is also possible to use SMTP+STARTTLS.")
    private XpEmailOutboundProtocol protocol;
    @NotNull
    @Schema(description="Your SMTP server for outgoing emails.")
    private URI host;
    @Valid
    @Schema(description="If your SMTP server requires authentication, please configure your authentication information here. If not, omit these information.")
    private AuthenticationDto authentication;

    public String getFrom() {
        return this.from;
    }

    public EmailOutboundDto setFrom(String from) {
        this.from = from;
        return this;
    }

    public XpEmailOutboundProtocol getProtocol() {
        return this.protocol;
    }

    public EmailOutboundDto setProtocol(XpEmailOutboundProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public URI getHost() {
        return this.host;
    }

    public EmailOutboundDto setHost(URI host) {
        this.host = host;
        return this;
    }

    public AuthenticationDto getAuthentication() {
        return this.authentication;
    }

    public EmailOutboundDto setAuthentication(AuthenticationDto authentication) {
        this.authentication = authentication;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailOutboundDto)) {
            return false;
        }
        EmailOutboundDto that = (EmailOutboundDto)o;
        return Objects.equals(this.from, that.from) && this.protocol == that.protocol && Objects.equals(this.host, that.host) && Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.protocol, this.host, this.authentication});
    }

    public String toString() {
        return "EmailOutboundDto{from='" + this.from + "', protocol=" + String.valueOf((Object)this.protocol) + ", host=" + String.valueOf(this.host) + ", authentication=" + String.valueOf(this.authentication) + "}";
    }
}

