/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.communication;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the information about ping all behaviour for the communication configuration of the messenger.")
public class PingAllDto {
    @Schema(description="Set to true to enable this feature, set to false to disable it.")
    private boolean pingAll;
    @NotNull
    @Min(value=1L)
    @Schema(description="The interval in minutes at which a ping all is done.")
    private @NotNull @Min(value=1L) Integer pingAllInterval;

    public boolean isPingAll() {
        return this.pingAll;
    }

    public PingAllDto setPingAll(boolean pingAll) {
        this.pingAll = pingAll;
        return this;
    }

    public Integer getPingAllInterval() {
        return this.pingAllInterval;
    }

    public PingAllDto setPingAllInterval(Integer pingAllInterval) {
        this.pingAllInterval = pingAllInterval;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PingAllDto)) {
            return false;
        }
        PingAllDto that = (PingAllDto)o;
        return this.pingAll == that.pingAll && Objects.equals(this.pingAllInterval, that.pingAllInterval);
    }

    public int hashCode() {
        return Objects.hash(this.pingAll, this.pingAllInterval);
    }

    public String toString() {
        return "PingAllDto{pingAll=" + this.pingAll + ", pingAllInterval=" + this.pingAllInterval + "}";
    }
}

