/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings;

import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.settings.MessengerConfigurationDto;
import de.ponton.xmlpipe.rest.settings.MessengerConfigurationDtoFactory;
import de.ponton.xmlpipe.rest.settings.archive.ArchiverType;
import de.ponton.xmlpipe.rest.validation.ValidationGroup;
import de.pontonconsulting.xmlpipe.config.MessengerConfigLoader;
import de.pontonconsulting.xmlpipe.config.MessengerConfigUpdateManager;
import de.pontonconsulting.xmlpipe.config.model.messenger.XpMessengerConfigurationDto;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import jakarta.xml.bind.JAXBException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/configuration"})
@Validated
public class MessengerConfigurationController {
    public static final String DOCUMENTATION_TAG = "Messenger Configuration";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final ExceptionDtoFactory exceptionDtoFactory;
    private final MessengerConfigLoader configLoader;
    private final MessengerConfigurationDtoFactory configurationDtoFactory;
    private final MessengerConfigUpdateManager updateManager;

    public MessengerConfigurationController(MessengerConfigLoader configLoader, MessengerConfigurationDtoFactory configurationDtoFactory, ExceptionDtoFactory exceptionDtoFactory, MessengerConfigUpdateManager updateManager) {
        this.configLoader = Objects.requireNonNull(configLoader, "MessengerConfigurationController requires MessengerConfigLoader.");
        this.configurationDtoFactory = Objects.requireNonNull(configurationDtoFactory, "MessengerConfigurationController requires MessengerConfigurationDtoFactory.");
        this.exceptionDtoFactory = Objects.requireNonNull(exceptionDtoFactory, "MessengerConfigurationController requires ExceptionDtoFactory.");
        this.updateManager = Objects.requireNonNull(updateManager, "MessengerConfigurationController requires MessengerConfigUpdateManager.");
    }

    @GetMapping
    @Operation(summary="Get the messenger configuration", description="permission:CONFIGURATION_GET<br><br>Returns the messenger configuration", tags={"Messenger Configuration"})
    @Secured(value={"CONFIGURATION_GET"})
    @ResponseBody
    public ResponseEntity<MessengerConfigurationDto> getMessengerConfiguration() throws MalformedURLException, JAXBException, URISyntaxException {
        XpMessengerConfigurationDto xpConfigurationDto = this.configLoader.getConfigurationDto();
        MessengerConfigurationDto configurationDto = this.configurationDtoFactory.create(xpConfigurationDto);
        return ResponseEntity.ok((Object)configurationDto);
    }

    @PutMapping
    @Secured(value={"CONFIGURATION_PUT"})
    @Operation(summary="Update the messenger configuration", description="permission:CONFIGURATION_PUT<br><br>The passed configuration will be updated on the messenger.", tags={"Messenger Configuration"})
    @Validated(value={ValidationGroup.Update.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> updateMessengerConfiguration(@RequestBody @Valid MessengerConfigurationDto configurationDto, Principal principal) throws JAXBException {
        if (configurationDto.getArchive() != null && ArchiverType.WEB_SOCKET == configurationDto.getArchive().getArchiverType() && (configurationDto.getArchive().getAdapterId() == null || configurationDto.getArchive().getAdapterId().isEmpty())) {
            throw new IllegalArgumentException("AdapterId must be set for archiverType WEB_SOCKET");
        }
        if (configurationDto.getArchive() != null && ArchiverType.FILE_SYSTEM == configurationDto.getArchive().getArchiverType() && (configurationDto.getArchive().getArchiveFolder() == null || configurationDto.getArchive().getArchiveFolder().isEmpty() || configurationDto.getArchive().getArchiveFailedFolder() == null || configurationDto.getArchive().getArchiveFailedFolder().isEmpty())) {
            throw new IllegalArgumentException("ArchiveFolder and ArchiveFailedFolder must be set for archiverType FILE_SYSTEM");
        }
        XpMessengerConfigurationDto xpConfigurationDto = this.configurationDtoFactory.parse(configurationDto);
        this.updateManager.updateConfiguration(xpConfigurationDto);
        this.updateManager.save(principal.getName());
        return ResponseEntity.noContent().build();
    }

    @ExceptionHandler(value={MalformedURLException.class, JAXBException.class, URISyntaxException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> handleInternalServerError(Exception e) {
        this.log.error(String.format("Unexpected error when accessing messenger configuration. Error: %s", e.getMessage()), (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

