/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagetype;

import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.messagetype.MessageTypeDto;
import de.ponton.xmlpipe.rest.messagetype.MessageTypeDtoFactory;
import de.pontonconsulting.xmlpipe.config.InvalidSchemaSetException;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemaSetInstaller;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/messagetype"})
public class MessageTypeController {
    public static final String DOCUMENTATION_TAG = "Message Type";
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageTypeController.class.getName()));
    private final MessageTypeDtoFactory messageTypeDtoFactory;
    private final SchemataConfig schemataConfig;
    private final SchemaSetInstaller schemaSetInstaller;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public MessageTypeController(MessageTypeDtoFactory messageTypeDtoFactory, SchemataConfig schemataConfig, SchemaSetInstaller schemaSetInstaller, ExceptionDtoFactory exceptionDtoFactory) {
        this.messageTypeDtoFactory = messageTypeDtoFactory;
        this.schemataConfig = schemataConfig;
        this.schemaSetInstaller = schemaSetInstaller;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @GetMapping
    @Operation(summary="Get all Message Types", description="permission:MESSAGE_TYPE_GET<br><br>Return a list of all message types", tags={"Message Type"})
    @Secured(value={"MESSAGE_TYPE_GET"})
    @ResponseBody
    public ResponseEntity<List<MessageTypeDto>> getMessageTypes() {
        return ResponseEntity.ok(this.schemataConfig.getAllSchemaData().stream().map(this.messageTypeDtoFactory::create).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get a Message Type", description="permission:MESSAGE_TYPE_GET<br><br>Return a message type", tags={"Message Type"})
    @Secured(value={"MESSAGE_TYPE_GET"})
    @ResponseBody
    public ResponseEntity<MessageTypeDto> getMessageType(@PathVariable String id) {
        return Optional.ofNullable(this.schemataConfig.findSchemaDataById(id)).map(e -> ResponseEntity.ok((Object)this.messageTypeDtoFactory.create((SchemaData)e))).orElse(ResponseEntity.notFound().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @Operation(summary="Upload a ZIP archive containing one or more SchemaSet(s) of Message Types", description="permission:MESSAGE_TYPE_POST<br><br>The ZIP archive needs to contain schemaset definition xml files at the root level. Optionally there can be sub-folders with XSD files for validation", tags={"Message Type"})
    @Secured(value={"MESSAGE_TYPE_POST"})
    @ResponseBody
    public ResponseEntity<List<MessageTypeDto>> uploadSchemaSet(@RequestPart(value="zipFile") MultipartFile archive, Principal principal) throws IOException, ProfileException, InvalidSchemaSetException {
        Path file = null;
        try {
            file = Files.createTempFile(archive.getOriginalFilename(), null, new FileAttribute[0]);
            archive.transferTo(file);
            this.schemaSetInstaller.installNewSchemaSet(file.toFile(), principal.getName());
            if (file == null) return ResponseEntity.ok(this.schemataConfig.getAllSchemaData().stream().map(this.messageTypeDtoFactory::create).collect(Collectors.toList()));
        }
        catch (Throwable throwable) {
            if (file == null) throw throwable;
            Files.delete(file);
            throw throwable;
        }
        Files.delete(file);
        return ResponseEntity.ok(this.schemataConfig.getAllSchemaData().stream().map(this.messageTypeDtoFactory::create).collect(Collectors.toList()));
    }

    @ExceptionHandler(value={IOException.class, ProfileException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ExceptionDto> createInternalServerError(Exception e) {
        LOG.error(String.format("Unexpected error when accessing message types. Error: %s", e.getMessage()), (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

