/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemulticastrule;

import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRuleDto;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRuleDtoFactory;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRuleService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/messageMulticastRules"})
public class MessageMulticastRuleController {
    public static final String DOCUMENTATION_TAG = "Multicast Rules";
    private final MessageMulticastRuleDtoFactory messageMulticastRuleDtoFactory;
    private final MessageMulticastRuleService messageMulticastRuleService;

    public MessageMulticastRuleController(MessageMulticastRuleDtoFactory messageMulticastRuleDtoFactory, MessageMulticastRuleService messageMulticastRuleService) {
        this.messageMulticastRuleDtoFactory = messageMulticastRuleDtoFactory;
        this.messageMulticastRuleService = messageMulticastRuleService;
    }

    @GetMapping
    @Secured(value={"MESSAGE_MULTICAST_RULES_GET"})
    @Operation(summary="Show all the available routing rules", description="permission:MESSAGE_MULTICAST_RULES_GET<br><br>A list of available routing rules is returned.", tags={"Multicast Rules"})
    @ResponseBody
    public ResponseEntity<List<MessageMulticastRuleDto>> getMessageMulticastRules() {
        return ResponseEntity.ok(this.messageMulticastRuleService.getMessageMulticastOutboundRules().stream().map(this.messageMulticastRuleDtoFactory::create).collect(Collectors.toList()));
    }

    @PutMapping
    @Secured(value={"MESSAGE_MULTICAST_RULES_PUT"})
    @Operation(summary="Create a new routing rule set", description="permission:MESSAGE_MULTICAST_RULES_PUT<br><br>A new routing rule set is created.", tags={"Multicast Rules"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Validated
    public ResponseEntity<Void> putMessageMulticastRules(@RequestBody @Valid List<MessageMulticastRuleDto> messageMulticastRuleDtos, Principal principal) {
        this.messageMulticastRuleService.putMessageMulticastOutboundRules(messageMulticastRuleDtos.stream().map(this.messageMulticastRuleDtoFactory::parse).collect(Collectors.toList()), principal.getName());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }
}

